/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class Captcha {
    private static String PNG = "png";
    private static int WIDTH;
    private static int HEIGHT;

    public static List<String> imageCutout(File templateFile, File originFile, File blockFile) throws Exception {
        ArrayList<String> imgList = new ArrayList<String>();
        BufferedImage templateImage = ImageIO.read(templateFile);
        WIDTH = templateImage.getWidth();
        HEIGHT = templateImage.getHeight();
        BufferedImage target = Captcha.cutTargetArea(originFile);
        BufferedImage block = ImageIO.read(blockFile);
        Point pt = Captcha.getCutPoint(block, 3, 5);
        BufferedImage newImage = Captcha.getMaskImage(target, block, pt);
        target = Captcha.cutoutByBlock(target, block, pt);
        imgList.add(Captcha.imgEncode(Captcha.toByteArray(target)));
        imgList.add(Captcha.imgEncode(Captcha.toByteArray(newImage)));
        imgList.add(String.valueOf(pt.y));
        return imgList;
    }

    private static BufferedImage cutTargetArea(File originFile) throws Exception {
        BufferedImage originImage = ImageIO.read(originFile);
        int ORI_W = originImage.getWidth();
        int ORI_H = originImage.getHeight();
        Point point = Captcha.randomPoint(ORI_W - WIDTH, ORI_H - HEIGHT);
        Rectangle rec = new Rectangle(point.x, point.y, WIDTH, HEIGHT);
        FileInputStream fis = new FileInputStream(originFile);
        ImageInputStream iis = ImageIO.createImageInputStream(fis);
        Iterator<ImageReader> imageReaderList = ImageIO.getImageReadersByFormatName(PNG);
        ImageReader imageReader = imageReaderList.next();
        imageReader.setInput(iis, true);
        ImageReadParam param = imageReader.getDefaultReadParam();
        param.setSourceRegion(rec);
        return imageReader.read(0, param);
    }

    private static Point getCutPoint(BufferedImage blockImage, int top, int left) {
        int x = WIDTH - blockImage.getWidth() - WIDTH / left;
        int y = HEIGHT - blockImage.getHeight() - top;
        Point point = Captcha.randomPoint(x, y);
        x = point.x + WIDTH / left;
        y = point.y + top;
        return new Point(x, y);
    }

    private static BufferedImage cutoutByBlock(BufferedImage origin, BufferedImage block, Point p) throws Exception {
        Graphics2D g2D = origin.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(10, 0.7f));
        g2D.drawImage(block, p.x, p.y, block.getWidth(), block.getHeight(), null);
        g2D.dispose();
        return origin;
    }

    public static BufferedImage getMaskImage(BufferedImage origin, BufferedImage block, Point p) {
        int width = block.getWidth();
        int height = block.getHeight();
        BufferedImage newImage = new BufferedImage(width, origin.getHeight(), origin.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (block.getRGB(i, j) >= 0) continue;
                newImage.setRGB(i, p.y + j, origin.getRGB(p.x + i, p.y + j));
            }
        }
        return newImage;
    }

    public static void setWaterMark(BufferedImage origin, BufferedImage block, int x, int y, int alpha) {
        for (int i = 0; i < block.getWidth(); ++i) {
            for (int j = 0; j < block.getHeight(); ++j) {
                if (block.getRGB(i, j) >= 0) continue;
                Color color = new Color(origin.getRGB(x + i, y + j));
                Color newC = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
                origin.setRGB(x + i, y + j, newC.getRGB());
            }
        }
    }

    public static String imgEncode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        String base64 = encoder.encodeToString(bytes);
        return "data:image/" + PNG + ";base64," + base64;
    }

    public static byte[] imgDecode(String base64Str) {
        Base64.Decoder decoder = Base64.getDecoder();
        String[] arr = base64Str.split(",");
        base64Str = arr.length == 1 ? arr[0] : arr[1];
        return decoder.decode(base64Str);
    }

    public static BufferedImage toImage(String base64) {
        Base64.Decoder decoder = Base64.getMimeDecoder();
        try {
            String[] arr = base64.split(",");
            byte[] bytes = decoder.decode(arr[1]);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return ImageIO.read(bais);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Point randomPoint(int widthDiff, int heightDiff) {
        Random random = new Random();
        int X = widthDiff <= 0 ? 0 : random.nextInt(widthDiff);
        int Y = heightDiff <= 0 ? 0 : random.nextInt(heightDiff);
        return new Point(X, Y);
    }

    private static byte[] toByteArray(BufferedImage bufImg) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufImg, PNG, os);
        byte[] bytes = os.toByteArray();
        os.close();
        return bytes;
    }

    public static int getBlockShift(String shadeStr, String blockStr, int Y) {
        return Captcha.getBlockShift(Captcha.toImage(shadeStr), Captcha.toImage(blockStr), Y);
    }

    public static int getBlockShift(BufferedImage shade, BufferedImage block, int Y) {
        List<Point> points = Captcha.getBlockSide(block);
        int W = shade.getWidth() - block.getWidth();
        int L = 0;
        int X = 0;
        for (int x = 1; x < W; ++x) {
            int l = 0;
            for (Point p : points) {
                if (!Captcha.alphaDiff(shade, x + p.x, Y + p.y)) continue;
                ++l;
            }
            if (L >= l) continue;
            L = l;
            X = x;
        }
        return X;
    }

    public static int getBlockShift(String shadeStr, String blockStr, int Y, int diff) {
        return Captcha.getBlockShift(Captcha.toImage(shadeStr), Captcha.toImage(blockStr), Y, diff);
    }

    public static int getBlockShift(BufferedImage shade, BufferedImage block, int Y, int diff) {
        List<Point> points = Captcha.getBlockSide(block);
        int pixel = shade.getWidth() - block.getWidth();
        int L = 0;
        int X = 0;
        for (int x = 1; x < pixel; ++x) {
            int l = 0;
            for (Point p : points) {
                if (!Captcha.colorDiff(shade, x + p.x, Y + p.y, diff)) continue;
                ++l;
            }
            if (L >= l) continue;
            L = l;
            X = x;
        }
        return X;
    }

    private static List<Point> getBlockSide(BufferedImage block) {
        ArrayList<Point> list = new ArrayList<Point>();
        block0: for (int y = 0; y < block.getHeight(); ++y) {
            for (int x = 0; x < block.getWidth(); ++x) {
                if (block.getRGB(x, y) >= 0) continue;
                list.add(new Point(x, y));
                continue block0;
            }
        }
        return list;
    }

    private static boolean colorDiff(BufferedImage shade, int x, int y, int d) {
        try {
            Color c0 = new Color(shade.getRGB(x, y));
            Color c1 = new Color(shade.getRGB(x - 1, y - 1));
            Color c2 = new Color(shade.getRGB(x + 1, y + 1));
            if (Math.abs(c1.getRed() - c0.getRed()) > d || Math.abs(c1.getGreen() - c0.getGreen()) > d || Math.abs(c1.getBlue() - c0.getBlue()) > d || Math.abs(c2.getRed() - c0.getRed()) > d || Math.abs(c2.getGreen() - c0.getGreen()) > d || Math.abs(c2.getBlue() - c0.getBlue()) > d) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean alphaDiff(BufferedImage shade, int x, int y) {
        int diff = 0;
        try {
            Color c0 = new Color(shade.getRGB(x, y), true);
            Color c1 = new Color(shade.getRGB(x - 1, y - 1), true);
            Color c2 = new Color(shade.getRGB(x + 1, y + 1), true);
            diff = Math.abs(c1.getAlpha() - c0.getAlpha());
            diff += Math.abs(c2.getAlpha() - c0.getAlpha());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diff > 0;
    }

    public static void main(String[] args) {
        try {
            File f0 = new File("D:\\javaApp\\doyea\\block1.png");
            File f1 = new File("D:\\javaApp\\doyea\\shade2.png");
            BufferedImage block = ImageIO.read(f0);
            BufferedImage shade = ImageIO.read(f1);
            Captcha.getBlockShift(shade, block, 47);
            System.out.println("sucess!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveToFile(BufferedImage bufImg, String name) {
        String f = name + System.currentTimeMillis() + "." + PNG;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufImg, PNG, os);
            os.writeTo(new FileOutputStream(f));
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveToFile(byte[] bytes, String name) throws Exception {
        String f = name + System.currentTimeMillis() + "." + PNG;
        File file = new File(f);
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        bos.write(bytes);
        fos.close();
    }
}

