/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Service
public class RedisService {
    private static Logger LOG = LoggerFactory.getLogger(RedisService.class);
    @Autowired
    private ShardedJedisPool jedisPool;

    private boolean singleUser() {
        return !ConfUtil.IS_MULTI_LOGIN;
    }

    public Map<String, String> newToken(String userId, String spec) {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("certId", spec);
        token.put("userId", userId);
        token.put("token", Digest.uuid8());
        this.setToken(token);
        token.put("userId", Digest.sm4Encrypt(userId, spec));
        return token;
    }

    public void setToken(Map<String, String> token) {
        String uuid = token.get("token");
        this.hmset("t." + uuid, token, ConfUtil.CACHE_TIME);
        if (this.singleUser()) {
            String userId = token.get("userId");
            this.set("k." + userId, uuid, ConfUtil.CACHE_TIME);
        }
    }

    public void clearToken(Map<String, String> token) {
        LOG.debug("clearToken..." + token);
        this.del("t." + token.get("token"));
    }

    @Deprecated
    public Map<String, String> verifyToken(Map<String, String> cookies) {
        return this.verifyToken(cookies.get("token"));
    }

    public Map<String, String> verifyToken(String uuid) {
        String tid = "t." + uuid;
        Map<String, String> token = this.hmget(tid);
        if (token != null && this.expire(tid)) {
            if (this.singleUser()) {
                String uid = "k." + token.get("userId");
                if (uuid.equals(this.get(uid)) && this.expire(uid)) {
                    return token;
                }
                LOG.debug("> verifyToken...uuid=" + uuid);
                LOG.debug("> verifyToken...userId=" + uid);
            } else {
                return token;
            }
        }
        return null;
    }

    public void setActionRole(String key, Map<String, String> actMap) {
        this.hmset("r." + key, actMap, ConfUtil.CACHE_TIME);
    }

    public String getActionRole(String key, String act) {
        String rk = "r." + key;
        return this.expire(rk) ? this.hget(rk, act) : "";
    }

    public void setUserInfo(Map<String, String> user) {
        String uid = "u." + user.get("userId");
        this.hmset(uid, user, ConfUtil.CACHE_TIME);
    }

    public Map<String, String> getUserInfo(Object userId) {
        String rdsKey = "u." + userId;
        return this.expire(rdsKey) ? this.hmget(rdsKey) : null;
    }

    public boolean set(String key, String val) {
        return this.set(key, val, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String val, int sec) {
        LOG.debug("set..." + key + "=" + val);
        boolean result = true;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            jedis.setex(key, sec, val);
        }
        catch (Exception e) {
            result = false;
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    public boolean hmset(String key, Map<String, String> map) {
        return this.hmset(key, map, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmset(String key, Map<String, String> map, int sec) {
        LOG.debug("hmset..." + key + "=" + map);
        boolean result = true;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            jedis.hmset(key, map);
            if (sec > 0) {
                this.expire(key, sec);
            }
        }
        catch (Exception e) {
            result = false;
            LOG.error("->hmset..." + e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hmget(String key) {
        LOG.debug("hmget..." + key);
        Map result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            result = jedis.hgetAll(key);
            if (result != null && result.isEmpty()) {
                result = null;
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        LOG.debug("hget..." + key);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            result = jedis.hget(key, field);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    public boolean hset(String key, String field, String val) {
        return this.hset(key, field, val, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hset(String key, String field, String val, int sec) {
        LOG.debug("hset..." + key);
        boolean result = true;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            jedis.hset(key, field, val);
            if (sec > 0) {
                this.expire(key, sec);
            }
        }
        catch (Exception e) {
            result = false;
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        LOG.debug("get..." + key);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return result;
    }

    public List<String> getKeys(String pattern) {
        ShardedJedis jedis = this.jedisPool.getResource();
        Collection allShards = jedis.getAllShards();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Jedis j : allShards) {
            Set set = j.keys(pattern);
            keyList.addAll(set);
        }
        this.close(jedis);
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean del(String key) {
        Long count = 0L;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            count = jedis.del(key);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return count > 0L;
    }

    public boolean delKeys(String pattern) {
        ShardedJedis jedis = this.jedisPool.getResource();
        Collection allShards = jedis.getAllShards();
        Long count = 0L;
        for (Jedis j : allShards) {
            Set set = j.keys(pattern);
            for (String key : set) {
                count = count + jedis.del(key);
            }
        }
        this.close(jedis);
        return count > 0L;
    }

    public boolean delKeys(List<String> keyList) {
        ShardedJedis jedis = this.jedisPool.getResource();
        Long count = 0L;
        for (String key : keyList) {
            count = count + jedis.del(key);
        }
        this.close(jedis);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hdel(String key, String ... fields) {
        Long count = 0L;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            count = jedis.hdel(key, fields);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.close(jedis);
        }
        return false;
    }

    public boolean expire(String key) {
        return this.expire(key, ConfUtil.CACHE_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(String key, int sec) {
        long result = 0L;
        ShardedJedis jedis = this.jedisPool.getResource();
        try {
            result = jedis.expire(key, sec);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.close(jedis);
        }
        return result > 0L;
    }

    private void close(ShardedJedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public boolean isBlocked(String ip) {
        int[] num = new int[]{60, 1800, 10, 50};
        return this.isBlocked(ip, num);
    }

    public boolean isBlocked(String ip, int[] num) {
        String rk = "d." + ip;
        Map<String, String> addr = this.hmget(rk);
        String time = String.valueOf(new Date().getTime());
        int loop = num.length / 2;
        if (addr == null) {
            addr = new HashMap<String, String>();
            addr.put("locked", "0");
        } else {
            int i;
            if ("1".equals(addr.get("locked"))) {
                return true;
            }
            String[] arr = addr.get("time").split(",");
            int len = arr.length;
            block0: for (i = 0; i < len; ++i) {
                long diff = new Date().getTime() - Long.parseLong(arr[i]);
                for (int n = 0; n < loop; ++n) {
                    if (diff >= (long)num[0]) continue;
                    if (len - i < num[n + loop]) continue block0;
                    addr.put("locked", "1");
                    this.hmset(rk, addr, loop - 1);
                    return true;
                }
            }
            while (i < len) {
                time = arr[i] + "," + time;
                ++i;
            }
        }
        addr.put("time", time);
        this.hmset(rk, addr, loop - 1);
        return false;
    }

    public String getSm2PubKey(Object ticket, int sec) {
        Map<String, String> keyPair = Digest.genSm2Pair();
        String pubk = keyPair.get("pubk");
        String prik = keyPair.get("prik");
        this.set("a." + ticket, prik, sec);
        this.set("k." + pubk, prik, sec);
        return pubk;
    }

    public String getSm2PriKey(Object key) {
        String prik = this.get("a." + key);
        return prik == null ? this.get("k." + key) : prik;
    }
}

