/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpsService {
    private static Logger LOG = LoggerFactory.getLogger(HttpsService.class);
    private Map<String, String> headers = new HashMap<String, String>();
    private static RequestConfig DEF_CONF = null;
    @Autowired
    UtilsService utils;
    public Header[] getHeaders;

    private RequestConfig requestConf() {
        if (DEF_CONF == null) {
            DEF_CONF = RequestConfig.custom().setRedirectsEnabled(false).setConnectTimeout(ConfUtil.HTTP_TIMEOUT).setConnectionRequestTimeout(ConfUtil.HTTP_TIMEOUT).setSocketTimeout(ConfUtil.HTTP_TIMEOUT).build();
        }
        return DEF_CONF;
    }

    public Set<String> getCookies() {
        return this.getHeader("Set-Cookie");
    }

    public Set<String> getHeader(String name) {
        HashSet<String> values = new HashSet<String>();
        for (Header header : this.getHeaders) {
            if (!header.getName().equals(name)) continue;
            values.add(header.getValue());
        }
        return values;
    }

    public String httpGet(String url, Map<String, String> params) {
        return this.httpGet(url, null, params);
    }

    public String httpGet(String url, Set<String> cookies) {
        return this.httpGet(url, cookies, new HashMap<String, String>());
    }

    public String httpGet(String url, Set<String> cookies, Map<String, String> params) {
        String string;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            HttpGet httpGet = new HttpGet(this.buildUrl(url, params));
            httpGet.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpGet, url, cookies);
            resp = client.execute((HttpUriRequest)httpGet);
            string = this.getResult(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{resp, client});
                throw throwable;
            }
        }
        this.utils.close(new Closeable[]{resp, client});
        return string;
    }

    public String httpPost(String url, String jsonStr, String key) {
        return this.httpPost(url, this.setParams(jsonStr, key));
    }

    public String httpPost(String url) {
        return this.httpPost(url, null, new HashMap<String, String>());
    }

    public String httpPost(String url, Set<String> cookies) {
        return this.httpPost(url, cookies, new HashMap<String, String>());
    }

    public String httpPost(String url, Map<String, String> params) {
        return this.httpPost(url, null, params);
    }

    public String httpPost(String url, Set<String> cookies, Map<String, String> params) {
        return this.httpPost(url, cookies, params, "UTF-8");
    }

    public String httpPost(String url, Set<String> cookies, Map<String, String> params, String encoding) {
        try {
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            return this.httpPost(url, cookies, (HttpEntity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FailedException("httpFailed");
        }
    }

    public String httpPost(String url, Set<String> cookies, HttpEntity entity) {
        String string;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpPost, url, cookies);
            httpPost.setEntity(entity);
            resp = client.execute((HttpUriRequest)httpPost);
            string = this.getResult(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{resp, client});
                throw throwable;
            }
        }
        this.utils.close(new Closeable[]{resp, client});
        return string;
    }

    public String postData(String url, String json) {
        try {
            StringEntity entity = new StringEntity(json, "UTF-8");
            entity.setContentType("application/json");
            return this.httpPost(url, null, (HttpEntity)entity);
        }
        catch (Exception e) {
            throw new FailedException("httpFailed");
        }
    }

    private HttpEntity doResponse(CloseableHttpResponse resp) {
        StatusLine sLine = resp.getStatusLine();
        if (sLine.getStatusCode() == 200 || sLine.getStatusCode() == 302) {
            this.getHeaders = resp.getAllHeaders();
            return resp.getEntity();
        }
        LOG.error("> doResponse..." + sLine);
        throw new FailedException("httpFailed");
    }

    private String getResult(HttpEntity entity) throws Exception {
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (result.length() > 200) {
                LOG.debug(result.substring(0, 200));
            } else {
                LOG.debug(result);
            }
        }
        return result;
    }

    private String buildUrl(String url, Map<String, String> params) {
        if (url != null) {
            String str = this.utils.buildUri(params);
            boolean islast = url.lastIndexOf(63) == url.length() - 1;
            url = url + (islast ? str : "&" + str);
        }
        return url;
    }

    private void setHeaders(HttpMessage msg, String url, Set<String> cookies) {
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            msg.addHeader(e.getKey(), e.getValue());
        }
        if (!this.utils.isEmpty(cookies)) {
            for (String cookie : cookies) {
                msg.addHeader("Cookie", cookie);
            }
            LOG.info("setCookies..." + cookies);
        }
        msg.addHeader("Referer", url);
        String tid = MDC.get((String)"traceId");
        if (tid != null) {
            msg.addHeader("traceId", tid);
        }
    }

    private List<NameValuePair> setParams(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                if (val == null) continue;
                nvpList.add((NameValuePair)new BasicNameValuePair(key, val));
            }
        }
        return nvpList;
    }

    public String digestRequest(String userName, String password, HttpUriRequest uriRequest) {
        String string;
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        try {
            resp = client.execute(uriRequest);
            string = this.getResult(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{resp, client});
                throw throwable;
            }
        }
        this.utils.close(new Closeable[]{resp, client});
        return string;
    }

    public String digestJsonRequest(String userName, String password, String url, String json, String method) {
        LOG.info(json);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        RequestBuilder builder = this.setBuilder((HttpEntity)entity, method);
        HttpUriRequest request = builder.setUri(url).build();
        json = this.digestRequest(userName, password, request);
        LOG.info("> digestJsonRequest..." + json);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean digestDownload(String userName, String password, String url, String filePath) {
        boolean bl;
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        try {
            HttpGet request = new HttpGet(url);
            resp = client.execute((HttpUriRequest)request);
            HttpEntity entity = resp.getEntity();
            InputStream ins = entity.getContent();
            FileOutputStream fos = new FileOutputStream(filePath, false);
            int data = ins.read();
            while (data != -1) {
                fos.write(data);
                data = ins.read();
            }
            fos.close();
            EntityUtils.consume((HttpEntity)entity);
            bl = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{resp, client});
                throw throwable;
            }
            this.utils.close(new Closeable[]{resp, client});
            return false;
        }
        this.utils.close(new Closeable[]{resp, client});
        return bl;
    }

    private RequestBuilder setBuilder(HttpEntity entity, String method) {
        RequestBuilder request = null;
        if ("POST".equals(method)) {
            request = RequestBuilder.post();
        } else if ("GET".equals(method)) {
            request = RequestBuilder.get();
        } else if ("PUT".equals(method)) {
            request = RequestBuilder.put();
        } else if ("DELETE".equals(method)) {
            request = RequestBuilder.delete();
        }
        return request.setEntity(entity);
    }

    private CloseableHttpClient digestHttpClient(String user, String pass) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
        HttpClientBuilder http = HttpClientBuilder.create();
        http.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        return http.build();
    }

    public String urlConnect(String url, Map<String, String> params) {
        return this.urlConnect(this.buildUrl(url, params), new byte[0], "GET");
    }

    public String urlConnect(String url, String str, String method) {
        if (str == null) {
            return null;
        }
        return this.urlConnect(url, str.getBytes(StandardCharsets.UTF_8), method);
    }

    public String urlConnect(String url, byte[] bytes, String method) {
        HttpURLConnection conn = null;
        String result = null;
        try {
            LOG.debug("urlConnect..." + url);
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            this.setProperty(conn).setRequestMethod(method);
            conn.getOutputStream().write(bytes);
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 204) {
                result = this.respAsString(conn.getInputStream());
            } else {
                result = this.respAsString(conn.getErrorStream());
                LOG.error("> urlConnect..." + result);
            }
        }
        catch (Exception e) {
            LOG.error("> urlConnect...");
            e.printStackTrace();
        }
        return result;
    }

    private HttpURLConnection setProperty(HttpURLConnection conn) {
        this.requestConf();
        conn.setConnectTimeout(ConfUtil.HTTP_TIMEOUT);
        conn.setReadTimeout(ConfUtil.HTTP_TIMEOUT);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            conn.setRequestProperty(e.getKey(), e.getValue());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String respAsString(InputStream inp) {
        StringBuilder strBuf = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inp, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
        }
        catch (IOException e) {
            try {
                LOG.error("> respAsString..." + e.getMessage());
            }
            catch (Throwable throwable) {
                this.utils.close(reader);
                throw throwable;
            }
            this.utils.close(reader);
        }
        this.utils.close(reader);
        return strBuf.toString();
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params, String key) {
        return this.doPost(url, this.utils.obj2Str(params), key);
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params) {
        return this.doPost(url, this.utils.obj2Str(params), null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr) {
        return this.doPost(url, jsonStr, null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr, String key) {
        LOG.info("> doPost..." + url);
        Map<String, String> params = this.setParams(jsonStr, key);
        return this.utils.json2Map(this.httpPost(url, null, params));
    }

    private Map<String, String> setParams(String jsonStr, String key) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (jsonStr != null) {
            params.put("jsonstr", jsonStr);
        }
        params.put("k", key == null ? ConfUtil.APP_KEY : key);
        return params;
    }

    public byte[] sendPost(String url, String jsonStr) {
        return this.sendPost(url, this.setParams(jsonStr, null));
    }

    public byte[] sendPost(String url, String jsonStr, String key) {
        return this.sendPost(url, this.setParams(jsonStr, key));
    }

    public byte[] sendPost(String url, Map<String, String> params) {
        return this.sendPost(url, null, params);
    }

    public byte[] sendPost(String url, Set<String> cookies, Map<String, String> params) {
        return this.sendPost(url, cookies, params, "UTF-8");
    }

    public byte[] sendPost(String url, Set<String> cookies, Map<String, String> params, String encoding) {
        byte[] byArray;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpPost, url, cookies);
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            httpPost.setEntity((HttpEntity)entity);
            resp = client.execute((HttpUriRequest)httpPost);
            byArray = this.getStream(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{resp, client});
                throw throwable;
            }
        }
        this.utils.close(new Closeable[]{resp, client});
        return byArray;
    }

    private byte[] getStream(HttpEntity entity) throws Exception {
        return entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
    }

    public HttpsService() {
        this.headers.put("Accept", "*/*");
        this.headers.put("Cache-Control", "no-cache");
        this.headers.put("Connection", "keep-alive");
        this.getHeaders = null;
        this.utils = new UtilsService();
    }

    public <T> Map<String, T> ssoPost(String ws, Map<?, ?> params) {
        return this.ssoPost(ws, this.utils.obj2Str(params));
    }

    public <T> Map<String, T> ssoPost(String ws, String jsonStr) {
        return this.doPost(ConfUtil.SSO_URL + ws, jsonStr);
    }

    public <T> Map<String, T> forward(HttpServletRequest req) {
        return this.ssoPost(this.utils.getRequestURI(req), this.utils.jsonParams(req));
    }

    public String forward(HttpServletRequest req, String url) {
        String jsonStr = req.getParameter("jsonstr");
        Map<String, String> params = this.setParams(jsonStr, null);
        HashSet<String> cookies = new HashSet<String>();
        Enumeration enu = req.getHeaders("Cookie");
        while (enu.hasMoreElements()) {
            cookies.add((String)enu.nextElement());
        }
        LOG.info("forward with cookies=" + cookies);
        return this.httpPost(url, cookies, params);
    }

    public <T> Map<String, T> forward(String url, HttpServletRequest req) {
        return this.utils.json2Map(this.forward(req, url));
    }

    public <T> Map<String, T> corePost(String ws, Map<?, ?> params) {
        String main = ConfUtil.APP_CORE + ConfUtil.APP_MAIN;
        return this.doPost(main + ws, params);
    }
}

