/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.GmetaService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AolaiService
extends GmetaService {
    private static Logger LOG = LoggerFactory.getLogger(AolaiService.class);
    private static final String[] metaKeys = new String[]{"field", "alias", "name", "type", "null", "i18n", "pkey", "width", "default", "sort", "table"};

    public Map<String, Object> getMetaList(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        Object table = params.get("table");
        if (table == null) {
            throw new FailedException();
        }
        return this.utils.success(this.getTableMeta(table));
    }

    public Map<String, String> setMetaItem(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        if (!this.utils.availParams(params, metaKeys)) {
            throw new FailedException();
        }
        Map<String, String> dto = this.getMetaDto();
        Map<String, String> result = this.addRecord(null, "GMETA", dto, params, true);
        return this.eraseMetaDto(result);
    }

    public Map<String, String> delMetaItem(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        String whr = String.valueOf(params.get("where"));
        Map<String, Object> where = this.utils.json2Map(whr);
        if (where.isEmpty()) {
            throw new FailedException();
        }
        Map<String, String> dto = this.getMetaDto();
        Map<String, String> result = this.delete(null, "GMETA", dto, where, null);
        return this.eraseMetaDto(result);
    }

    public Map<String, String> delMetaItems(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        String whr = String.valueOf(params.get("where"));
        List<Map<String, Object>> list = this.utils.json2List(whr);
        if (list.size() == 0) {
            throw new FailedException();
        }
        Map<String, String> dto = this.getMetaDto();
        Map<String, String> result = this.batchDelete(null, "GMETA", dto, list, null);
        return this.eraseMetaDto(result);
    }

    public List<Map<String, String>> getFieldList(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        return this.getFieldList(params.get("base"), this.utils.getRequestURI(req));
    }

    public Map<String, String> setFieldItem(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        if (!this.utils.availParams(params, this.getMetaKeys("FIELD", "null"))) {
            throw new FailedException();
        }
        Object base = params.get("base");
        Map<String, String> result = this.addRecord(base, "FIELD", params, true);
        return this.eraseMetaDto(result, base);
    }

    public Map<String, String> setFieldItems(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        if (!params.containsKey("table")) {
            throw new FailedException();
        }
        Map<String, String> items = this.utils.obj2Map(params);
        items.put("table", "FIELD");
        items.put("dupl", "true");
        Map<String, String> result = this.batchAdd(items);
        return this.eraseMetaDto(result, params.get("base"));
    }

    public Map<String, String> delFieldInfo(HttpServletRequest req) {
        Map<String, Object> params = this.utils.jsonParams(req);
        Boolean obj = params.containsKey("where");
        if (this.utils.isEmpty(obj)) {
            throw new FailedException();
        }
        String whr = String.valueOf(obj);
        List<Map<String, Object>> list = this.utils.json2List(whr);
        Object base = params.get("base");
        Map<String, String> result = this.batchDelete(base, "FIELD", list);
        return this.eraseMetaDto(result);
    }

    private <T> Map<String, T> eraseMetaDto(Map<String, T> result) {
        return this.eraseMetaDto(result, "");
    }

    private <T> Map<String, T> eraseMetaDto(Map<String, T> result, Object base) {
        if ("1".equals(result.get("status"))) {
            this.eraseMetaDto(ConfUtil.IS_CUSTOM_COLS ? base : "");
        }
        return result;
    }

    private void eraseMetaDto(Object rk) {
        this.redis.delKeys("m." + rk + "*");
    }

    public Map<String, Object> queryList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order, String limit) {
        return this.queryList(base, tables, uriKey, where, order, "left", limit);
    }

    public Map<String, Object> queryList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order, String left, String limit) {
        Map<String, String> dto = this.getMetaDto(base, uriKey);
        String table = this.joinTable(base, dto, tables, left);
        if (this.utils.isEmpty(table)) {
            return this.splitPage(0, new ArrayList<Map<String, String>>());
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", table);
        args.put("alias", uriKey);
        args.put("limit", limit);
        Map<String, Object> cond = this.setArgsAndCond(args, dto, where, order);
        int total = this.count(args, cond);
        LOG.debug("> total..." + total);
        List<Map<String, String>> items = this.dao.findList(args, cond);
        return this.splitPage(total, items);
    }

    private Map<String, Object> splitPage(int total, List<Map<String, String>> items) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("items", items);
        return result;
    }

    public Map<String, Object> queryList(Map<String, String> args, Map<String, Object> where, Map<String, String> order) {
        String table = args.get("table");
        Map<String, String> dto = this.getDto(table);
        table = this.getTable(args.get("base"), table);
        Map<String, Object> cond = this.setArgsAndCond(args, dto, where, order);
        args.put("table", table);
        int total = this.count(args.get("base"), table, where);
        List<Map<String, String>> items = this.dao.findList(args, cond);
        return this.splitPage(total, items);
    }

    public Map<String, Object> queryList(Map<String, String> args, Map<String, Object> where) {
        return this.queryList(args, where, null);
    }

    public Map<String, Object> queryList(Object base, String table, String uriKey, Map<String, Object> where, Map<String, String> order) {
        String db = base == null ? null : String.valueOf(base);
        return this.queryAll(where, order, db, table, uriKey);
    }

    public Map<String, Object> queryList(Object base, String table, String uriKey, Map<String, Object> where) {
        return this.queryList(base, table, uriKey, where, null);
    }

    public Map<String, Object> queryList(String table, String uriKey, Map<String, Object> where) {
        return this.queryList(null, table, uriKey, where, null);
    }

    public Map<String, Object> queryList(String table, Map<String, Object> where) {
        return this.queryList(table, null, where);
    }

    public Map<String, Object> queryAll(Map<String, Object> where, Map<String, String> order, String ... params) {
        if (params == null || params.length < 2) {
            return this.splitPage(0, new ArrayList<Map<String, String>>());
        }
        String[] keys = new String[]{"base", "table", "alias", "limit"};
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            args.put(keys[i], params[i]);
        }
        return this.queryList(args, where, order);
    }

    @Override
    public List<Map<String, String>> findAll(Map<String, Object> where, Map<String, String> order, String ... params) {
        if (params == null || params.length < 2) {
            return new ArrayList<Map<String, String>>();
        }
        String[] keys = new String[]{"base", "table", "alias", "limit"};
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            args.put(keys[i], params[i]);
        }
        return this.findList(args, where, order);
    }

    public List<Map<String, String>> findAll(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order) {
        return this.findList(base, tables, uriKey, where, order, "left", "0");
    }

    public List<Map<String, String>> findAll(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order, String left) {
        return this.findList(base, tables, uriKey, where, order, left, "0");
    }

    @Deprecated
    public Map<String, String> addMeta(Map<String, Object> data, boolean dupl) {
        return this.addRecord(null, "GMETA", this.getMetaDto(), data, dupl);
    }

    @Deprecated
    public Map<String, String> delMeta(List<Map<String, Object>> list) {
        return this.batchDelete(null, "GMETA", this.getMetaDto(), list, null);
    }

    private Map<String, String> getMetaDto() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(gmeta);
        map.put("table", "META_TABLE");
        return map;
    }

    private String[] getMetaKeys(String table, String key) {
        List<Map<String, String>> list = this.getTableMeta(table);
        HashSet<String> keySet = new HashSet<String>();
        for (Map<String, String> item : list) {
            if (!"1".equals(item.get(key))) continue;
            keySet.add(item.get("alias"));
        }
        String[] keys = new String[list.size()];
        return keySet.toArray(keys);
    }

    public boolean tableExists(Object base, String table) {
        List<String> list = this.dao.showTables(this.getTable(base, table));
        return list.size() > 0;
    }

    public List<String> getMetaTable() {
        return this.dao.getMetaTable(this.getTable(null, "GMETA"));
    }

    public List<Map<String, String>> getColumns(Object base, String table, String field) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", field);
        return this.dao.showColumns(map);
    }

    public Map<String, String> dropTable(Object base, String table) {
        if (!this.utils.isMatch(table, "\\w+")) {
            throw new FailedException();
        }
        this.dao.drop(this.getTable(base, table));
        this.eraseMetaDto("");
        return this.utils.success();
    }

    public Map<String, String> createTable(Object base, String table) {
        if (!this.utils.isMatch(table, "\\w+")) {
            throw new FailedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("fields", this.getMetaSql(table));
        this.dao.create(map);
        LOG.debug("> createTable..." + map);
        return this.utils.success();
    }

    private String getMetaSql(String table) {
        List<Map<String, String>> meta = this.getTableMeta(table);
        String sql = "";
        String pkey = "";
        String[] lang = ConfUtil.I18N_LOCALES;
        for (int i = 0; i < meta.size(); ++i) {
            String field;
            Map<String, String> map;
            if (i > 0) {
                sql = sql + ",";
            }
            if ("1".equals((map = meta.get(i)).get("i18n"))) {
                for (int j = 0; j < lang.length; ++j) {
                    if (j > 0) {
                        sql = sql + ",";
                    }
                    field = map.get("field") + "_" + lang[j];
                    sql = sql + field + " " + map.get("type");
                    if ("1".equals(map.get("null"))) {
                        sql = sql + " NOT NULL";
                    }
                    if ("1".equals(map.get("pkey"))) {
                        if (pkey.length() > 0) {
                            pkey = pkey + ",";
                        }
                        pkey = pkey + field;
                    }
                    if (map.get("default").length() <= 0) continue;
                    sql = sql + " DEFAULT " + map.get("default");
                }
                continue;
            }
            field = map.get("field");
            sql = sql + field + " " + map.get("type");
            if ("1".equals(map.get("null"))) {
                sql = sql + " NOT NULL";
            }
            if ("1".equals(map.get("pkey"))) {
                if (pkey.length() > 0) {
                    pkey = pkey + ",";
                }
                pkey = pkey + field;
            }
            if (map.get("default").length() <= 0) continue;
            sql = sql + " DEFAULT " + map.get("default");
        }
        if (pkey.length() > 0) {
            sql = sql + ",PRIMARY KEY (" + pkey + ")";
        }
        return sql;
    }
}

