/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Digest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static Logger log = LoggerFactory.getLogger(TestUtil.class);
    private static final String TICKET = "ticket";
    private static final String TOKENS = "tokens";
    private static final int TIMES = 1;
    private String main = "culai/w/";
    private String dbid = "";
    private String url = "";
    private String app = "";
    private String user = "";
    private String pass = "";
    UtilsService utils = new UtilsService();
    HttpsService https = new HttpsService();
    Set<String> cookies = new HashSet<String>();
    String spec = null;
    int count = 0;

    public TestUtil(Map<String, String> params) {
        this.url = params.get("url");
        this.app = params.get("app");
        this.main = params.get("main");
        this.dbid = params.get("dbid");
        this.user = params.get("user");
        this.pass = params.get("pass");
    }

    public TestUtil(String url, String app, String main, String dbid, String user, String pass) {
        this.url = url;
        this.app = app;
        this.main = main;
        this.dbid = dbid;
        this.user = user;
        this.pass = pass;
    }

    private String getCertKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TICKET, "BNQTJMFP");
        params.put("k", "www.ps1.cn");
        String res = this.https.httpPost(this.url + this.main + "getTicket", params);
        Map map = this.utils.json2Map(res);
        map = this.utils.obj2Map(map.get("info"));
        return (String)map.get("certKey");
    }

    public Map<String, Object> doPost(String ws, Map<String, Object> params) {
        if (this.cookies.isEmpty()) {
            this.readCookies();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String jsonstr = this.utils.obj2Str(params);
        map.put("jsonstr", Digest.sm4Encrypt(jsonstr, this.spec));
        String res = this.https.httpPost(this.url + this.app + ws, this.cookies, map);
        log.debug("->> result:{}", (Object)res);
        Map<String, Object> result = this.utils.json2Map(res);
        Object status = result.get("status");
        if ("3".equals(status)) {
            if (this.count++ < 1) {
                this.deleteFile(TOKENS);
                this.deleteFile(TICKET);
                this.autoSignIn();
                return this.doPost(ws, params);
            }
        } else if ("1".equals(status)) {
            log.debug("->> success! ");
        } else {
            log.debug("->> failed! {}", map);
        }
        return result;
    }

    private void autoSignIn() {
        String certKey = this.getCertKey();
        this.spec = Digest.genRawKey();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", this.user);
        map.put("pass", Digest.md5(this.pass));
        map.put(TICKET, certKey);
        map.put("spec", this.spec);
        String jsonstr = Digest.sm2Encrypt(this.utils.obj2Str(map), certKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jsonstr", jsonstr);
        params.put("k", certKey);
        this.https.httpPost(this.url + this.main + "signIn", params);
        this.cookies = this.https.getCookies();
        this.saveTokens(TOKENS, this.cookies);
        this.saveTicket(TICKET, this.spec);
    }

    private void readCookies() {
        this.cookies = this.readContent(TOKENS);
        if (this.cookies.isEmpty()) {
            this.autoSignIn();
        } else {
            Set<String> vaules = this.readContent(TICKET);
            Iterator<String> iterator = vaules.iterator();
            while (iterator.hasNext()) {
                String str;
                this.spec = str = iterator.next();
            }
        }
    }

    private Set<String> readContent(String fileName) {
        HashSet<String> set = new HashSet<String>();
        File file = new File(fileName + ".txt");
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                set.add(line);
                log.debug(">{} = \"{}\"", (Object)fileName, (Object)line);
            }
            br.close();
        }
        catch (IOException e) {
            log.debug(">{} is null.", (Object)fileName);
        }
        return set;
    }

    private void saveTokens(String name, Set<String> arr) {
        try {
            log.debug("> save to {}", (Object)name);
            File file = new File(name + ".txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            for (String str : arr) {
                writer.write(str + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteFile(String name) {
        File file = new File(name + ".txt");
        if (!file.delete()) {
            log.debug("> Delete file failed.");
        }
    }

    private void saveTicket(String name, String ... arr) {
        try {
            log.debug("> save to {}", (Object)name);
            File file = new File(name + ".txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            for (String str : arr) {
                writer.write(str + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> newParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.dbid != null && this.dbid.length() > 0) {
            params.put("dbid", this.dbid);
        }
        return params;
    }
}

