/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XfileService {
    @Autowired
    private UtilsService utils;

    public <T> String getFilePath(Map<String, T> map, String[] keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(map.get(key) + File.separator);
        }
        return sb.toString();
    }

    public String getFileName(String file) {
        return file.substring(file.lastIndexOf(File.separator));
    }

    public String makeFileName(Object name, Object ext) {
        return name + "." + ext;
    }

    public boolean overSize(long kiloByte, String limit) {
        if (limit == null) {
            return false;
        }
        limit = limit.toUpperCase();
        Matcher m = Pattern.compile("^(\\d+)([KMGTP])$").matcher(limit);
        if (m.find()) {
            int i = "KMGTP".indexOf(m.group(2));
            double max = Math.pow(1024.0, i) * (double)Integer.parseInt(m.group(1));
            return (double)kiloByte > max;
        }
        return this.utils.isInteger(limit) && kiloByte > (long)Integer.parseInt(limit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write2Resp(String file, HttpServletResponse resp, String header, String contentType) {
        resp.reset();
        resp.setContentType(contentType);
        try (FileInputStream inp = new FileInputStream(file);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
            byte[] bytes = new byte[((InputStream)inp).available()];
            if (((InputStream)inp).read(bytes) <= 0) return false;
            resp.addHeader("Content-Disposition", header + this.getFileName(file));
            resp.addIntHeader("Content-Length", bytes.length);
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.utils.doFailed();
        }
        return false;
    }
}

