/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Service
public class RedisService {
    private static Logger log = LoggerFactory.getLogger(RedisService.class);
    @Autowired
    private ShardedJedisPool jedisPool;

    private boolean singleUser() {
        return !ConfUtil.isMultLogin();
    }

    public Map<String, String> newToken(String userId, String spec) {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("certId", spec);
        token.put("token", Digest.uuid8());
        token.put("userId", userId);
        this.setToken(token);
        log.debug("newToken...{}", token);
        token.put("userId", Digest.sm4Encrypt(userId, spec));
        return token;
    }

    public void setToken(Map<String, String> token) {
        String uuid = token.get("token");
        this.hmset("t." + uuid, token, ConfUtil.cacheTime());
        if (this.singleUser()) {
            String userId = token.get("userId");
            this.set("k." + userId, uuid, ConfUtil.cacheTime());
        }
    }

    public Map<String, String> verifyToken(String uuid) {
        String tid = "t." + uuid;
        Map<String, String> token = this.hmget(tid);
        if (!token.isEmpty() && this.expire(tid)) {
            if (this.singleUser()) {
                String uid = "k." + token.get("userId");
                if (uuid.equals(this.get(uid)) && this.expire(uid)) {
                    return token;
                }
            } else {
                return token;
            }
            log.debug("verifyToken...^rds_uuid");
        }
        return null;
    }

    @Deprecated
    public Map<String, String> verifyToken(Map<String, String> cookies) {
        return this.verifyToken(cookies.get("token"));
    }

    public boolean checkVCode(Object mobile, Object vCode) {
        return this.exists("v." + mobile + vCode);
    }

    public void setVCode(Object mobile, Object vCode) {
        String rdsVcode = "v." + mobile + vCode;
        this.set(rdsVcode, "1", ConfUtil.vcodeDue());
    }

    public void clearToken(Map<String, String> token) {
        log.debug("clearToken...{}", token);
        this.del("t." + token.get("token"));
    }

    void setActionRole(String key, Map<String, String> uriMap) {
        this.hmset("r." + key, uriMap, ConfUtil.cacheTime());
    }

    String getActionRole(String key, String actUri) {
        String rk = "r." + key;
        return this.expire(rk) ? this.hget(rk, actUri) : null;
    }

    public void setUserInfo(Map<String, String> user) {
        String uid = "u." + user.get("userId");
        this.hmset(uid, user, ConfUtil.cacheTime());
    }

    public Map<String, String> getUserInfo(Object userId) {
        String rdsKey = "u." + userId;
        return this.expire(rdsKey) ? this.hmget(rdsKey) : new HashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setWithLock(String key, String uuid, int sec) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            boolean bl = "OK".equals(jedis.set(key, uuid, "NX", "EX", (long)sec));
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public boolean set(String key, String val) {
        return this.set(key, val, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(String key, String val, int sec) {
        log.debug("set...{}={}", (Object)key, (Object)val);
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            jedis.setex(key, sec, val);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public boolean hmset(String key, Map<String, String> map) {
        return this.hmset(key, map, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hmset(String key, Map<String, String> map, int sec) {
        log.debug("hmset...{}={}", (Object)key, map);
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            jedis.hmset(key, map);
            if (sec > 0) {
                this.expire(key, sec);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> hmget(String key) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.debug("hmget...{} is Empty.", (Object)key);
            return new HashMap<String, String>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String hget(String key, String field) {
        log.debug("hset...{}.{}", (Object)key, (Object)field);
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            String string = jedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public boolean hset(String key, String field, String val) {
        return this.hset(key, field, val, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hset(String key, String field, String val, int sec) {
        log.debug("hset...{}.{}", (Object)key, (Object)field);
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            jedis.hset(key, field, val);
            if (sec > 0) {
                this.expire(key, sec);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String key) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            log.error("get...{} is null.", (Object)key);
            return null;
        }
    }

    public List<String> getKeys(String pattern) {
        ArrayList<String> keyList = new ArrayList<String>();
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            Collection allShards = jedis.getAllShards();
            for (Jedis j : allShards) {
                Set set = j.keys(pattern);
                keyList.addAll(set);
            }
        }
        catch (Exception e) {
            log.error("getKeys...{}", (Object)pattern);
        }
        return keyList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean del(String key) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.del(key) > 0L;
            return bl;
        }
        catch (Exception e) {
            log.error("del...{}", (Object)key);
            return false;
        }
    }

    public boolean delKeys(String pattern) {
        Long count = 0L;
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            Collection allShards = jedis.getAllShards();
            for (Jedis jds : allShards) {
                Set set = jds.keys(pattern);
                for (String key : set) {
                    count = count + jedis.del(key);
                }
            }
        }
        catch (Exception e) {
            log.error("delKeys...{}", (Object)pattern);
        }
        return count > 0L;
    }

    public boolean delKeys(List<String> keyList) {
        Long count = 0L;
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            for (String key : keyList) {
                count = count + jedis.del(key);
            }
        }
        catch (Exception e) {
            log.error("delKeys...{}", (Object)e.getMessage());
        }
        return count > 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hdel(String key, String[] fields) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.hdel(key, fields) > 0L;
            return bl;
        }
        catch (Exception e) {
            log.error("hdel...{}", (Object)e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String key) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            log.error("exists...{}", (Object)key);
            return false;
        }
    }

    public boolean expire(String key) {
        return this.expire(key, ConfUtil.cacheTime());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean expire(String key, int sec) {
        try (ShardedJedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.expire(key, sec) > 0L;
            return bl;
        }
        catch (Exception e) {
            log.error("expire...{}", (Object)key);
            return false;
        }
    }

    public boolean isBlocked(String ip) {
        int[] times = new int[]{60, 1800, 10, 50};
        return this.isBlocked(ip, times);
    }

    public boolean isBlocked(String ip, int[] times) {
        String rk = "d." + ip;
        Map<String, String> addr = this.hmget(rk);
        StringJoiner s = new StringJoiner(",");
        long nowTime = new Date().getTime();
        int loop = times.length / 2;
        if (addr.isEmpty()) {
            addr = new HashMap<String, String>();
            addr.put("lock", "0");
        } else {
            if ("1".equals(addr.get("lock"))) {
                return true;
            }
            String[] arr = addr.get("info").split(",");
            for (int i = 0; i < arr.length; ++i) {
                long diff = nowTime - Long.parseLong(arr[i]);
                for (int n = 0; n < loop; ++n) {
                    if (diff >= (long)times[n] || arr.length + 1 - i <= times[n + loop]) continue;
                    addr.put("lock", "1");
                    this.hmset(rk, addr, times[loop - 1]);
                    return true;
                }
                if (diff >= (long)times[1]) continue;
                while (i < arr.length) {
                    s.add(arr[i++]);
                }
                break;
            }
        }
        s.add(String.valueOf(nowTime));
        addr.put("info", s.toString());
        this.hmset(rk, addr, times[loop - 1]);
        return false;
    }

    public String getSm2PubKey(Object ticket, int sec) {
        Map<String, String> keyPair = Digest.genSm2Pair();
        String pubk = keyPair.get("pubk");
        String prik = keyPair.get("prik");
        this.set("a." + ticket, prik, sec);
        this.set("k." + pubk, prik, sec);
        return pubk;
    }

    String getCertKey(Object key) {
        String prik = this.get("a." + key);
        return prik == null ? this.get("k." + key) : prik;
    }

    void clearDto(Object table, Object rdsDbid) {
        this.del("m." + table + rdsDbid);
    }
}

