/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.GmetaService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AolaiService
extends GmetaService {
    private static Logger log = LoggerFactory.getLogger(AolaiService.class);

    public Map<String, Object> getMetaList() {
        String[] keys = new String[]{"table"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Object table = params.get("table");
        return this.utils.success(this.getTableMeta(table));
    }

    public Map<String, String> addMetaItem() {
        Map<String, String> metas = ConfUtil.gMETAS();
        String[] keys = metas.keySet().toArray(new String[metas.size()]);
        Map<String, Object> data = this.utils.jsonParams(keys);
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("table", data.get("table"));
        if (!this.exists("GMETA", cond)) {
            return this.utils.invalidParams();
        }
        data.put("sort", this.count("GMETA", cond));
        Map<String, String> meta = this.utils.obj2Map(data);
        String field = meta.get("field");
        cond.put("field", field);
        if (this.exists("GMETA", cond)) {
            throw new FailedException("dataDuplicate");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.tableOf(meta.get("table")));
        if ("1".equals(meta.get("lang"))) {
            for (String locale : ConfUtil.locales()) {
                map.put("field", this.setField(field + "_" + locale, meta));
                this.dao.addCol(map);
            }
        } else {
            map.put("field", this.setField(field, meta));
            this.dao.addCol(map);
        }
        data.put("style", "{\"custom\":\"1\"}");
        return this.addRecord("GMETA", data, true);
    }

    public Map<String, String> delMetaItem() {
        String[] keys = new String[]{"table", "alias"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Map<String, String> meta = this.findOne("GMETA", params);
        if (this.utils.isFailed(meta)) {
            return this.utils.invalidParams();
        }
        Map style = this.utils.json2Map(meta.get("style"));
        if (!"1".equals(style.get("custom"))) {
            throw new FailedException("cantRemove");
        }
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("fieldOrigin", params.get("table"));
        cond.put("fieldAlias", params.get("alias"));
        if (this.exists("FIELD", cond)) {
            throw new FailedException("dataInUse");
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        String alias = meta.get("alias");
        String table = meta.get("table");
        if ("null".equals(meta.get("default"))) {
            where.put(this.utils.pHolder(alias, "IS NOT NULL"), "");
        } else {
            where.put(this.utils.pHolder(alias, "!="), meta.get("default"));
        }
        if (this.exists(table, where)) {
            throw new FailedException("dataInUse");
        }
        if (this.utils.isSuccess(this.delete("GMETA", cond))) {
            this.redis.clearDto(table, this.rdsDbid());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("table", this.tableOf(table));
            map.put("field", meta.get("field"));
            return this.utils.result(this.dao.dropCol(map) > 0);
        }
        return this.utils.invalidParams();
    }

    public Map<String, Object> queryList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String limit) {
        return this.queryList(base, tables, uriKey, cond, sort, "left", limit);
    }

    public Map<String, Object> queryList(Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String limit) {
        return this.queryList(null, tables, uriKey, cond, sort, "left", limit);
    }

    public Map<String, Object> queryList(Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.queryList(null, tables, uriKey, cond, sort, "left", "0");
    }

    public Map<String, Object> queryList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String left, String limit) {
        HashMap<String, String> allDto = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> e : tables.entrySet()) {
            allDto.putAll(this.getDto(e.getKey()));
        }
        String[] table = this.joinTables(base, allDto, tables, left);
        Map<String, String> args = this.queryArgs(table[1], uriKey, limit);
        cond = this.setArgsAndCond(args, allDto, cond, sort);
        this.setDataIsolation(cond, table[0]);
        int total = this.dao.countRows(args, cond);
        log.debug("total...{}", (Object)total);
        Map<String, String> dto = this.getDtoBy(allDto, uriKey);
        return this.splitPage(total, this.setBlur(this.dao.findList(args, cond), dto));
    }

    private Map<String, Object> splitPage(int total, List<Map<String, String>> items) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("items", items);
        return result;
    }

    public Map<String, Object> queryList(Map<String, String> args, Map<String, Object> cond, Map<String, String> sort) {
        String table = args.get("table");
        String uriKey = args.get("alias");
        Map<String, String> allDto = this.getDto(table);
        cond = this.setArgsAndCond(args, allDto, cond, sort);
        args.put("table", this.tableOf(table));
        this.setDataIsolation(cond, table);
        int total = this.dao.countRows(args, cond);
        Map<String, String> dto = this.getDtoBy(allDto, uriKey);
        return this.splitPage(total, this.setBlur(this.dao.findList(args, cond), dto));
    }

    @Deprecated
    public Map<String, Object> queryList(Map<String, String> args, Map<String, Object> cond) {
        return this.queryList(args, cond, null);
    }

    Map<String, Object> queryList(Object base, String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        if (base != null && !cond.containsKey("base")) {
            cond.put("base", base);
        }
        String[] args = new String[]{null, table, uriKey};
        return this.queryAll(cond, sort, args);
    }

    public Map<String, Object> queryList(String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.queryList(null, table, uriKey, cond, sort);
    }

    @Deprecated
    public Map<String, Object> queryList(Object base, String table, String uriKey, Map<String, Object> cond) {
        return this.queryList(base, table, uriKey, cond, null);
    }

    public Map<String, Object> queryList(String table, String uriKey, Map<String, Object> cond) {
        return this.queryList(null, table, uriKey, cond, null);
    }

    public Map<String, Object> queryList(String table, Map<String, Object> cond) {
        return this.queryList(table, null, cond);
    }

    public Map<String, Object> queryAll(Map<String, Object> cond, Map<String, String> sort, String[] args) {
        Map<String, String> map = this.convertArgs(args);
        if (map == null) {
            return this.splitPage(0, new ArrayList<Map<String, String>>());
        }
        return this.queryList(map, cond, sort);
    }

    public List<Map<String, String>> findAll(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.findAll(base, tables, uriKey, cond, sort, "left");
    }

    public List<Map<String, String>> findAll(Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.findAll(null, tables, uriKey, cond, sort, "left");
    }

    public List<Map<String, String>> findAll(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String left) {
        return this.findList(base, tables, uriKey, cond, sort, left, "0");
    }

    public List<Map<String, String>> findAll(Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String left) {
        return this.findAll(null, tables, uriKey, cond, sort, left);
    }

    public Map<String, String> addTreeNode(Map<String, Object> item, String[] keys, int tierW) {
        String[] newKeys = new String[]{keys[1], keys[1], "i18n"};
        Map<String, Object> cond = this.utils.sameIf(item, 0, newKeys);
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put(keys[2], "ASC");
        String base = keys.length > 7 ? keys[7] : null;
        String[] args = new String[]{base, keys[0], null, "0"};
        List<Map<String, String>> list = this.findAll(cond, sort, args);
        int w = tierW;
        int limit = 1;
        while (w-- > 0) {
            limit *= 10;
        }
        if (list.size() == limit - 1) {
            throw new FailedException("overCounts");
        }
        Object pid = item.get(keys[3]);
        String itemId = this.utils.newLeafId(pid, list, keys[2], tierW);
        item.put(keys[2], itemId);
        item.put(keys[4], "1");
        item.put(keys[5], itemId.length() / tierW);
        try {
            Map<String, String> result = this.addRecord(base, keys[0], item, true);
            if (!this.utils.isSuccess(result)) {
                this.utils.doFailed();
            }
        }
        catch (Exception e) {
            log.error("addTreeNode...{}", item);
            this.utils.doFailed();
        }
        if (!"0".equals(pid)) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(keys[4], "0");
            fields.put(keys[6], item.get(keys[6]));
            HashMap<String, Object> cond1 = new HashMap<String, Object>();
            cond1.put(keys[1], item.get(keys[1]));
            cond1.put(keys[2], pid);
            cond1.put(keys[4], "1");
            this.update((Object)base, keys[0], fields, cond1);
        }
        return this.utils.success();
    }

    public List<String> getMetaTable() {
        return this.dao.getMetaTable(this.tableOf("GMETA"));
    }

    @Deprecated
    public boolean tableExists(Object base, String table) {
        return !this.dao.showTables(this.getTable(base, table)).isEmpty();
    }

    @Deprecated
    public Map<String, String> createTable(Object base, String table) {
        if (!this.utils.isMatch(table, "\\w+")) {
            throw new FailedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", this.getMetaSql(table));
        this.dao.create(map);
        log.debug("createTable...{}", map);
        return this.utils.success();
    }

    private String getMetaSql(String table) {
        List<Map<String, String>> metas = this.getTableMeta(table);
        StringJoiner s = new StringJoiner(",");
        String pkey = "";
        if (ConfUtil.dataIsolation()) {
            pkey = this.tenantKey(table);
            s.add(pkey + " INT NOT NULL DEFAULT 0");
        }
        for (int i = 0; i < metas.size(); ++i) {
            Map<String, String> meta = metas.get(i);
            String field = meta.get("field");
            if ("1".equals(meta.get("lang"))) {
                for (String locale : ConfUtil.locales()) {
                    s.add(this.setField(field + "_" + locale, meta));
                }
                continue;
            }
            s.add(this.setField(field, meta));
            pkey = this.setPkey(pkey, field, meta);
        }
        if (pkey.length() > 0) {
            s.add("PRIMARY KEY (" + pkey + ")");
        }
        return s.toString();
    }

    private String setField(String field, Map<String, String> meta) {
        field = String.join((CharSequence)" ", field, meta.get("type"));
        if ("1".equals(meta.get("null"))) {
            field = field + " NOT NULL";
        }
        return field + " DEFAULT " + meta.get("default");
    }

    private String setPkey(String pkey, String field, Map<String, String> meta) {
        if ("1".equals(meta.get("pkey"))) {
            pkey = pkey + (pkey.length() > 0 ? "," + field : field);
        }
        return pkey;
    }

    public int getMaxCode(Object base, String table, String field) {
        return this.getMaxCode(base, table, field, null);
    }

    public int getMaxCode(String table, String field) {
        return this.getMaxCode(null, table, field, null);
    }

    public int getMaxCode(Object base, String table, String field, Map<String, Object> cond) {
        return Integer.parseInt(this.getMaxValue(base, table, field, cond)) + 1;
    }

    public int getMaxCode(String table, String field, Map<String, Object> cond) {
        return this.getMaxCode(null, table, field, cond);
    }

    public String getMaxValue(Object base, String table, String field) {
        return this.getMaxValue(base, table, field, null);
    }

    public String getMaxValue(String table, String field) {
        return this.getMaxValue(null, table, field, null);
    }

    public String getMaxValue(Object base, String table, String field, Map<String, Object> cond) {
        return String.valueOf(this.getMValue(base, table, field, cond, "MAX"));
    }

    public String getMaxValue(String table, String field, Map<String, Object> cond) {
        return this.getMaxValue(null, table, field, cond);
    }

    public String getMinValue(Object base, String table, String field) {
        return this.getMinValue(base, table, field, null);
    }

    public String getMinValue(String table, String field) {
        return this.getMinValue(null, table, field, null);
    }

    public String getMinValue(Object base, String table, String field, Map<String, Object> cond) {
        return String.valueOf(this.getMValue(base, table, field, cond, "MIN"));
    }

    public String getMinValue(String table, String field, Map<String, Object> cond) {
        return this.getMinValue(null, table, field, cond);
    }

    public int sumTotal(Object base, String table, String field, Map<String, Object> cond) {
        return this.getMValue(base, table, field, cond, "SUM");
    }

    public int sumTotal(String table, String field, Map<String, Object> cond) {
        return this.sumTotal(null, table, field, cond);
    }

    public int sumTotal(Object base, String table, String field) {
        return this.sumTotal(base, table, field, null);
    }

    public int sumTotal(String table, String field) {
        return this.sumTotal(null, table, field, null);
    }

    public List<Map<String, String>> groupCount(String table, String[] keys, Map<String, Object> cond) {
        return this.groupCount(null, table, keys, cond);
    }

    public List<Map<String, String>> groupCount(String table, String key, Map<String, Object> cond) {
        return this.groupCount(null, table, new String[]{key}, cond);
    }
}

