/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.FailedException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class AdviceService {
    private static Logger log = LoggerFactory.getLogger(AdviceService.class);
    @Autowired
    private UtilsService utils;

    @ExceptionHandler(value={FailedException.class})
    public Map<String, String> handleFailedException(FailedException ex) {
        log.debug("FailedException...{}", (Object)ex.getMessage());
        return this.utils.failed(ex.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Map<String, String> handleRuntimeException(RuntimeException ex) {
        log.error("RuntimeException...{}", (Throwable)ex);
        return this.utils.failed("doFailed");
    }

    @ExceptionHandler(value={Exception.class})
    public Map<String, String> handleException(Exception ex) {
        log.error("Exception...{}", (Throwable)ex);
        return this.utils.failed(ex.getMessage());
    }
}

