/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.FmtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutService {
    private static Logger log = LoggerFactory.getLogger(LayoutService.class);
    private static Set<String> loSet = new HashSet<String>();
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;
    @Autowired
    HttpServletRequest req;

    Map<String, String> getAliasArray(Map<String, String> item, String key) {
        List head = this.utils.json2List(item.get("layoutHead"));
        List opts = this.utils.json2List(item.get("layoutOpts"));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < head.size() && i < opts.size(); ++i) {
            Map opt = (Map)opts.get(i);
            if (!"1".equals(opt.get("permit"))) continue;
            map.put((String)head.get(i), (String)opt.get(key));
        }
        log.debug("getAliasArray...{}", map);
        return map;
    }

    private Map<String, Map<String, String>> getAliasOpts(Map<String, String> item) {
        List head = this.utils.json2List(item.get("layoutHead"));
        List opts = this.utils.json2List(item.get("layoutOpts"));
        LinkedHashMap<String, Map<String, String>> map = new LinkedHashMap<String, Map<String, String>>();
        for (int i = 0; i < head.size() && i < opts.size(); ++i) {
            Map tmp = (Map)opts.get(i);
            if (!"1".equals(tmp.get("permit"))) continue;
            map.put((String)head.get(i), tmp);
        }
        return map;
    }

    Map<String, String> getLayoutBy(Object uriKey) {
        return this.getLayoutBy(uriKey, this.req.getAttribute("userId"));
    }

    private Map<String, String> getLayoutBy(Object uriKey, Object userId) {
        String rk = "p." + uriKey + this.aolai.rdsDbid() + userId;
        Map<String, String> layout = this.redis.hmget(rk);
        if (layout.isEmpty()) {
            String[] loArr = loSet.toArray(new String[loSet.size()]);
            Map<String, String> item = "".equals(userId) ? this.getLayoutOne(uriKey) : this.getLayoutOne(uriKey, userId);
            layout = this.utils.newMap(item, loArr);
            this.redis.hmset(rk, layout, 3600);
        }
        return layout;
    }

    private Map<String, String> getLayoutOne(Object uriKey) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("layoutUri", uriKey);
        cond.put("layoutOper", "");
        return this.aolai.findOne("LAYOUT", loSet, cond);
    }

    private Map<String, String> getLayoutOne(Object uriKey, Object userId) {
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("layoutOper", "DESC");
        String[] args = new String[]{null, "LAYOUT", "", "1"};
        Map<String, Object> cond = this.layoutCond(uriKey, userId);
        List<Map<String, String>> list = this.aolai.findAll(cond, sort, args);
        log.debug("getLayoutOne...{}", list);
        if (list.isEmpty()) {
            throw new FailedException("noDataFound");
        }
        return list.get(0);
    }

    private Map<String, Object> layoutCond(Object uriKey, Object userId) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("layoutUri", uriKey);
        String[] userArr = new String[]{(String)userId, ""};
        cond.put(this.utils.pHolder("layoutOper", "in"), userArr);
        return cond;
    }

    void clearLayout(Object uriKey) {
        this.redis.delKeys("p." + uriKey + this.aolai.rdsDbid() + "*");
    }

    public Map<String, String> addFieldItem() {
        String[] keys = new String[]{"fieldUri", "fieldOrigin", "fieldAlias"};
        Map<String, Object> data = this.utils.jsonParams(keys);
        Object uriKey = data.get("fieldUri");
        List list = this.getFields(uriKey);
        data.put("fieldSort", list.size());
        data.put("fieldCustom", "1");
        Map opts = this.utils.obj2Map(data.get("fieldOpts"));
        if (!"1".equals(opts.get("permit"))) {
            opts.put("permit", "0");
        }
        if (this.utils.isFailed(this.aolai.addRecord("FIELD", data, true))) {
            throw new FailedException();
        }
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("fieldAlias", String.valueOf(data.get("fieldAlias")));
        item.put("fieldOpts", this.utils.obj2Str(opts));
        list.add(item);
        return this.setLayoutItem(uriKey, list);
    }

    public Map<String, String> delFieldItem() {
        String[] keys = new String[]{"fieldUri", "fieldAlias"};
        Map<String, Object> where = this.utils.jsonParams(keys);
        Object uriKey = where.get("fieldUri");
        List list = this.getFields(uriKey);
        int idx = 0;
        for (idx = 0; idx < list.size(); ++idx) {
            if (!list.get(idx).get("fieldAlias").equals(where.get("fieldAlias"))) continue;
            if (!"1".equals(list.get(idx).get("fieldCustom"))) {
                throw new FailedException("cantRemove");
            }
            list.remove(idx);
            break;
        }
        if (this.utils.isFailed(this.aolai.delete("FIELD", where))) {
            throw new FailedException();
        }
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("fieldUri", uriKey);
        cond.put(this.utils.pHolder("fieldSort", ">"), idx);
        this.aolai.decrSort("FIELD", "fieldSort", cond);
        return this.setLayoutItem(uriKey, list);
    }

    private <T> Map<String, String> setLayoutItem(Object uriKey, List<Map<String, T>> list) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("layoutUri", uriKey);
        params.put("layoutHead", this.utils.obj2Str(this.utils.getArr(list, "fieldAlias")));
        params.put("layoutOpts", this.utils.obj2Str(this.utils.getArr(list, "fieldOpts")));
        params.put("layoutOper", "");
        params.put("layoutState", "1");
        return this.setLayoutItem(params);
    }

    private Map<String, String> setLayoutItem(Map<String, Object> params) {
        Map<String, String> result = this.aolai.addRecord("LAYOUT", params, true);
        if (this.utils.isSuccess(result)) {
            this.clearLayout(params.get("layoutUri"));
        }
        return result;
    }

    public Map<String, String> setLayoutItem() {
        String[] keys = new String[]{"layoutUri", "layoutHead", "layoutOpts"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Object userId = this.req.getAttribute("userId");
        Map<String, String> layout = this.getLayoutOne(params.get("layoutUri"), userId);
        List head = this.utils.obj2List(params.get("layoutHead"));
        List opts = this.utils.obj2List(params.get("layoutOpts"));
        Map<String, String> permit = this.getAliasArray(layout, "permit");
        for (int i = 0; i < head.size() && i < opts.size(); ++i) {
            Map opt = (Map)opts.get(i);
            opt.put("permit", permit.get(head.get(i)) == null ? "0" : "1");
        }
        params.put("layoutOpts", this.utils.obj2Str(opts));
        params.put("layoutHead", this.utils.obj2Str(head));
        params.put("layoutOper", userId);
        return this.setLayoutItem(params);
    }

    public Map<String, String> setLayoutOpts() {
        String[] keys = new String[]{"layoutUri", "layoutHead", "layoutOpts"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Object userId = this.req.getAttribute("userId");
        Map<String, String> layout = this.getLayoutOne(params.get("layoutUri"), userId);
        List head = this.utils.json2List(layout.get("layoutHead"));
        List opts = this.utils.json2List(layout.get("layoutOpts"));
        int idx = head.indexOf(params.get("layoutHead"));
        if (idx == -1) {
            throw new FailedException();
        }
        Map opt = (Map)opts.get(idx);
        String permit = (String)opt.get("permit");
        Map tmp = this.utils.obj2Map(params.get("layoutOpts"));
        for (Map.Entry e : tmp.entrySet()) {
            opt.put(e.getKey(), e.getValue());
        }
        opt.put("permit", permit);
        log.debug("setLayoutOpts..." + opts);
        params.put("layoutOpts", this.utils.obj2Str(opts));
        params.put("layoutHead", this.utils.obj2Str(head));
        params.put("layoutOper", userId);
        return this.setLayoutItem(params);
    }

    public Map<String, String> setFieldItem() {
        String[] keys = new String[]{"fieldUri", "fieldAlias", "fieldOpts"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Map opts = this.utils.obj2Map(params.get("fieldOpts"));
        if (!"1".equals(opts.get("permit"))) {
            opts.put("permit", "0");
        }
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("fieldOpts", this.utils.obj2Str(opts));
        Map<String, Object> cond = this.utils.newMap(params, new String[]{"fieldUri", "fieldAlias"});
        Map<String, String> result = this.aolai.update("FIELD", item, cond);
        if (this.utils.isSuccess(result)) {
            Object uriKey = params.get("fieldUri");
            return this.setLayoutItem(uriKey, this.getFields(uriKey));
        }
        return result;
    }

    public Map<String, String> setFieldItems() {
        String[] keys = new String[]{"fieldUri", "items"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Object uriKey = params.get("fieldUri");
        List list = this.getFields(uriKey);
        List items = this.utils.obj2List(params.get("items"));
        if (list.isEmpty() || list.size() != items.size()) {
            return this.utils.invalidParams();
        }
        String table = list.get(0).get("fieldOrigin");
        Set<String> set = this.utils.toSet(list, "fieldAlias");
        for (int i = 0; i < items.size(); ++i) {
            Object opts;
            Map item = (Map)items.get(i);
            if (!set.contains(item.get("fieldAlias"))) {
                this.utils.invalidParams();
            }
            if ((opts = item.get("fieldOpts")) instanceof Map) {
                item.put("fieldOpts", this.utils.obj2Str(opts));
            }
            item.put("fieldOrigin", table);
            item.put("fieldUri", uriKey);
            item.put("fieldSort", i);
        }
        Map<String, String> result = this.aolai.batchAdd("FIELD", items, true);
        if (this.utils.isSuccess(result)) {
            return this.setLayoutItem(uriKey, items);
        }
        return result;
    }

    private List<Map<String, String>> getFields(Object uriKey) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("fieldUri", uriKey);
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("fieldSort", "");
        return this.aolai.findAll("FIELD", "", cond, sort);
    }

    public List<Map<String, String>> getFieldsBy() {
        String[] keys = new String[]{"fieldUri"};
        Map<String, Object> params = this.utils.jsonParams(keys);
        Object uriKey = params.get("fieldUri");
        List<Map<String, String>> fiedlList = this.getFieldsBy(uriKey);
        log.debug("getFieldsBy...{}", fiedlList);
        if ("1".equals(params.get("all"))) {
            return fiedlList;
        }
        return this.layout(fiedlList, uriKey, params);
    }

    public List<Map<String, String>> getFieldsBy(Object uriKey) {
        Map<String, Map<String, String>> tables = this.utils.joinCond("FIELD");
        HashMap<String, String> cond1 = new HashMap<String, String>();
        cond1.put("fieldOrigin", "table");
        cond1.put("fieldAlias", "alias");
        tables.put("GMETA", cond1);
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("fieldUri", uriKey);
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("fieldSort", "ASC");
        return this.aolai.findAll(tables, "getFieldList", cond, sort);
    }

    private List<Map<String, String>> layout(List<Map<String, String>> list, Object uriKey, Map<String, Object> params) {
        Object show = params.get("show");
        Map<String, Map<String, String>> alias = this.getAliasOpts(this.getLayoutBy(uriKey));
        Map items = this.utils.list2Map(list, "fieldAlias");
        log.debug("layout...{}", alias);
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> e : alias.entrySet()) {
            Map item = items.get(e.getKey());
            Map<String, String> opts = e.getValue();
            if (!"1".equals(show) && "1".equals(opts.get("hide"))) continue;
            item.put("layoutOpts", this.utils.obj2Str(e.getValue()));
            fields.add(item);
        }
        return fields;
    }

    public Map<String, Map<String, String>> jointTables(Map<String, Object> params) {
        Map joint = this.utils.obj2Map(params.get("joint"));
        Map<String, Object> where = this.utils.newMap(params, "fieldUri");
        if (!this.utils.isEmpty(joint.keySet())) {
            where.put(this.utils.pHolder("fieldAlias", "in"), joint.keySet());
        }
        List<Map<String, String>> list = this.aolai.findAll("FIELD", where);
        Map<String, String> layoutOne = this.getLayoutBy(where.get("fieldUri"), "");
        Map<String, Map<String, String>> tables = this.utils.json2Map(layoutOne.get("layoutJoint"));
        for (Map<String, String> field : list) {
            String alias = field.get("fieldAlias");
            Map map = (Map)joint.get(alias);
            if (this.utils.isEmpty(map)) continue;
            Map<String, String> cond = tables.get(field.get("fieldOrigin"));
            Object key = map.get("key");
            Object val = map.get("val");
            val = ConfUtil.opExpr(key, val);
            String fieldKey = FmtUtil.pHolder(alias, ConfUtil.getOpr(key));
            if (cond != null && val instanceof CharSequence) {
                cond.put(fieldKey, String.valueOf(val));
                cond.put(null, "inner");
                continue;
            }
            params.put(fieldKey, val);
        }
        return tables;
    }

    public Map<String, Map<String, Object>> jointCond(String alias, Object opKey, Object opVal) {
        HashMap<String, Map<String, Object>> joint = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> map0 = new HashMap<String, Object>();
        map0.put("key", opKey);
        map0.put("val", opVal);
        joint.put(alias, map0);
        return joint;
    }

    public Map<String, Map<String, Object>> jointCond(Map<String, Map<String, Object>> joint, String alias, Object opKey, Object opVal) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("key", opKey);
        map1.put("val", opVal);
        joint.put(alias, map1);
        return joint;
    }

    static {
        loSet.add("layoutHead");
        loSet.add("layoutOpts");
        loSet.add("layoutJoint");
    }
}

