/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.dao.AolaiDao;
import cn.ps1.aolai.service.LayoutService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.FmtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class GmetaService {
    private static Logger log = LoggerFactory.getLogger(GmetaService.class);
    static final String META_TABLE = "META_TABLE";
    static final String META_SORT = "META_SORT";
    static final String TENANT = "TENANT";
    static final String OP_UID = "OpUid";
    static final String CREATOR = "Creator";
    static final String[] ORDER_BY = new String[]{"ASC", "DESC"};
    static final Pattern P_DIGIT = Pattern.compile("\\d+");
    static final Pattern P_QUOTE = Pattern.compile("\\{ *\\w+ *\\}");
    static final Pattern P_PLACE = Pattern.compile("\\{ *[V0-9]* *\\}");
    static final Pattern P_JSON = Pattern.compile("^,'\\$(\\.\\w+)+'\\)$");
    static final String DUPL = "dupl";
    static final String M_PKEY = "!p";
    static final String M_I18N = "!i";
    static final String M_TYPE = "!t";
    static final String M_STYLE = "!s";
    static final String LEFT = "left";
    static final String UL = "_";
    static final String CAST = "CAST(";
    static final String R_PAREN = "')";
    static final String NUL = "''";
    @Autowired
    AolaiDao dao;
    @Autowired
    LayoutService layout;
    @Autowired
    RedisService redis;
    @Autowired
    UtilsService utils;
    @Autowired
    HttpServletRequest req;
    @Autowired
    private ApplicationContext appCtx;

    Map<String, String> gMetaOne() {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("META_TABLE=", "GMETA");
        List<Map<String, String>> list = this.dao.findList(this.gMetaParams(), cond);
        return this.utils.list2Map(list, "alias", "field");
    }

    boolean isPostgres() {
        return this.appCtx.containsBean("dsPostgres");
    }

    public Object tenantId() {
        return this.utils.jsonParams().get(ConfUtil.dbid());
    }

    public String tenantKey(Object table) {
        return table + UL + TENANT;
    }

    Object rdsDbid() {
        Object tid = this.tenantId();
        return ConfUtil.isCustomMeta() && tid != null ? tid + "." : "";
    }

    Object inuseBase() {
        return this.utils.jsonParams().get("base");
    }

    Object i18n(Object lang) {
        return lang == null ? this.utils.jsonParams().get("i18n") : lang;
    }

    public String tableOf(String tableName) {
        return this.getTable(null, tableName);
    }

    Map<String, Object> setDataIsolation(Map<String, Object> cond, String table) {
        if (ConfUtil.dataIsolation()) {
            cond.put(this.tenantKey(table) + "=", this.tenantId());
        }
        return cond;
    }

    private Map<String, String> addRecord(Object base, String table, Map<String, String> dto, Map<String, Object> data, boolean dupl) {
        data = this.setFieldData(dto, data, true);
        if (ConfUtil.dataIsolation()) {
            data.put(this.tenantKey(table), this.tenantId());
        }
        Map<String, String> map = this.duplCheck(base, table, dto, dupl);
        log.debug("addRecord...{}", data);
        return this.utils.result(this.dao.addOne(map, data) > 0);
    }

    private Map<String, String> duplCheck(Object base, String table, Map<String, String> dto, boolean dupl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        if (dupl) {
            map.put(DUPL, this.isPostgres() ? this.getDuplPks(table, dto) : "");
        }
        return map;
    }

    private String getDuplPks(String table, Map<String, String> dto) {
        return this.getMetaPks(dto, ConfUtil.dataIsolation() ? this.tenantKey(table) : "");
    }

    private String getMetaPks(Map<String, String> dto, String pk) {
        StringJoiner jt = new StringJoiner(",");
        if (pk.length() > 0) {
            jt.add(pk);
        }
        for (Map.Entry<String, String> e : dto.entrySet()) {
            if (!e.getKey().contains(M_PKEY) || !"1".equals(e.getValue())) continue;
            jt.add(dto.get(e.getKey().split("!")[0]));
        }
        return jt.toString();
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(base, table, this.getDto(table), data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(null, table, data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data) {
        return this.addRecord(null, table, data, false);
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data) {
        return this.addRecord(base, table, data, false);
    }

    private Map<String, String> batchAdd(Object base, String table, Map<String, String> dto, List<Map<String, Object>> list, Object lang, boolean dupl) {
        if (list.isEmpty()) {
            throw new FailedException();
        }
        Map<String, Object> data = list.get(0);
        data.put("i18n", lang);
        data = this.setFieldData(dto, data, false);
        String operUid = null;
        String creator = null;
        Iterator<Map.Entry<String, Object>> iterator = data.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Object> e = iterator.next();
            String string = e.getKey().split(UL)[0].toLowerCase();
            operUid = string + OP_UID;
            creator = string + CREATOR;
        }
        Object userId = this.req.getAttribute("userId");
        for (Map map : list) {
            for (Map.Entry e : map.entrySet()) {
                this.validationRules(dto, e);
            }
            map.put(operUid, userId);
            map.put(creator, userId);
            if (!ConfUtil.dataIsolation()) continue;
            map.put(TENANT, this.tenantId());
        }
        if (ConfUtil.dataIsolation()) {
            data.put(this.tenantKey(table), TENANT);
        }
        Map<String, String> map = this.duplCheck(base, table, dto, dupl);
        log.debug("batchAdd...{}", map);
        return this.utils.result(this.dao.batchAdd(map, data, list) > 0);
    }

    public Map<String, String> batchAdd(Object base, String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(base, table, this.getDto(table), items, lang, dupl);
    }

    @Deprecated
    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map, boolean dupl) {
        return this.batchAdd(table, items, dupl);
    }

    @Deprecated
    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map) {
        return this.batchAdd(table, items, map.containsKey(DUPL));
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(null, table, items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, boolean dupl) {
        return this.batchAdd(null, table, this.getDto(table), items, null, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang) {
        return this.batchAdd(table, items, lang, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items) {
        return this.batchAdd(table, items, false);
    }

    @Deprecated
    public Map<String, String> batchAdd(Map<String, String> map) {
        List<Map<String, Object>> list = this.utils.json2List(map.get("items"));
        return this.batchAdd(map.get("table"), list, map.containsKey(DUPL));
    }

    private Map<String, String> delete(Object base, String table, Map<String, String> dto, Map<String, Object> cond, Object joint) {
        if ((cond = this.setCondition(dto, cond, joint)).isEmpty()) {
            throw new FailedException();
        }
        cond = this.setDataIsolation(cond, table);
        return this.utils.result(this.dao.delete(this.getTable(base, table), cond) > 0);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> cond, Object joint) {
        return this.delete(base, table, this.getDto(table), cond, joint);
    }

    @Deprecated
    public Map<String, String> delete(String table, Map<String, Object> cond, Object joint) {
        return this.delete(null, table, cond, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> cond) {
        return this.delete(null, table, cond, null);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> cond) {
        return this.delete(base, table, cond, null);
    }

    private Map<String, String> batchDelete(Object base, String table, Map<String, String> dto, List<Map<String, Object>> list, String joint) {
        String theTable = this.getTable(base, table);
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> cond = this.setCondition(dto, list.get(i), joint);
            if (cond.isEmpty()) continue;
            this.setDataIsolation(cond, table);
            count += this.dao.delete(theTable, cond);
        }
        return this.utils.result(count > 0);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list) {
        return this.batchDelete(base, table, this.getDto(table), list, null);
    }

    public Map<String, String> batchDelete(String table, List<Map<String, Object>> list) {
        return this.batchDelete(null, table, list);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list, String joint) {
        return this.batchDelete(base, table, this.getDto(table), list, joint);
    }

    @Deprecated
    public Map<String, String> batchDelete(String table, List<Map<String, Object>> list, String joint) {
        return this.batchDelete(null, table, list, joint);
    }

    private Map<String, String> update(Object base, String table, Map<String, String> dto, Map<String, Object> item, Map<String, Object> cond, Object joint) {
        cond = this.setCondition(dto, cond, joint);
        item = this.setCondition(dto, item, null, true);
        if (cond.isEmpty() || item.isEmpty()) {
            throw new FailedException();
        }
        this.setDataIsolation(cond, table);
        return this.utils.result(this.dao.update(this.getTable(base, table), item, cond) > 0);
    }

    @Deprecated
    public Map<String, String> update(Object base, String table, Map<String, Object> item, Map<String, Object> cond, Object joint) {
        return this.update(base, table, this.getDto(table), item, cond, joint);
    }

    @Deprecated
    public Map<String, String> update(String table, Map<String, Object> item, Map<String, Object> cond, Object joint) {
        return this.update(null, table, this.getDto(table), item, cond, joint);
    }

    public Map<String, String> update(Object base, String table, Map<String, Object> item, Map<String, Object> cond) {
        return this.update(base, table, this.getDto(table), item, cond, null);
    }

    public Map<String, String> update(String table, Map<String, Object> item, Map<String, Object> cond) {
        return this.update(null, table, item, cond);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String limit) {
        return this.findList(base, tables, uriKey, cond, sort, LEFT, limit);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String left, String limit) {
        HashMap<String, String> allDto = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> e : tables.entrySet()) {
            allDto.putAll(this.getDto(e.getKey()));
        }
        String[] table = this.joinTables(base, allDto, tables, left);
        Map<String, String> args = this.queryArgs(table[1], uriKey, limit);
        cond = this.setArgsAndCond(args, allDto, cond, sort);
        cond = this.setDataIsolation(cond, table[0]);
        Map<String, String> dto = this.getDtoBy(allDto, uriKey);
        return this.setBlur(this.dao.findList(args, cond), dto);
    }

    Map<String, String> queryArgs(String table, String uriKey, String limit) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", table);
        args.put("alias", uriKey);
        args.put("limit", limit);
        return args;
    }

    String[] joinTables(Object base, Map<String, String> allDto, Map<String, Map<String, String>> tables, String left) {
        String dbid = this.utils.quote(this.tenantId());
        Object lang = this.i18n(null);
        String[] t = new String[2];
        StringJoiner jt = new StringJoiner(" ", " ", "");
        for (Map.Entry<String, Map<String, String>> e : tables.entrySet()) {
            Map<String, String> cond = tables.get(e.getKey());
            String table = this.getTable(base, e.getKey());
            if (this.utils.isEmpty(cond)) {
                t[0] = e.getKey();
                t[1] = table;
                continue;
            }
            jt.add(this.leftJoin(left, table, cond));
            if (ConfUtil.dataIsolation()) {
                jt.add(this.tenantKey(e.getKey()) + "=" + dbid);
            }
            int n = 0;
            for (Map.Entry<String, String> ent : cond.entrySet()) {
                String condKey;
                if (ent.getValue() == null || (condKey = this.relateCond(allDto, ent, lang)) == null) continue;
                if (n++ > 0 || ConfUtil.dataIsolation()) {
                    jt.add("and");
                }
                jt.add(condKey);
            }
        }
        t[1] = t[1] + jt.toString();
        return t;
    }

    private String leftJoin(String left, String table, Map<String, String> cond) {
        String inner = cond.get(null);
        if (inner != null) {
            cond.remove(null);
            left = inner;
        } else if (left == null) {
            return String.join((CharSequence)" ", "join", table, "on");
        }
        return String.join((CharSequence)" ", left, "join", table, "on");
    }

    private String relateCond(Map<String, String> allDto, Map.Entry<String, String> ent, Object lang) {
        String key = ent.getKey();
        String val = ent.getValue();
        val = allDto.containsKey(val) ? this.i18n(allDto, val, lang) : this.utils.sqlVal(val);
        if (allDto.containsKey(key)) {
            return this.i18n(allDto, key, lang) + "=" + val;
        }
        if (P_QUOTE.matcher(key).find()) {
            return this.getFieldKey(allDto, key, new String[0], lang) + val;
        }
        throw new FailedException(null, key);
    }

    private void setLimitRows(Map<String, String> args, Map<String, Object> cond) {
        int pSize = this.utils.getInt(cond, "pageSize");
        if (pSize > 0) {
            int pNo = this.utils.getInt(cond, "pageNo") - 1;
            args.put("floor", pNo > 0 ? String.valueOf(pNo * pSize) : "0");
            args.put("limit", String.valueOf(pSize));
            return;
        }
        String limit = args.get("limit");
        if (!this.utils.isInteger(limit)) {
            args.put("limit", ConfUtil.limitRows());
        } else if ("0".equals(limit)) {
            args.remove("limit");
        }
    }

    Map<String, Object> setArgsAndCond(Map<String, String> args, Map<String, String> allDto, Map<String, Object> cond, Map<String, String> sort) {
        Object lang = this.i18n(cond.get("i18n"));
        args.put("alias", this.setAlias(allDto, args.get("alias"), lang));
        args.put("order", this.orderBy(allDto, sort, lang));
        this.setLimitRows(args, cond);
        return this.setCondition(allDto, cond, args.get("joint"));
    }

    List<Map<String, String>> setBlur(List<Map<String, String>> list, Map<String, String> dto) {
        Map<String, String> blur;
        if (!list.isEmpty() && !(blur = this.setBlur(list.get(0), dto)).isEmpty()) {
            log.debug("setBlur...{}", dto);
            for (int i = 1; i < list.size(); ++i) {
                Map<String, String> row = list.get(i);
                for (Map.Entry<String, String> e : blur.entrySet()) {
                    row.put(e.getKey(), FmtUtil.blur(row.get(e.getKey()), e.getValue()));
                }
            }
        }
        return list;
    }

    private Map<String, String> setBlur(Map<String, String> item, Map<String, String> dto) {
        Map.Entry<String, String> e;
        String style;
        HashMap<String, String> blur = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iterator = item.entrySet().iterator();
        while (iterator.hasNext() && (style = dto.get((e = iterator.next()).getKey() + M_STYLE)) != null) {
            Map tmp = this.utils.json2Map(style);
            if ((style = (String)tmp.get("blur")) == null) continue;
            blur.put(e.getKey(), style);
            item.put(e.getKey(), FmtUtil.blur(item.get(e.getKey()), style));
        }
        return blur;
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> cond, Map<String, String> sort) {
        String table = args.get("table");
        String uriKey = args.get("alias");
        Map<String, String> allDto = this.getDto(table);
        args.put("table", this.tableOf(table));
        cond = this.setArgsAndCond(args, allDto, cond, sort);
        cond = this.setDataIsolation(cond, table);
        Map<String, String> dto = this.getDtoBy(allDto, uriKey);
        return this.setBlur(this.dao.findList(args, cond), dto);
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> cond) {
        return this.findList(args, cond, null);
    }

    public List<Map<String, String>> findList(Object base, String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        String[] args = new String[]{(String)base, table, uriKey};
        return this.findAll(cond, sort, args);
    }

    public List<Map<String, String>> findList(String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.findList(null, table, uriKey, cond, sort);
    }

    public List<Map<String, String>> findAll(Object base, String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        String[] args = new String[]{(String)base, table, uriKey, "0"};
        return this.findAll(cond, sort, args);
    }

    public List<Map<String, String>> findAll(String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        return this.findAll(null, table, uriKey, cond, sort);
    }

    public List<Map<String, String>> findList(Object base, String table, String uriKey, Map<String, Object> cond) {
        return this.findList(base, table, uriKey, cond, null);
    }

    public List<Map<String, String>> findAll(Object base, String table, String uriKey, Map<String, Object> cond) {
        return this.findAll(base, table, uriKey, cond, null);
    }

    public List<Map<String, String>> findList(String table, String uriKey, Map<String, Object> cond) {
        return this.findList(null, table, uriKey, cond, null);
    }

    public List<Map<String, String>> findAll(String table, String uriKey, Map<String, Object> cond) {
        return this.findAll(null, table, uriKey, cond, null);
    }

    public List<Map<String, String>> findList(String table, Map<String, Object> cond) {
        return this.findList(table, null, cond);
    }

    public List<Map<String, String>> findAll(String table, Map<String, Object> cond) {
        return this.findAll(table, null, cond);
    }

    public List<Map<String, String>> findAll(Map<String, Object> cond, Map<String, String> sort, String[] args) {
        Map<String, String> map = this.convertArgs(args);
        return map == null ? new ArrayList<Map<String, String>>() : this.findList(map, cond, sort);
    }

    Map<String, String> convertArgs(String[] args) {
        if (args == null || args.length < 2) {
            return null;
        }
        String[] keys = new String[]{"base", "table", "alias", "limit"};
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length && i < keys.length; ++i) {
            map.put(keys[i], args[i]);
        }
        return map;
    }

    Map<String, String> findOne(String table, Set<String> alias, Map<String, Object> cond) {
        Map<String, String> dto = this.getDto(table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.tableOf(table));
        map.put("alias", this.fieldAsAlias(dto, alias, cond.get("i18n")));
        return this.dao.findOne(map, this.setCondition(table, dto, cond));
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> cond, String uriKey) {
        Map<String, String> dto = this.getDto(table);
        Map<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("alias", this.setAlias(dto, uriKey, cond.get("i18n")));
        map = this.dao.findOne(map, this.setCondition(table, dto, cond));
        if (map == null) {
            return this.utils.result(false);
        }
        this.setBlur(map, dto);
        return map;
    }

    public Map<String, String> findOne(String table, Map<String, Object> cond, String uriKey) {
        return this.findOne(null, table, cond, uriKey);
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> cond) {
        return this.findOne(base, table, cond, null);
    }

    public Map<String, String> findOne(String table, Map<String, Object> cond) {
        return this.findOne(null, table, cond, null);
    }

    private boolean exists(Object base, String table, Map<String, String> dto, Map<String, Object> cond, Object joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        cond = this.setCondition(dto, cond, joint);
        cond = this.setDataIsolation(cond, table);
        return this.dao.countRows(map, cond) > 0;
    }

    @Deprecated
    public boolean exists(Object base, String table, Map<String, Object> cond, Object joint) {
        return this.exists(base, table, this.getDto(table), cond, joint);
    }

    @Deprecated
    public boolean exists(String table, Map<String, Object> cond, Object joint) {
        return this.exists(null, table, this.getDto(table), cond, joint);
    }

    public boolean exists(Object base, String table, Map<String, Object> cond) {
        return this.exists(base, table, this.getDto(table), cond, null);
    }

    public boolean exists(String table, Map<String, Object> cond) {
        return this.exists(null, table, cond);
    }

    public int count(String table, Map<String, Object> cond) {
        return this.count(null, table, cond, null);
    }

    public int count(Object base, String table, Map<String, Object> cond) {
        return this.count(base, table, cond, null);
    }

    public int count(Object base, String table, Map<String, Object> cond, String joint) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", this.getTable(base, table));
        cond = this.setCondition(this.getDto(table), cond, joint);
        cond = this.setDataIsolation(cond, table);
        return this.dao.countRows(args, cond);
    }

    private void cacheActionInfo(Map<String, Object> map) {
        map.put("alias", this.setAlias("ACTION", null));
        List<Map<String, String>> list = this.dao.getActionList(map);
        Map<String, String> uriMap = this.actionRole(list);
        if (!uriMap.isEmpty()) {
            Object[] keys = new Object[]{map.get("appCode"), map.get("compId"), map.get("dutyId")};
            this.redis.setActionRole(this.utils.join(keys, "."), uriMap);
            log.debug("cacheActionRole...{}", uriMap);
        }
    }

    Map<String, String> actionRole(List<Map<String, String>> list) {
        HashMap<String, String> uriMap = new HashMap<String, String>();
        for (Map<String, String> item : list) {
            String uri = item.get("actUri");
            uriMap.put(uri.substring(uri.indexOf(47) + 1), item.get("actState"));
        }
        return uriMap;
    }

    public List<Map<String, String>> getMenuRole(Map<String, Object> params) {
        if (this.utils.isEmpty(params)) {
            return new ArrayList<Map<String, String>>();
        }
        this.cacheActionInfo(params);
        params.put("alias", this.getAlias("getMenuRole", null));
        List<Map<String, String>> list = this.dao.getMenuRole(params);
        this.mergeMenuRole(list);
        return list;
    }

    public Map<String, Object> getRoleParams(Map<String, Object> params, Map<String, String> user) {
        Map<String, Object> map = this.utils.newCond(params);
        Object appCode = params.get("appCode");
        if (appCode != null) {
            map.put("compId", user.get("userComp"));
            Map uDuty = this.utils.json2Map(user.get("userDuty"));
            if (uDuty.containsKey(appCode)) {
                map.put("dutyId", uDuty.get(appCode));
                map.put("appCode", appCode);
            }
        }
        return map;
    }

    private Map<String, String> mergeMenuRole(List<Map<String, String>> list) {
        String[] keys = new String[]{"pageId", "pageRoute", "roleAction"};
        if (list.size() == 1) {
            return this.utils.list2Map(list, keys[1], keys[2]);
        }
        HashMap<String, String> menu = new HashMap<String, String>();
        for (int i = list.size() - 1; i > 0; --i) {
            Map<String, String> tmp0 = list.get(i);
            Map<String, String> tmp1 = list.get(i - 1);
            String page0 = tmp0.get(keys[0]);
            String page1 = tmp1.get(keys[0]);
            int ra = Integer.parseInt(tmp0.get(keys[2]));
            if (page1.equals(page0)) {
                ra = Integer.parseInt(tmp1.get(keys[2])) | ra;
                tmp1.put(keys[2], String.valueOf(ra));
                list.remove(i);
            } else {
                menu.put(tmp0.get(keys[1]), tmp0.get(keys[2]));
            }
            if (i != 1) continue;
            menu.put(tmp1.get(keys[1]), tmp1.get(keys[2]));
        }
        return menu;
    }

    public Map<String, String> setParam(Map<String, Object> params) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("paramBb", params.get("kmbb"));
        cond.put("paramKey", params.get("paramKey"));
        return this.update("PARAM", params, cond);
    }

    private String getParam(Object base, Object kmbb, Object key) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("paramKey", key);
        cond.put("paramBb", kmbb == null ? "00" : kmbb);
        return this.findOne(base, "PARAM", cond).get("paramVal");
    }

    public String getParam(Map<String, ?> cond, Object key) {
        return this.getParam(null, cond.get("kmbb"), key);
    }

    public List<Map<String, String>> getParams(Map<String, Object> cond) {
        return this.findList(null, "PARAM", "", cond);
    }

    private String i18n(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        if (dto.containsKey(key + M_I18N)) {
            return this.utils.isEmpty(lang) ? NUL : field + UL + lang;
        }
        return field;
    }

    private String orderBy(Map<String, String> dto, Map<String, String> sort, Object lang) {
        if (this.utils.isEmpty(sort)) {
            return this.getMetaPks(dto, "");
        }
        StringJoiner jt = new StringJoiner(",");
        for (Map.Entry<String, String> e : sort.entrySet()) {
            if (!dto.containsKey(e.getKey())) continue;
            String key = this.i18n(dto, e.getKey(), lang);
            String val = e.getValue();
            if (this.utils.isEmpty(val)) {
                jt.add(key);
                continue;
            }
            if (this.utils.findIn(ORDER_BY, (Object)val.toUpperCase())) {
                jt.add(key + " " + val);
                continue;
            }
            throw new FailedException();
        }
        return jt.toString();
    }

    Map<String, Object> setCondition(String table, Map<String, String> dto, Map<String, Object> cond) {
        return this.setDataIsolation(this.setCondition(dto, cond), table);
    }

    private Map<String, Object> setCondition(Map<String, String> dto, Map<String, Object> cond, Object joint) {
        return this.setCondition(dto, cond, joint, false);
    }

    private Map<String, Object> setCondition(Map<String, String> dto, Map<String, Object> cond) {
        return this.setCondition(dto, cond, null, false);
    }

    private Map<String, Object> setCondition(Map<String, String> dto, Map<String, Object> params, Object joint, boolean isUpdate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params == null) {
            return map;
        }
        Object lang = this.i18n(params.get("i18n"));
        for (Map.Entry<String, Object> e : params.entrySet()) {
            boolean isHolder;
            String[] vArr;
            Object val = e.getValue();
            if (val == null) continue;
            String key = e.getKey();
            if (dto.containsKey(key)) {
                this.validationRules(dto, e);
                key = this.i18n(dto, key, lang);
                if (isUpdate) {
                    isUpdate = this.setOperUid(map, dto, key, true, true);
                }
                key = key + (joint == null ? "=" : " " + joint);
                map.put(key, val);
                continue;
            }
            if (!P_QUOTE.matcher(key).find() || (key = this.getFieldKey(dto, key, vArr = (isHolder = P_PLACE.matcher(key).find()) ? this.utils.toArr(val) : new String[]{}, lang)) == null) continue;
            map.put(key, isHolder ? null : val);
        }
        log.debug("setCondition...{}", map);
        return map;
    }

    private boolean setOperUid(Map<String, Object> item, Map<String, String> dto, String field, boolean isValue, boolean isUpdate) {
        String creator;
        String key = field.split(UL)[0];
        String key0 = key.toLowerCase();
        String operUid = key0 + OP_UID;
        Map<String, String> self = this.utils.userSelf();
        String userId = self.get("userId");
        boolean isSuccess = false;
        if (dto.containsKey(operUid)) {
            field = String.join((CharSequence)UL, key, isUpdate ? "OPUID=" : "OPUID");
            item.put(field, isValue ? userId : operUid);
            isSuccess = true;
        }
        if (!isUpdate && dto.containsKey(creator = key0 + CREATOR)) {
            field = String.join((CharSequence)UL, key, "CREATOR");
            item.put(field, isValue ? userId : creator);
            isSuccess = true;
        }
        this.addOperInfo(isSuccess, self);
        return false;
    }

    private void addOperInfo(boolean isSuccess, Map<String, String> self) {
        if (isSuccess && ConfUtil.isCustomMeta()) {
            HashMap<String, Object> oper = new HashMap<String, Object>();
            oper.put("operUid", self.get("userId"));
            oper.put("operName", self.get("userName"));
            this.addRecord("OPER", oper, true);
        }
    }

    @Deprecated
    public String getWhere(Map<String, String> dto, String expr, Object lang) {
        return this.getFieldKey(dto, expr, new String[0], lang);
    }

    private String getFieldKey(Map<String, String> dto, String expr, String[] vArr, Object lang) {
        String[] arr = expr.split("\\{ *");
        int v = 0;
        if (arr.length > 1 && this.isValidExpr(arr[0])) {
            for (int i = 1; i < arr.length; ++i) {
                String[] keys = arr[i].split(" *\\}");
                if (keys.length == 0) {
                    if (vArr.length <= v) continue;
                    arr[i] = this.validText(vArr[v++]);
                    continue;
                }
                if (dto.containsKey(keys[0])) {
                    arr[i] = this.i18n(dto, keys[0], lang) + this.validExpr(keys);
                    continue;
                }
                if (this.utils.isMatch(keys[0], "V?")) {
                    if (vArr.length <= v) continue;
                    arr[i] = this.validText(vArr[v++]) + this.validExpr(keys);
                    continue;
                }
                if (this.utils.isMatch(keys[0], "[0-9]")) {
                    int p = Integer.parseInt(keys[0]);
                    if (vArr.length <= p) continue;
                    arr[i] = this.validText(vArr[p]) + this.validExpr(keys);
                    continue;
                }
                return null;
            }
            return this.utils.join(arr);
        }
        return null;
    }

    private String validText(String val) {
        if (Pattern.matches(ConfUtil.sqlVText(), val)) {
            return val;
        }
        throw new FailedException(null, val);
    }

    private boolean isValidExpr(String expr) {
        if (expr.length() > 0) {
            String[] keys;
            for (String key : keys = expr.split(" +")) {
                if (ConfUtil.isSqlExpr(key) || P_JSON.matcher(key).find()) continue;
                log.error("invalid expr...{}", (Object)key);
                return false;
            }
        }
        return true;
    }

    private String validExpr(String[] keys) {
        if (keys.length > 1 && this.isValidExpr(keys[1])) {
            return keys[1];
        }
        throw new FailedException();
    }

    private Map<String, Object> setFieldData(Map<String, String> dto, Map<String, Object> data, boolean isValue) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        Object lang = this.i18n(data.get("i18n"));
        boolean insertOne = true;
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (!dto.containsKey(e.getKey())) continue;
            String key = this.i18n(dto, e.getKey(), lang);
            if (insertOne) {
                insertOne = this.setOperUid(item, dto, key, isValue, false);
            }
            if (isValue && this.validationRules(dto, e)) {
                item.put(key, e.getValue());
                continue;
            }
            item.put(key, e.getKey());
        }
        if (!item.isEmpty()) {
            return item;
        }
        throw new FailedException();
    }

    private boolean validationRules(Map<String, String> dto, Map.Entry<String, ?> e) {
        if (ConfUtil.avoidRules() || e.getValue() == null) {
            return true;
        }
        String type = dto.get(e.getKey() + M_TYPE);
        if (type == null) {
            return false;
        }
        String val = String.valueOf(e.getValue());
        Matcher matcher = P_DIGIT.matcher(type);
        if (matcher.find()) {
            if (Integer.parseInt(matcher.group()) >= val.length()) {
                return true;
            }
        } else if (type.contains("IN")) {
            if (this.utils.isInteger(val)) {
                return true;
            }
        } else {
            if (type.contains("J")) {
                return true;
            }
            if (type.contains("T")) {
                if (this.utils.isDatetime(val, "yyyy-MM-dd HH:mm:ss")) {
                    return true;
                }
            } else if (type.contains("L")) {
                if (this.utils.isNumeric(val)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        throw new FailedException(null, e.getKey());
    }

    public String setAlias(String table, Object lang) {
        return this.setAlias(table, null, lang);
    }

    public String setAlias(String table, String uriKey, Object lang) {
        return this.setAlias(this.getDto(table), uriKey, lang);
    }

    private String setAlias(Map<String, String> dto, String uriKey, Object lang) {
        lang = this.i18n(lang);
        if (this.utils.isEmpty(uriKey)) {
            return this.fieldAsAlias(dto, lang);
        }
        Map<String, String> alias = this.aliasArrayBy(uriKey);
        if (alias.isEmpty()) {
            return this.fieldAsAlias(dto, lang);
        }
        return this.fieldAsAlias(dto, alias.keySet(), lang);
    }

    Map<String, String> aliasArrayBy(String uriKey) {
        if (ConfUtil.isCustomMeta()) {
            return this.layout.getAliasArray(this.layout.getLayoutBy(uriKey), "blur");
        }
        HashMap<String, String> alias = new HashMap<String, String>();
        String val = ConfUtil.getParam(uriKey);
        if (val.length() > 0) {
            for (String key : val.split(",|;")) {
                alias.put(key, null);
            }
        }
        return alias;
    }

    private String fieldAsAlias(Map<String, String> dto, Set<String> keys, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (String key : keys) {
            jt.add(this.fieldAsAlias(dto, key, lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (Map.Entry<String, String> e : dto.entrySet()) {
            if (e.getKey().contains("!")) continue;
            jt.add(this.fieldAsAlias(dto, e.getKey(), lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        String type = dto.get(key + M_TYPE);
        String keyStr = FmtUtil.quote(key, "\"");
        if (type != null) {
            if (type.matches("[IJSBD].+") || type.contains("IN")) {
                field = CAST + field + (this.isPostgres() ? " as TEXT)" : " as CHAR)");
            } else if (type.matches("T.+")) {
                field = this.isPostgres() ? "to_char(" + field + ",'yyyy-MM-dd hh24:mi:ss" + (type.length() > 9 ? ".ms" : "") + R_PAREN : "DATE_FORMAT(" + field + ",'%Y-%m-%d %T" + (type.length() > 9 ? ".%f" : "") + R_PAREN;
            } else if (dto.containsKey(key + M_I18N)) {
                field = this.utils.isEmpty(lang) ? NUL : field + UL + lang;
            }
        } else if (field == null) {
            field = NUL;
        }
        return String.join((CharSequence)" ", field, "as", keyStr);
    }

    public String getAlias(String uriKey, Object lang) {
        return this.fieldAsAlias(this.getDtoBy(null, uriKey), this.i18n(lang));
    }

    public String getField(String table, Object lang) {
        return this.fieldAsAlias(this.getDto(table), this.i18n(lang));
    }

    private Map<String, String> getFields(Map<String, String> dto, String[] keyArr, Object lang) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyArr != null) {
            for (String key : keyArr) {
                if (!dto.containsKey(key)) continue;
                map.put(key, this.i18n(dto, key, lang));
            }
        }
        return map;
    }

    Map<String, String> getDto(Object table) {
        String rk = "m." + table + this.rdsDbid();
        String val = this.redis.get(rk);
        if (val == null) {
            Map<String, String> dto = this.toDto(this.getTableMeta(table), new HashMap<String, String>());
            if (dto.isEmpty()) {
                log.error("getDto...table={}", table);
                throw new FailedException("noDataFound");
            }
            this.redis.set(rk, this.utils.obj2Str(dto), 3600);
            return dto;
        }
        return this.utils.json2Map(val);
    }

    Map<String, String> getDtoBy(Map<String, String> allDto, String uriKey) {
        if (this.utils.isEmpty(uriKey)) {
            return allDto;
        }
        String rk = "m." + uriKey + this.rdsDbid();
        Map<String, String> dto = this.redis.hmget(rk);
        if (dto.isEmpty()) {
            Map<String, String> alias = this.aliasArrayBy(uriKey);
            if (alias.isEmpty()) {
                log.error("getDtoBy...uriKey={}", (Object)uriKey);
                throw new FailedException("noDataFound");
            }
            dto = allDto == null ? this.toDto(this.dao.getMetaBy(this.gMetaParams(), alias.keySet()), alias) : this.getDtoBy(allDto, alias.keySet());
            this.redis.hmset(rk, dto, 3600);
        }
        return dto;
    }

    private Map<String, String> getDtoBy(Map<String, String> allDto, Set<String> keySet) {
        HashMap<String, String> dto = new HashMap<String, String>();
        for (String key : keySet) {
            Pattern pattern = Pattern.compile("^" + key);
            for (Map.Entry<String, String> e : allDto.entrySet()) {
                if (!pattern.matcher(e.getKey()).find()) continue;
                dto.put(e.getKey(), e.getValue());
            }
        }
        return dto;
    }

    private Map<String, String> toDto(List<Map<String, String>> metaList, Map<String, String> keys) {
        HashMap<String, String> dto = new HashMap<String, String>();
        for (int i = 0; i < metaList.size(); ++i) {
            Map<String, String> meta = metaList.get(i);
            String alias = meta.get("alias");
            dto.put(alias, meta.get("field"));
            dto.put(alias + M_TYPE, meta.get("type"));
            if ("1".equals(meta.get("pkey"))) {
                dto.put(alias + M_PKEY, "1");
            }
            if ("1".equals(meta.get("lang"))) {
                dto.put(alias + M_I18N, "1");
            }
            if (meta.get("style") == null || keys.get(alias) != null) continue;
            dto.put(alias + M_STYLE, meta.get("style"));
        }
        return dto;
    }

    public List<Map<String, String>> getTableMeta(Object table) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("META_TABLE=", table);
        if (ConfUtil.dataIsolation()) {
            Object tid = ConfUtil.isCustomMeta() ? this.tenantId() : "0";
            cond.put(this.tenantKey("GMETA") + "=", tid);
        }
        return this.dao.findList(this.gMetaParams(), cond);
    }

    public List<Map<String, String>> getMeta(String uriKey) {
        Map<String, String> alias = this.aliasArrayBy(uriKey);
        if (alias.isEmpty()) {
            return new ArrayList<Map<String, String>>();
        }
        return this.dao.getMetaBy(this.gMetaParams(), alias.keySet());
    }

    Map<String, String> gMetaParams() {
        Map<String, String> metas = ConfUtil.gMETAS();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.gmetaTable());
        map.put("alias", this.fieldAsAlias(metas, null));
        map.put("order", META_SORT);
        return map;
    }

    private String gmetaTable() {
        if (ConfUtil.isCustomMeta()) {
            return this.tableOf("GMETA");
        }
        if (this.isPostgres()) {
            return ConfUtil.baseMain() + "." + "GMETA";
        }
        return "GMETA";
    }

    public String getTable(Object base, String table) {
        Object object = base = base == null ? this.inuseBase() : base;
        if (this.isPostgres()) {
            if (base != null && !ConfUtil.dataIsolation()) {
                table = base + table;
                String db = String.valueOf(base);
                if (db.charAt(db.length() - 1) == '.') {
                    return table;
                }
            }
            CharSequence[] keys = new String[]{ConfUtil.baseMain(), table};
            return String.join((CharSequence)".", keys);
        }
        return base == null ? table : base + table;
    }

    int getMValue(Object base, String table, String field, Map<String, Object> cond, String op) {
        Map<String, String> dto = this.getDto(table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", dto.get(field));
        map.put("func", op);
        return this.dao.getMValue(map, this.setCondition(table, dto, cond));
    }

    public List<Map<String, String>> groupCount(Object base, String table, String[] keys, Map<String, Object> cond) {
        Map<String, String> dto = this.getDto(table);
        Map<String, String> map = this.getFields(dto, keys, this.i18n(cond.get("i18n")));
        cond = this.setCondition(table, dto, cond);
        return this.dao.groupCount(this.getTable(base, table), map, cond);
    }

    boolean decrSort(String table, String key, Map<String, Object> cond) {
        Map<String, String> dto = this.getDto(table);
        cond = this.setCondition(table, dto, cond);
        return this.dao.decrSort(this.tableOf(table), dto.get(key), cond) > 0;
    }

    boolean incrSort(String table, String key, Map<String, Object> cond) {
        Map<String, String> dto = this.getDto(table);
        cond = this.setCondition(table, dto, cond);
        return this.dao.incrSort(this.tableOf(table), dto.get(key), cond) > 0;
    }
}

