/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.DigitUtil;
import cn.ps1.aolai.utils.FailedException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Digest {
    private static Logger log = LoggerFactory.getLogger(Digest.class);
    private static final String CHARS64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final byte[] SEED11 = new byte[]{68, 70, 74, 75, 77, 81, 83, 86, 87, 88, 90};
    private static ScriptEngine se = null;
    static String chars62 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".substring(52, 62) + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".substring(0, 52);
    static SecureRandom rand = new SecureRandom();
    public static final String PUB_KEY = "pubk";
    public static final String PRI_KEY = "prik";
    public static final int[] MAX_INT62 = new int[]{0, 62, 3844, 238328, 14776336, 916132832};
    static X9ECParameters sm2p256v1 = GMNamedCurves.getByName((String)"sm2p256v1");
    static ECDomainParameters domainParams = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());

    private Digest() {
        throw new IllegalStateException("Utility class");
    }

    public static String seed() {
        return new String(SEED11);
    }

    public static String randKey() {
        return Digest.randStr(SEED11, 11);
    }

    public static String randKey(int len) {
        return Digest.randStr(62, len);
    }

    public static String randInt(int len) {
        return Digest.randStr(10, len);
    }

    private static String randStr(int radix, int len) {
        StringBuilder sb = new StringBuilder();
        while (len-- > 0) {
            sb.append(chars62.charAt(rand.nextInt(radix)));
        }
        return sb.toString();
    }

    public static String randStr(int len) {
        return Digest.randKey(len);
    }

    public static String randStr(String src) {
        return Digest.randStr(src, src.length());
    }

    public static String randStr(String src, int len) {
        return Digest.randStr(src.getBytes(StandardCharsets.UTF_8), len);
    }

    private static String randStr(byte[] srcData, int len) {
        for (int i = 0; i < len; ++i) {
            int idx = rand.nextInt(srcData.length);
            if (idx == i) continue;
            byte c = srcData[idx];
            srcData[idx] = srcData[i];
            srcData[i] = c;
        }
        return new String(Arrays.copyOf(srcData, len));
    }

    public static String certStr(String src, String key) {
        String s = src + key;
        return s.toUpperCase() + s.toLowerCase() + CHARS64.substring(52);
    }

    public static String certStr(String key) {
        if (key == null) {
            return CHARS64;
        }
        if (key.length() == 26) {
            return Digest.certStr(key, "");
        }
        if (key.length() > 64) {
            return key;
        }
        return Digest.certStr("uncopyrightable", key);
    }

    public static String decrypt(String src) {
        return Digest.decrypt(src, CHARS64);
    }

    public static byte[] decrypt(char[] arr) {
        return Digest.decrypt(arr, CHARS64);
    }

    public static String decrypt(String src, String cert) {
        if (src == null) {
            return src;
        }
        return new String(Digest.decrypt(src.toCharArray(), cert));
    }

    public static byte[] decrypt(char[] arr, String cert) {
        int len;
        String key = Digest.certStr(cert);
        char pad = key.charAt(key.length() - 1);
        for (len = arr.length - 1; len > 0 && arr[len] == pad; --len) {
        }
        len = arr.length * 6 / 8 - (arr.length - 1 - len);
        byte[] raw = new byte[len];
        int[] quad = new int[4];
        int rawIdx = 0;
        for (int i = 0; i < arr.length; i += 4) {
            int block = 0;
            for (int idx = 0; idx < 4; ++idx) {
                char c = arr[i + idx];
                quad[idx] = c == pad ? 0 : key.indexOf(c);
                block += quad[idx] << 6 * (3 - idx);
            }
            for (int b = 0; b < 3 && rawIdx + b < raw.length; ++b) {
                raw[rawIdx + b] = (byte)(block >> 8 * (2 - b) & 0xFF);
            }
            rawIdx += 3;
        }
        return raw;
    }

    public static String encrypt(String src) {
        return Digest.encrypt(src.getBytes(StandardCharsets.UTF_8));
    }

    public static String encrypt(byte[] bytes) {
        return Digest.encrypt(bytes, CHARS64.getBytes());
    }

    public static String encrypt(String src, String cert) {
        return src == null ? null : Digest.encrypt(src.getBytes(StandardCharsets.UTF_8), cert);
    }

    public static String encrypt(byte[] bytes, String cert) {
        return Digest.encrypt(bytes, Digest.certStr(cert).getBytes());
    }

    private static String encrypt(byte[] bytes, byte[] keys) {
        byte[] out = new byte[(bytes.length + 2) / 3 * 4];
        int i = 0;
        int idx = 0;
        while (i < bytes.length) {
            int b;
            boolean[] trip = new boolean[]{true, false, false};
            int bit = 0xFF & bytes[i];
            for (b = 1; b < 3; ++b) {
                bit <<= 8;
                if (i >= bytes.length - b) continue;
                bit |= 0xFF & bytes[i + b];
                trip[b] = true;
            }
            for (b = 0; b < 3; ++b) {
                out[idx + 3 - b] = keys[trip[2 - b] ? bit & 0x3F : 64];
                bit >>= 6;
            }
            out[idx] = keys[bit & 0x3F];
            i += 3;
            idx += 4;
        }
        return out.length == 0 ? "" : new String(out);
    }

    private static String jsEval(String src) {
        if (se == null) {
            se = new ScriptEngineManager().getEngineByExtension("js");
        }
        try {
            src = se == null ? src : String.valueOf(se.eval(src));
        }
        catch (Exception e) {
            log.error("jsEval...{}", (Object)src);
        }
        return src;
    }

    @Deprecated
    public static String escape(String src) {
        return Digest.jsEval("escape('" + src + "')");
    }

    @Deprecated
    public static String unescape(String src) {
        return Digest.jsEval("unescape('" + src + "')");
    }

    @Deprecated
    public static String decodeURIComponent(String src) {
        return Digest.jsEval("decodeURIComponent('" + src + "')");
    }

    @Deprecated
    public static String encodeURIComponent(String src) {
        return Digest.jsEval("encodeURIComponent('" + src + "')");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean imgDecode(String src, String imgName) {
        try (FileOutputStream out = new FileOutputStream(imgName);){
            ((OutputStream)out).write(Digest.imgDecode(src));
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("imgDecode...{}", (Object)imgName);
            return false;
        }
    }

    public static byte[] imgDecode(String src) {
        String[] arr = src.split(",");
        return Digest.decode(arr.length == 1 ? arr[0] : arr[1]);
    }

    private static byte[] decode(String src) {
        return Base64.getDecoder().decode(src);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String imgEncode(String imgFile) {
        try (FileInputStream inp = new FileInputStream(imgFile);){
            byte[] bytes = new byte[((InputStream)inp).available()];
            if (((InputStream)inp).read(bytes) <= 0) return "";
            String string = Digest.encode(bytes);
            return string;
        }
        catch (IOException e) {
            log.error("imgEncode...{}", (Object)imgFile);
        }
        return "";
    }

    private static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            log.error("urlDecode...{}", (Object)url);
            return url;
        }
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            log.error("urlEncode...{}", (Object)url);
            return url;
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid8() {
        return Digest.uuid8(0);
    }

    public static String uuid8(int incr) {
        char c = chars62.charAt(rand.nextInt(62));
        return Digest.enBase62(System.currentTimeMillis() + (long)incr) + c;
    }

    @Deprecated
    public static long deBase64(String src) {
        return Digest.deBase(CHARS64, src, 64);
    }

    private static long deBase(String chars, String src, int e) {
        int i = src.length();
        long radix = 1L;
        long num = 0L;
        while (i-- > 0) {
            num += (long)chars.indexOf(src.charAt(i)) * radix;
            radix *= (long)e;
        }
        return num;
    }

    public static long deBase62(String src) {
        return Digest.deBase(chars62, src, 62);
    }

    public static String deBase62(String src, int n) {
        String s = src.substring(0, src.length() - n);
        return Digest.deBase62(s) + src.substring(src.length() - n);
    }

    @Deprecated
    public static String enBase64(long num) {
        return Digest.enBase(CHARS64, num, 64, "A");
    }

    private static String enBase(String chars, long num, int n, String def) {
        if (num <= 0L) {
            return def;
        }
        StringBuilder sb = new StringBuilder();
        do {
            Long l = num % (long)n;
            sb.append(chars.charAt(l.intValue()));
        } while ((num /= (long)n) > 0L);
        return sb.reverse().toString();
    }

    public static String enBase62(long num) {
        return Digest.enBase(chars62, num, 62, "0");
    }

    public static String enBase62(String src, int n) {
        try {
            long l = Long.parseLong(src.substring(0, src.length() - n));
            return Digest.enBase62(l) + src.substring(src.length() - n);
        }
        catch (Exception e) {
            log.error("enBase62...{}", (Object)src);
            return null;
        }
    }

    public static String getChr3(int num) {
        if (num < 1000) {
            return String.format("%03d", num);
        }
        StringBuilder sb = new StringBuilder();
        if (num < 12960) {
            int bit = (num -= 1000) / 1196;
            String s = Digest.getChr2((num + 100 * (bit + 1)) % 1296);
            sb.append(Digest.getChr(bit)).append(s);
        } else if (num < 46656) {
            sb.append(Digest.getChr(num / 1296)).append(Digest.getChr2(num % 1296));
        }
        return sb.length() > 0 ? sb.toString() : "---";
    }

    public static String getChr2(int num) {
        if (num < 100) {
            return String.format("%02d", num);
        }
        StringBuilder sb = new StringBuilder();
        if (num < 360) {
            sb.append(Digest.getChr(num / 10)).append(Digest.getChr(num % 10));
        } else if (num < 1296) {
            sb.append(Digest.getChr((num -= 360) / 26)).append(Digest.getChr(num % 26 + 10));
        }
        return sb.length() > 0 ? sb.toString() : "--";
    }

    public static char getChr(int num) {
        if (num < 10) {
            return (char)(num + 48);
        }
        return (char)(num < 36 ? num + 55 : 45);
    }

    public static String md5(String str) {
        return DigestUtils.md5Hex((String)str);
    }

    private static Cipher sm4Cipher(String key, int mode) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher sm4 = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            byte[] keyBytes = DigitUtil.hex2Bytes(key);
            sm4.init(mode, new SecretKeySpec(keyBytes, "SM4"));
            return sm4;
        }
        catch (Exception e) {
            throw new FailedException();
        }
    }

    public static String sm4Encrypt(String plainText, String salt) {
        try {
            Cipher cipher = Digest.sm4Cipher(salt, 1);
            byte[] bytes = plainText.getBytes(StandardCharsets.UTF_8);
            return DigitUtil.toHexStr(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            log.error("sm4Encrypt...{}", (Object)plainText);
            return null;
        }
    }

    public static String sm4Decrypt(String cipherText, String salt) {
        try {
            byte[] bytes = DigitUtil.hex2Bytes(cipherText);
            Cipher cipher = Digest.sm4Cipher(salt, 2);
            return new String(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            log.error("sm4Encrypt...{}", (Object)salt);
            return null;
        }
    }

    public static String genRawKey() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            sb.append(Integer.toHexString(rand.nextInt(16)));
        }
        return sb.toString();
    }

    public static String sm3(String src) {
        SM3Digest sm3 = new SM3Digest();
        byte[] data = src.getBytes(StandardCharsets.UTF_8);
        byte[] hash = new byte[sm3.getDigestSize()];
        sm3.update(data, 0, data.length);
        sm3.doFinal(hash, 0);
        return Hex.toHexString((byte[])hash);
    }

    public static String sm3(String src, String key) {
        HMac hMac = new HMac((org.bouncycastle.crypto.Digest)new SM3Digest());
        byte[] data = src.getBytes(StandardCharsets.UTF_8);
        byte[] hash = new byte[hMac.getMacSize()];
        hMac.init((CipherParameters)new KeyParameter(key.getBytes()));
        hMac.update(data, 0, data.length);
        hMac.doFinal(hash, 0);
        return Hex.toHexString((byte[])hash);
    }

    public static Map<String, String> genSm2Pair() {
        ECKeyPairGenerator kpg = new ECKeyPairGenerator();
        SecureRandom rand = new SecureRandom();
        kpg.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParams, rand));
        AsymmetricCipherKeyPair keyPair = kpg.generateKeyPair();
        ECPoint ecp = ((ECPublicKeyParameters)keyPair.getPublic()).getQ();
        BigInteger bi = ((ECPrivateKeyParameters)keyPair.getPrivate()).getD();
        HashMap<String, String> keysMap = new HashMap<String, String>();
        keysMap.put(PUB_KEY, Hex.toHexString((byte[])ecp.getEncoded(true)));
        keysMap.put(PRI_KEY, bi.toString(16));
        return keysMap;
    }

    public static String sm2Encrypt(String plainText, String pubKey) {
        byte[] data = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] pubK = Hex.decode((String)pubKey);
        ECPoint ecp = sm2p256v1.getCurve().decodePoint(pubK);
        ECPublicKeyParameters pk = new ECPublicKeyParameters(ecp, domainParams);
        SM2Engine sm2 = new SM2Engine(SM2Engine.Mode.C1C2C3);
        sm2.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pk));
        try {
            data = sm2.processBlock(data, 0, data.length);
            return Hex.toHexString((byte[])data);
        }
        catch (Exception e) {
            log.error("sm2Encrypt...{}", (Object)plainText);
            return null;
        }
    }

    public static String sm2Decrypt(String cipherText, String priKey) {
        byte[] data = Hex.decode((String)cipherText);
        BigInteger bi = new BigInteger(priKey, 16);
        ECPrivateKeyParameters pk = new ECPrivateKeyParameters(bi, domainParams);
        SM2Engine sm2 = new SM2Engine(SM2Engine.Mode.C1C2C3);
        sm2.init(false, (CipherParameters)pk);
        try {
            data = sm2.processBlock(data, 0, data.length);
            return new String(data);
        }
        catch (Exception e) {
            log.error("sm2Decrypt...{}", (Object)cipherText);
            return null;
        }
    }

    public static String nextSeq(String seqNo) {
        return Digest.enBase62(Digest.deBase62(seqNo) + 1L);
    }
}

