/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.FailedException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Captcha {
    private static Logger log = LoggerFactory.getLogger(Captcha.class);
    private static final String PNG = "png";
    private static final String EXT = ".png";
    private static int width;
    private static int height;
    static SecureRandom rand;

    public static List<String> imageCutout(File templateFile, File originFile, File blockFile) {
        ArrayList<String> imgList = new ArrayList<String>();
        try {
            BufferedImage templateImage = ImageIO.read(templateFile);
            width = templateImage.getWidth();
            height = templateImage.getHeight();
            BufferedImage bufImage = ImageIO.read(originFile);
            int oriW = bufImage.getWidth();
            int oriH = bufImage.getHeight();
            Point point = Captcha.randomPoint(oriW - width, oriH - height);
            Rectangle rec = new Rectangle(point.x, point.y, width, height);
            BufferedImage target = Captcha.cutTargetArea(originFile, rec);
            BufferedImage block = ImageIO.read(blockFile);
            Point pt = Captcha.getCutPoint(block, 3, 5);
            BufferedImage maskImg = Captcha.getMaskImage(target, block, pt);
            if (maskImg != null) {
                BufferedImage cutout = Captcha.cutoutByBlock(maskImg, block, pt);
                imgList.add(Captcha.imgEncode(Captcha.toByteArray(cutout)));
                imgList.add(Captcha.imgEncode(Captcha.toByteArray(maskImg)));
                imgList.add(String.valueOf(pt.y));
            }
        }
        catch (Exception e) {
            throw new FailedException("doFailed");
        }
        return imgList;
    }

    /*
     * Exception decompiling
     */
    private static BufferedImage cutTargetArea(File originFile, Rectangle rec) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Point getCutPoint(BufferedImage blockImage, int top, int left) {
        int x = width - blockImage.getWidth() - width / left;
        int y = height - blockImage.getHeight() - top;
        Point point = Captcha.randomPoint(x, y);
        x = point.x + width / left;
        y = point.y + top;
        return new Point(x, y);
    }

    private static BufferedImage cutoutByBlock(BufferedImage origin, BufferedImage block, Point p) {
        Graphics2D g2D = origin.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(10, 0.7f));
        g2D.drawImage(block, p.x, p.y, block.getWidth(), block.getHeight(), null);
        g2D.dispose();
        return origin;
    }

    public static BufferedImage getMaskImage(BufferedImage origin, BufferedImage block, Point p) {
        BufferedImage newImage = null;
        if (origin != null && block != null) {
            int w = block.getWidth();
            int h = block.getHeight();
            newImage = new BufferedImage(w, origin.getHeight(), origin.getType());
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    if (block.getRGB(i, j) >= 0) continue;
                    newImage.setRGB(i, p.y + j, origin.getRGB(p.x + i, p.y + j));
                }
            }
        }
        return newImage;
    }

    public static void setWaterMark(BufferedImage origin, BufferedImage block, int x, int y, int alpha) {
        for (int i = 0; i < block.getWidth(); ++i) {
            for (int j = 0; j < block.getHeight(); ++j) {
                if (block.getRGB(i, j) >= 0) continue;
                Color color = new Color(origin.getRGB(x + i, y + j));
                Color newC = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
                origin.setRGB(x + i, y + j, newC.getRGB());
            }
        }
    }

    public static String imgEncode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        String base64 = encoder.encodeToString(bytes);
        return "data:image/png;base64," + base64;
    }

    public static byte[] imgDecode(String base64Str) {
        Base64.Decoder decoder = Base64.getDecoder();
        String[] arr = base64Str.split(",");
        base64Str = arr.length == 1 ? arr[0] : arr[1];
        return decoder.decode(base64Str);
    }

    public static BufferedImage toImage(String base64) {
        Base64.Decoder decoder = Base64.getMimeDecoder();
        try {
            String[] arr = base64.split(",");
            byte[] bytes = decoder.decode(arr[1]);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return ImageIO.read(bais);
        }
        catch (Exception e) {
            log.error("toImage...{}", (Object)e.getMessage());
            return null;
        }
    }

    public static Point randomPoint(int widthDiff, int heightDiff) {
        int x = widthDiff <= 0 ? 0 : rand.nextInt(widthDiff);
        int y = heightDiff <= 0 ? 0 : rand.nextInt(heightDiff);
        return new Point(x, y);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] toByteArray(BufferedImage bufImg) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufImg, PNG, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new FailedException("doFailed");
        }
    }

    public static int getBlockShift(String shadeStr, String blockStr, int y) {
        return Captcha.getBlockShift(Captcha.toImage(shadeStr), Captcha.toImage(blockStr), y);
    }

    public static int getBlockShift(BufferedImage shade, BufferedImage block, int y) {
        List<Point> points = Captcha.getBlockSide(block);
        int w = shade.getWidth() - block.getWidth();
        int left = 0;
        int offset = 0;
        for (int x = 1; x < w; ++x) {
            int i = 0;
            for (Point p : points) {
                if (!Captcha.alphaDiff(shade, x + p.x, y + p.y)) continue;
                ++i;
            }
            if (left >= i) continue;
            left = i;
            offset = x;
        }
        return offset;
    }

    public static int getBlockShift(String shadeStr, String blockStr, int y, int diff) {
        return Captcha.getBlockShift(Captcha.toImage(shadeStr), Captcha.toImage(blockStr), y, diff);
    }

    public static int getBlockShift(BufferedImage shade, BufferedImage block, int y, int diff) {
        List<Point> points = Captcha.getBlockSide(block);
        int pixel = shade.getWidth() - block.getWidth();
        int left = 0;
        int offset = 0;
        for (int x = 1; x < pixel; ++x) {
            int i = 0;
            for (Point p : points) {
                if (!Captcha.colorDiff(shade, x + p.x, y + p.y, diff)) continue;
                ++i;
            }
            if (left >= i) continue;
            left = i;
            offset = x;
        }
        return offset;
    }

    private static List<Point> getBlockSide(BufferedImage block) {
        ArrayList<Point> list = new ArrayList<Point>();
        block0: for (int y = 0; y < block.getHeight(); ++y) {
            for (int x = 0; x < block.getWidth(); ++x) {
                if (block.getRGB(x, y) >= 0) continue;
                list.add(new Point(x, y));
                continue block0;
            }
        }
        return list;
    }

    private static boolean colorDiff(BufferedImage shade, int x, int y, int d) {
        try {
            Color c0 = new Color(shade.getRGB(x, y));
            Color c1 = new Color(shade.getRGB(x - 1, y - 1));
            Color c2 = new Color(shade.getRGB(x + 1, y + 1));
            if (Math.abs(c1.getRed() - c0.getRed()) > d || Math.abs(c1.getGreen() - c0.getGreen()) > d || Math.abs(c1.getBlue() - c0.getBlue()) > d || Math.abs(c2.getRed() - c0.getRed()) > d || Math.abs(c2.getGreen() - c0.getGreen()) > d || Math.abs(c2.getBlue() - c0.getBlue()) > d) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("colorDiff...{}", (Object)e.getMessage());
        }
        return false;
    }

    private static boolean alphaDiff(BufferedImage shade, int x, int y) {
        int diff = 0;
        try {
            Color c0 = new Color(shade.getRGB(x, y), true);
            Color c1 = new Color(shade.getRGB(x - 1, y - 1), true);
            Color c2 = new Color(shade.getRGB(x + 1, y + 1), true);
            diff = Math.abs(c1.getAlpha() - c0.getAlpha());
            diff += Math.abs(c2.getAlpha() - c0.getAlpha());
        }
        catch (Exception e) {
            log.error("alphaDiff...{}", (Object)e.getMessage());
        }
        return diff > 0;
    }

    public static void main(String[] args) {
        try {
            log.debug("sucess!");
        }
        catch (Exception e) {
            log.error("test...{}", (Object)e.getMessage());
        }
    }

    public static void saveToFile(BufferedImage bufImg, String name) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufImg, PNG, os);
            os.writeTo(new FileOutputStream(Captcha.randFileName(name)));
        }
        catch (Exception e) {
            log.error("saveToFile...{}", (Object)e.getMessage());
        }
    }

    public static void saveToFile(byte[] bytes, String name) {
        File file = new File(Captcha.randFileName(name));
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(bytes);
        }
        catch (Exception e) {
            throw new FailedException("doFailed");
        }
    }

    private static String randFileName(String name) {
        return name + System.currentTimeMillis() + EXT;
    }

    static {
        rand = new SecureRandom();
    }
}

