/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.FmtUtil;
import cn.ps1.aolai.utils.SpringContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfUtil {
    private static Logger log = LoggerFactory.getLogger(ConfUtil.class);
    private static ResourceBundle confBundle = ResourceBundle.getBundle("config");
    private static ResourceBundle paramBundle = ResourceBundle.getBundle("params");
    private static ResourceBundle validBundle = ResourceBundle.getBundle("valid");
    private static Map<String, String> gCONF = new HashMap<String, String>();
    public static final String JSONSTR = "jsonstr";
    public static final String APPCODE = "appCode";
    public static final String IPADDR = "ipaddr";
    public static final String TICKET = "ticket";
    public static final String TOKEN = "token";
    public static final String CERT_K = "k";
    public static final String COMMA = ",|;";
    public static final String TRACEID = "traceId";
    public static final String CERTID = "certId";
    public static final String COMPID = "compId";
    public static final String USERID = "userId";
    public static final String INVD_PARAMS = "invalidParams";
    public static final String CANT_REMOVE = "cantRemove";
    public static final String CANT_UPDATE = "cantUpdate";
    public static final String OVER_COUNTS = "overCounts";
    public static final String OVER_LENGTH = "overLength";
    public static final String DENY_ACCESS = "denyAccess";
    public static final String DUPL_NAME = "duplicateName";
    public static final String DUPL_DATA = "dataDuplicate";
    public static final String DATA_COLL = "dataCollision";
    public static final String NOT_FOUND = "noDataFound";
    public static final String DATA_USED = "dataInUse";
    public static final String RUN_FAILED = "doFailed";
    public static final String IS_ROLLBACK = "isRollback";
    private static boolean usingGconf = false;
    private static String appKEY = "www.ps1.cn";
    private static String appSIGN = "";
    private static String appCORE = "";
    private static String appMAIN = "/main";
    private static String[] appSPEC = new String[0];
    private static String baseDBID = "";
    private static String baseDOT = ".";
    private static String baseNAME = "";
    private static String baseMAIN = "";
    private static String[] i18nLOCALES = new String[]{"ZH", "EN"};
    private static String ssoURL = "";
    private static boolean validMUST = false;
    private static String limitROWS = "2999";
    private static int httpTIMEOUT = 120000;
    private static int cacheTIME = 3600;
    private static int codeEXPIRED = 600;
    private static boolean apiPERMIT = false;
    private static boolean isTRACKING = false;
    private static boolean isApiOPEN = false;
    private static boolean isEncRESP = false;
    private static boolean isLogRESP = false;
    private static boolean isEncOMIT = false;
    private static int isLogARGS = 0;
    private static boolean isMultiLOGIN = false;
    private static boolean isCustomMETA = false;
    private static boolean avoidRULES = false;
    private static int tryTIMES = 2;
    private static String sqlVTEXT = "'(%|\\^)?[\\w+ \u4e00-\u9fa5]*(%|\\$)?'";
    public static final String[] SQL_EXPR = new String[]{"=", "!=", ">", "<", ">=", "<=", "<>", "or", "like", "in", "(", ")", "is", "not", "null", "and", "between", "json_extract(", "length(", "rlike", "regexp"};
    private static List<String> sqlEXPR = new ArrayList<String>();
    private static Map<String, String> metas = new HashMap<String, String>();
    public static final String OP_LIKE = "A";
    public static final String OP_EQU = "C";
    public static final String OP_NEQ = "D";
    public static final String OP_SW = "E";
    public static final String OP_EW = "F";
    public static final String OP_MT = "G";
    public static final String OP_LT = "H";
    public static final String OP_ME = "I";
    public static final String OP_LE = "J";
    public static final String OP_NUL = "K";
    public static final String OP_NON = "L";
    public static final String OP_IN = "M";
    public static final String OP_BTWN = "N";
    private static Map<String, String> opKey;
    private static Map<String, String> opVal;

    private ConfUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String appKey() {
        return appKEY;
    }

    public static String appSign() {
        return appSIGN;
    }

    public static String appCore() {
        return appCORE;
    }

    public static String appMain() {
        return appMAIN;
    }

    public static String[] appSpec() {
        return appSPEC;
    }

    public static String dbid() {
        return baseDBID;
    }

    public static String baseDot() {
        return baseDOT;
    }

    public static String baseName() {
        return baseNAME;
    }

    public static String baseMain() {
        return baseMAIN;
    }

    public static String[] locales() {
        return i18nLOCALES;
    }

    public static String ssoUrl() {
        return ssoURL;
    }

    public static boolean mustValid() {
        return validMUST;
    }

    public static String limitRows() {
        return limitROWS;
    }

    public static int httpTimeout() {
        return httpTIMEOUT;
    }

    public static int cacheTime() {
        return cacheTIME;
    }

    public static int vcodeDue() {
        return codeEXPIRED;
    }

    public static boolean apiPermit() {
        return apiPERMIT;
    }

    public static boolean isTracking() {
        return isTRACKING;
    }

    public static boolean isApiOpen() {
        return isApiOPEN;
    }

    public static boolean isEncResp() {
        return isEncRESP;
    }

    public static boolean isLogResp() {
        return isLogRESP;
    }

    public static boolean isEncOmit() {
        return isEncOMIT;
    }

    public static int logArgs() {
        return isLogARGS;
    }

    public static boolean isMultLogin() {
        return isMultiLOGIN;
    }

    public static boolean isCustomMeta() {
        return isCustomMETA;
    }

    public static boolean avoidRules() {
        return avoidRULES;
    }

    public static int tryTimes() {
        return tryTIMES;
    }

    public static String sqlVText() {
        return sqlVTEXT;
    }

    private static void setSqlEXPR(String expr) {
        if (expr.length() == 0) {
            expr = "=,!=,>,<,>=,<=,<>,or,like,in,(,),is,not,null,and,between,json_extract(,length(,rlike,regexp";
        }
        sqlEXPR = Arrays.asList(expr.split(","));
    }

    public static boolean isSqlExpr(String key) {
        return key.length() == 0 || sqlEXPR.contains(key.toLowerCase());
    }

    public static Map<String, String> gMETAS() {
        return metas;
    }

    private static void initGmeta(Object res) {
        Map params = ConfUtil.obj2Map(res);
        metas = params.isEmpty() ? metas : params;
        log.info("^_^");
    }

    public static void initAppGconf() {
        for (String key : confBundle.keySet()) {
            gCONF.put(key, ConfUtil.getProp(key, ""));
        }
        String initCnf = ConfUtil.getProp("app.gconf", "");
        boolean bl = usingGconf = !"".equals(initCnf);
        if (usingGconf) {
            Map cnfMap = ConfUtil.obj2Map(ConfUtil.invoke(null, "appGconfOne", initCnf));
            if (cnfMap.isEmpty()) {
                log.error("initAppGconf...GCONF is null");
                return;
            }
            gCONF = cnfMap;
        }
        ConfUtil.loadGconf();
        log.info("> initAppGconf()...{}", gCONF);
        ConfUtil.initGmeta(ConfUtil.invoke(null, "appGmetaOne", ""));
    }

    private static void loadGconf() {
        appKEY = ConfUtil.getConf("app.key", appKEY);
        appSIGN = ConfUtil.getConf("app.code", appSIGN);
        appCORE = ConfUtil.getConf("app.core", appCORE);
        appMAIN = ConfUtil.getConf("app.main", appMAIN);
        appSPEC = ConfUtil.getConf("app.spec", "").split(":");
        baseDBID = ConfUtil.getConf("base.dbid", baseDBID);
        baseDOT = ConfUtil.getConf("base.dot", ".");
        baseNAME = ConfUtil.getConf("base.name", "");
        baseMAIN = ConfUtil.getConf("base.main", "");
        i18nLOCALES = ConfUtil.getConf("i18n.locales", "ZH,EN").split(COMMA);
        ssoURL = ConfUtil.getConf("sso.url", "");
        validMUST = ConfUtil.getConf("valid.must", "").length() > 0;
        limitROWS = ConfUtil.getConf("limit.rows", limitROWS);
        httpTIMEOUT = ConfUtil.getInt("http.timeout", 90000);
        cacheTIME = ConfUtil.getInt("cache.time", cacheTIME);
        codeEXPIRED = ConfUtil.getInt("code.expired", codeEXPIRED);
        apiPERMIT = ConfUtil.getConf("api.permit", "").length() > 0;
        isTRACKING = ConfUtil.getConf("app.trace", "").length() > 0;
        isApiOPEN = ConfUtil.getConf("api.open", "").length() > 0;
        isEncRESP = ConfUtil.getConf("enc.resp", "").length() > 0;
        isLogRESP = ConfUtil.getConf("log.resp", "").length() > 0;
        isEncOMIT = ConfUtil.getConf("enc.omit", "").length() > 0;
        isLogARGS = Integer.parseInt(ConfUtil.getConf("log.args", "0"));
        isMultiLOGIN = ConfUtil.getConf("multi.login", "").length() > 0;
        isCustomMETA = ConfUtil.getConf("meta.custom", "").length() > 0;
        avoidRULES = ConfUtil.getConf("avoid.rules", "").length() > 0;
        tryTIMES = ConfUtil.getInt("try.times", tryTIMES);
        sqlVTEXT = ConfUtil.getConf("sql.vtext", sqlVTEXT);
        ConfUtil.setSqlEXPR(ConfUtil.getConf("sql.expr", ""));
    }

    public static String getConf(String key, String def) {
        String val = gCONF.get(key);
        return val == null || "".equals(val) ? def : val;
    }

    public static String getConf(String key) {
        return ConfUtil.getConf(key, "");
    }

    public static int getInt(String key, int def) {
        log.debug("getInt...{}", (Object)key);
        String val = gCONF.get(key);
        return val == null ? def : FmtUtil.getInt(val, def);
    }

    public static boolean dataIsolation() {
        return "0".equals(ConfUtil.baseDot());
    }

    public static Object invoke(Object bean, String method, Object args) {
        try {
            if (bean == null) {
                bean = SpringContext.getBean("gconfService");
            }
            Method m = bean.getClass().getMethod(method, Object.class);
            return m.invoke(bean, args);
        }
        catch (Exception e) {
            log.error("invoke....{}({})", (Object)method, args);
            return null;
        }
    }

    public static String get(String key, String def) {
        return ConfUtil.getConf(key, def);
    }

    public static String getParam(String key) {
        return ConfUtil.getProp(paramBundle, key, "");
    }

    public static String getValid(String key) {
        return ConfUtil.getProp(validBundle, key, "");
    }

    private static String getProp(ResourceBundle rb, String key, String def) {
        try {
            return rb.getString(key);
        }
        catch (Exception e) {
            log.debug("getPropKey...{}", (Object)e.getMessage());
            return def;
        }
    }

    private static String getProp(String key, String def) {
        return ConfUtil.getProp(confBundle, key, def);
    }

    public static <T> Map<String, T> obj2Map(Object obj) {
        return obj instanceof Map ? (Map)obj : new HashMap();
    }

    public static <T> List<T> obj2List(Object obj) {
        return obj instanceof Collection ? (List)obj : new ArrayList();
    }

    static String getOpVal(Object key, String val) {
        if (opVal.containsKey(key)) {
            if (FmtUtil.isValidWord(val)) {
                return opVal.get(key).replaceAll("\\{\\}", val);
            }
            if ("".equals(val)) {
                return opVal.get(key);
            }
        }
        throw new FailedException();
    }

    public static String getOpr(Object key) {
        return opKey.get(key);
    }

    public static Object opExpr(Object key, Object obj) {
        List valList = ConfUtil.obj2List(obj);
        if (valList.size() > 1) {
            return obj;
        }
        if (!valList.isEmpty()) {
            return ConfUtil.getOpVal(key, (String)valList.get(0));
        }
        if (obj instanceof CharSequence) {
            return ConfUtil.getOpVal(key, (String)obj);
        }
        throw new FailedException();
    }

    static {
        metas.put("table", "META_TABLE");
        metas.put("field", "META_FIELD");
        metas.put("alias", "META_ALIAS");
        metas.put("type", "META_TYPE");
        metas.put("name", "META_NAME");
        metas.put("null", "META_NULL");
        metas.put("lang", "META_I18N");
        metas.put("pkey", "META_PKEY");
        metas.put("sort", "META_SORT");
        metas.put("default", "META_DEFAULT");
        opKey = new HashMap<String, String>();
        opKey.put(OP_LIKE, "like");
        opKey.put("B", "not like");
        opKey.put(OP_EQU, "=");
        opKey.put(OP_NEQ, "!=");
        opKey.put(OP_SW, "like");
        opKey.put(OP_EW, "like");
        opKey.put(OP_MT, ">");
        opKey.put(OP_LT, "<");
        opKey.put(OP_ME, ">=");
        opKey.put(OP_LE, "<=");
        opKey.put(OP_NUL, "=");
        opKey.put(OP_NON, "!=");
        opKey.put(OP_IN, "in");
        opKey.put(OP_BTWN, "between {0} and {1}");
        opVal = new HashMap<String, String>();
        opVal.put(OP_LIKE, "%{}%");
        opVal.put("B", "%{}%");
        opVal.put(OP_EQU, "{}");
        opVal.put(OP_NEQ, "{}");
        opVal.put(OP_SW, "{}%");
        opVal.put(OP_EW, "%{}");
        opVal.put(OP_MT, "{}");
        opVal.put(OP_LT, "{}");
        opVal.put(OP_ME, "{}");
        opVal.put(OP_LE, "{}");
        opVal.put(OP_NUL, "");
        opVal.put(OP_NON, "");
        opVal.put(OP_IN, "({})");
        opVal.put(OP_BTWN, "{0} and {1}");
    }
}

