/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.FmtUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UtilsService {
    private static Logger log = LoggerFactory.getLogger(UtilsService.class);
    private static ObjectMapper objMapper = new ObjectMapper();
    @Autowired
    HttpServletRequest req;

    public void doFailed() {
        throw new FailedException("doFailed");
    }

    public Map<String, Object> jsonParams() {
        return this.jsonParams(this.req);
    }

    public Map<String, Object> jsonParams(HttpServletRequest req) {
        try {
            return this.obj2Map(req.getAttribute("json"));
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Object> jsonParams(String[] keys) {
        Map<String, Object> params = this.jsonParams();
        for (String key : keys) {
            if (params.containsKey(key)) continue;
            throw new FailedException(null, key);
        }
        return params;
    }

    public boolean availParams(Map<?, ?> map, String[] keys) {
        if (map == null) {
            return false;
        }
        for (String key : keys) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> invalidParams() {
        return this.result("2");
    }

    public Map<String, String> userSelf() {
        return this.obj2Map(this.req.getAttribute("user"));
    }

    public Map<String, String> userSelf(HttpServletRequest req) {
        return this.obj2Map(req.getAttribute("user"));
    }

    public String setUserComp(Map<String, Object> params, String key) {
        return this.setUserComp(this.req, params, key);
    }

    public String setUserComp(HttpServletRequest req, Map<String, Object> params, String key) {
        String userComp = this.userSelf(req).get("userComp");
        params.put(key, userComp);
        return userComp;
    }

    public void cleanState(Map<String, Object> cond, String key) {
        Object state = cond.get(key);
        if (!"0".equals(state) && !"1".equals(state)) {
            cond.remove(key);
        }
    }

    public void resetState(Map<String, Object> cond, String key) {
        Object state = cond.get(key);
        if ("all".equals(state)) {
            cond.put(FmtUtil.pHolder(key, "!="), "9");
            cond.remove(key);
        } else {
            cond.put(key, state == null ? "1" : "0");
        }
    }

    public String idCode(Object pId, int id, int bitW) {
        String pid = this.isNil(pId) ? "" : String.valueOf(pId);
        String maxId = String.valueOf(id);
        if (maxId.length() > bitW) {
            return pid + maxId.substring(maxId.length() - bitW);
        }
        String fmt = "%0" + bitW + "d";
        return pid + String.format(fmt, id);
    }

    public Map<String, Object> sameIf(Map<String, ?> cond, String[] keys) {
        Map<String, Object> where = this.sameIf(cond, 1, keys);
        if (cond.containsKey(keys[0])) {
            where.put(this.pHolder(keys[0], "!="), cond.get(keys[0]));
        }
        return where;
    }

    public Map<String, Object> sameIf(Map<String, ?> cond, int offset, String[] keys) {
        Map<String, Object> where = this.newCond(cond);
        for (int i = offset; i < keys.length; ++i) {
            where.put(keys[i], cond.get(keys[i]));
        }
        return where;
    }

    public <T> Map<String, T> newMap(Map<String, T> params, String key) {
        return this.newMap(params, new String[]{key});
    }

    public <T> Map<String, T> newMap(Map<String, T> params, String[] keys) {
        HashMap<String, T> cond = new HashMap<String, T>();
        for (String key : keys) {
            if (!params.containsKey(key)) continue;
            cond.put(key, params.get(key));
        }
        return cond;
    }

    public Map<String, Object> newCond(Map<String, ?> params) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("i18n", params.get("i18n"));
        if (ConfUtil.dbid().length() > 0) {
            cond.put(ConfUtil.dbid(), params.get(ConfUtil.dbid()));
        }
        cond.put("base", params.get("base"));
        return cond;
    }

    public Map<String, Object> pageCond(Map<String, Object> params) {
        String[] keys = new String[]{"pageNo", "pageSize"};
        return this.newMap(params, keys);
    }

    public Map<String, Map<String, String>> joinCond(String table) {
        LinkedHashMap<String, Map<String, String>> tables = new LinkedHashMap<String, Map<String, String>>();
        tables.put(table, null);
        return tables;
    }

    public Map<String, String> getSort(Map<String, Object> where) {
        Object sort = where.get("sort");
        return sort == null ? null : this.obj2Map(sort);
    }

    public Map<String, Object> sameId(Map<String, ?> cond, String key) {
        return this.sameIf(cond, 0, new String[]{this.setComp(key), key + "Id"});
    }

    public Map<String, Object> sameNo(Map<String, ?> cond, String key) {
        return this.sameIf(cond, 0, new String[]{this.setComp(key), key + "No"});
    }

    private String setComp(String key) {
        return key + "Comp";
    }

    public int[] num2Arr(String numStr) {
        int[] num = this.str2num(numStr);
        for (int i = 1; i < num.length; ++i) {
            int n = i;
            num[n] = num[n] + num[i - 1];
        }
        return num;
    }

    public int[] str2num(String numStr) {
        if (!this.isInteger(numStr)) {
            return new int[0];
        }
        int[] num = new int[numStr.length()];
        for (int i = 0; i < numStr.length(); ++i) {
            num[i] = Integer.parseInt(numStr.substring(i, i + 1));
        }
        return num;
    }

    @Deprecated
    public <T> String arr2Str(T[] strArr) {
        return this.join(strArr, "");
    }

    public <T> String join(T[] strArr) {
        return this.join(strArr, "");
    }

    public <T> String join(T[] strArr, String joint) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strArr.length; ++i) {
            sb.append((Object)(i > 0 ? joint + strArr[i] : strArr[i]));
        }
        return sb.toString();
    }

    public int getInt(Map<String, ?> map, String key) {
        String val;
        if (map != null && this.isInteger(val = String.valueOf(map.get(key)))) {
            return Integer.parseInt(val);
        }
        return 0;
    }

    public long getLong(Map<String, ?> map, String key) {
        String val;
        if (map != null && this.isInteger(val = String.valueOf(map.get(key)))) {
            return Long.parseLong(val);
        }
        return 0L;
    }

    public String initCap(Object str) {
        char[] cs = String.valueOf(str).toLowerCase().toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public Map<String, Object> map2Obj(Map<String, ?> map) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, ?> e : map.entrySet()) {
                obj.put(e.getKey(), e.getValue());
            }
        }
        return obj;
    }

    public <T> List<Map<String, T>> parse(Map<String, ?> parser, List<Map<String, T>> list) {
        if (!this.isEmpty(parser)) {
            for (int i = 0; i < list.size() && !list.get(i).isEmpty(); ++i) {
                list.set(i, this.parse(parser, list.get(i)));
            }
        }
        return list;
    }

    public <T> Map<String, T> parse(Map<String, ?> parser, Map<String, T> map) {
        if (this.isEmpty(parser)) {
            return map;
        }
        HashMap<String, T> item = new HashMap<String, T>();
        for (Map.Entry<String, ?> e : parser.entrySet()) {
            if (!map.containsKey(e.getValue())) continue;
            item.put(e.getKey(), map.get(e.getValue()));
        }
        return item;
    }

    @Deprecated
    public <T> Map<String, T> mapParser(Map<String, ?> parser, Map<String, T> map) {
        return this.parse(parser, map);
    }

    @Deprecated
    public <T> List<Map<String, T>> mapParser(Map<String, ?> parser, List<Map<String, T>> list) {
        return this.parse(parser, list);
    }

    public <T> Map<String, T> obj2Map(Object obj) {
        return obj instanceof Map ? (Map)obj : new HashMap();
    }

    public <T> List<T> obj2List(Object obj) {
        return obj instanceof Collection ? (List)obj : new ArrayList();
    }

    public Map<String, String> obj2Map(Map<String, ?> obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (obj != null) {
            for (Map.Entry<String, ?> e : obj.entrySet()) {
                Object val = e.getValue();
                map.put(e.getKey(), val == null ? null : String.valueOf(val));
            }
        }
        return map;
    }

    public String obj2Str(Object obj) {
        try {
            return objMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("obj2Str...{}", (Object)e.getMessage());
            return null;
        }
    }

    public Map<String, Object> node2Obj(String jsonStr, String path) {
        try {
            if (jsonStr != null) {
                JsonNode node = objMapper.readTree(jsonStr);
                return this.node2Obj(path == null ? node : node.path(path));
            }
        }
        catch (Exception e) {
            this.error("node2Obj", jsonStr);
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> node2Obj(String jsonStr) {
        return this.node2Obj(jsonStr, null);
    }

    public Map<String, Object> node2Obj(JsonNode jsonNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jsonNode.isValueNode()) {
            map.put("", jsonNode.asText());
        } else if (jsonNode.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator it = jsonNode.iterator();
            while (it.hasNext()) {
                Map<String, Object> child = this.node2Obj((JsonNode)it.next());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    list.add(child.get(""));
                    continue;
                }
                list.add(child);
            }
            map.put("", list);
        } else {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entity = (Map.Entry)it.next();
                Map<String, Object> child = this.node2Obj((JsonNode)entity.getValue());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    map.put((String)entity.getKey(), child.get(""));
                    continue;
                }
                map.put((String)entity.getKey(), child);
            }
        }
        return map;
    }

    void error(String method, String str) {
        str = str.length() < 200 ? str : str.substring(0, 200) + "...";
        log.error("{}...'{}'", (Object)method, (Object)str);
    }

    public String sqlOr(String field0, String field1) {
        return this.sqlOr(new String[]{field0, field1});
    }

    public String sqlOr(String[] fields) {
        StringJoiner s = new StringJoiner(" or ", "(", ")");
        for (String field : fields) {
            s.add(this.pHolder(field, "={}"));
        }
        return s.toString();
    }

    public String sqlVal(Object val) {
        return FmtUtil.quote(val, "'");
    }

    public String jsonExt(String field, Object key) {
        return this.jsonExt(field, key, "=");
    }

    public String jsonExt(String field, Object key, String opr) {
        String[] keys = new String[]{" json_extract({", field, "},'$."};
        return this.join(keys) + key + "') " + opr;
    }

    public <T> Map<String, T> json2Map(Object str) {
        try {
            return (Map)objMapper.readValue((String)str, new TypeRef());
        }
        catch (Exception e) {
            log.warn("json2Map...{}", (Object)e.getMessage());
            return new HashMap();
        }
    }

    public <T> List<T> json2List(Object str) {
        try {
            return (List)objMapper.readValue((String)str, new TypeRef());
        }
        catch (Exception e) {
            log.warn("json2List...{}", (Object)e.getMessage());
            return new ArrayList();
        }
    }

    public <T> String[] getArr(List<Map<String, T>> list, String key) {
        String[] arr = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (String)list.get(i).get(key);
        }
        return arr;
    }

    public <T> Set<String> toSet(List<Map<String, T>> list, String key) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            set.add((String)list.get(i).get(key));
        }
        return set;
    }

    String[] toArr(Object obj) {
        ArrayList<String> valList = new ArrayList<String>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                String s = String.valueOf(o);
                valList.add(this.isMatch(s, "'.*'") ? s : this.sqlVal(s));
            }
        } else if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                valList.add(this.sqlVal(o));
            }
        } else {
            valList.add(this.sqlVal(obj));
        }
        return valList.toArray(new String[0]);
    }

    public <T> Map<String, Map<String, T>> toMap(List<Map<String, T>> list, String key) {
        return this.list2Map(list, key);
    }

    public Map<String, String> toMap(List<Map<String, String>> list, String key, String val) {
        return this.list2Map(list, key, val);
    }

    public <T> Map<String, Map<String, T>> list2Map(List<Map<String, T>> list, String key) {
        HashMap<String, Map<String, T>> map = new HashMap<String, Map<String, T>>();
        if (list != null) {
            for (Map<String, T> item : list) {
                map.put((String)item.get(key), item);
            }
        }
        return map;
    }

    public Map<String, String> list2Map(List<Map<String, String>> list, String key, String val) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list != null) {
            for (Map<String, String> item : list) {
                map.put(item.get(key), item.get(val));
            }
        }
        return map;
    }

    public Map<String, String> result(String status) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", status);
        return result;
    }

    public Map<String, String> result(boolean status) {
        return this.result(status ? "1" : "0");
    }

    public Map<String, String> result(String status, String info) {
        Map<String, String> result = this.result(status);
        if (info != null) {
            result.put("info", info);
        }
        return result;
    }

    public <T> Object result(Map<String, T> map) {
        return map.containsKey("status") ? map : this.success(map);
    }

    public Map<String, String> failed(String info) {
        return this.result("0", info);
    }

    public <T> boolean isFailed(Map<String, T> result) {
        return this.isNil(result.get("status"));
    }

    public <T> boolean isSuccess(Map<String, T> result) {
        return "1".equals(result.get("status"));
    }

    public Map<String, String> success(String info) {
        return this.result("1", info);
    }

    public Map<String, String> success() {
        return this.result("1");
    }

    public Map<String, Object> success(Object obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "1");
        result.put("info", obj);
        return result;
    }

    @Deprecated
    public Map<String, String> success(Object obj, HttpServletRequest req) {
        String cert = (String)req.getAttribute("certId");
        return this.success(Digest.decrypt(this.obj2Str(obj), cert));
    }

    public <T> Map<String, T> findIn(List<Map<String, T>> list, String key, String val) {
        if (list != null && val != null) {
            for (Map<String, T> map : list) {
                if (!val.equals(map.get(key))) continue;
                return map;
            }
        }
        return null;
    }

    public boolean findIn(List<String> list, Object str) {
        return list != null && list.contains(str);
    }

    public boolean findIn(String[] arr, Object str) {
        return arr != null && Arrays.asList(arr).contains(str);
    }

    public boolean isNil(Object obj) {
        return "0".equals(obj);
    }

    public boolean isBlank(Object obj) {
        return "".equals(obj);
    }

    public boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public <T> boolean isEmpty(Map<String, T> map) {
        return map == null || map.isEmpty();
    }

    public boolean isMatch(String str, String regex) {
        return FmtUtil.isMatch(str, regex);
    }

    public boolean isInteger(String str) {
        return FmtUtil.isInteger(str);
    }

    public boolean isNumeric(String str) {
        return FmtUtil.isNumeric(str);
    }

    public boolean isIdcard(String str) {
        return this.isMatch(str, "\\d{17}[\\dXx]");
    }

    public boolean isMobile(String str) {
        return this.isMatch(str, "1[3-9]\\d{9}");
    }

    public boolean isDatetime(String dateStr, String pat) {
        try {
            if (dateStr != null) {
                new SimpleDateFormat(pat).parse(dateStr);
                return true;
            }
        }
        catch (ParseException e) {
            this.error("isDatetime", dateStr);
        }
        return false;
    }

    public String timeFormat(String str, String pat0, String pat1) {
        return FmtUtil.timeParse(str, pat0, pat1);
    }

    public long timeDiff(Date begin, Date end) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        long msec = cal.getTimeInMillis();
        cal.setTime(begin);
        return msec - cal.getTimeInMillis();
    }

    public long timeDiff(String begin, String end) {
        return this.diffMsec(begin, end, "yyyy-MM-dd HH:mm:ss");
    }

    public long diffMsec(String begin, String end) {
        return this.diffMsec(begin, end, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    private long diffMsec(String begin, String end, String pat) {
        try {
            if (!this.isEmpty(begin)) {
                SimpleDateFormat sdf = new SimpleDateFormat(pat);
                Date endDate = end == null ? new Date() : sdf.parse(end);
                return this.timeDiff(sdf.parse(begin), endDate);
            }
        }
        catch (ParseException e) {
            log.error("obj2Str...{}", (Object)e.getMessage());
        }
        return 0L;
    }

    public String today(String pattern) {
        return FmtUtil.timeParse(Calendar.getInstance(), pattern);
    }

    public String daysLater(int d) {
        LocalDate day = LocalDate.now().plusDays(d);
        return day.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public String nextDate(String date, int d) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate day = LocalDate.parse(date, dtf).plusDays(d);
        return day.format(dtf);
    }

    public String nextYear(String pattern, int y) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, y);
        return FmtUtil.timeParse(cal, pattern);
    }

    public String nextMonth(String month, int m) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Calendar cal = Calendar.getInstance();
        try {
            month = this.isEmpty(month) ? this.today("yyyyMM") : month;
            cal.setTime(sdf.parse(month));
        }
        catch (ParseException e) {
            this.error("nextMonth", month);
        }
        cal.add(2, m);
        return sdf.format(cal.getTime());
    }

    public String nextMonth(String month) {
        return this.nextMonth(month, 1);
    }

    public String prevMonth(String month, int m) {
        return this.nextMonth(month, -m);
    }

    public String prevMonth(String month) {
        return this.nextMonth(month, -1);
    }

    private String[] getHost(String uri) {
        int idx = uri.indexOf("://");
        uri = idx > 0 ? uri.substring(idx + 3) : uri;
        idx = uri.indexOf(47);
        uri = idx > 0 ? uri.substring(0, idx) : uri;
        return uri.split(":");
    }

    public String getRequestURI(HttpServletRequest req) {
        String uri = req.getServletPath();
        return uri.substring(uri.lastIndexOf(47) + 1);
    }

    private String getDomain(HttpServletRequest req) {
        String ref = req.getHeader("Referer");
        if (this.isEmpty(ref)) {
            ref = req.getRequestURL().toString();
        }
        log.debug("getDomain...{}", (Object)ref);
        String host = this.getHost(ref)[0];
        String[] arr = host.split("\\.");
        return arr.length == 3 ? arr[1] + "." + arr[2] : host;
    }

    public void setCookies(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> map) {
        if (!this.isEmpty(map)) {
            String domain = this.getDomain(req);
            for (Map.Entry<String, String> e : map.entrySet()) {
                String k = e.getKey();
                if (k.equals("certId")) continue;
                Cookie c = new Cookie(k, Digest.urlEncode(e.getValue()));
                c.setHttpOnly(true);
                this.setCookiePath(c, domain);
                rsp.addCookie(c);
            }
        }
    }

    public Map<String, String> getCookies(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                map.put(c.getName(), Digest.urlDecode(c.getValue()));
            }
        }
        return map;
    }

    public String getCookie(HttpServletRequest req, String key) {
        return this.getCookies(req).get(key);
    }

    @Deprecated
    public void delCookie(HttpServletRequest req, HttpServletResponse rsp, String key) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                this.setCookiePath(c, this.getDomain(req));
                c.setMaxAge(0);
                rsp.addCookie(c);
                break;
            }
        }
    }

    public void clearCookies(HttpServletRequest req, HttpServletResponse rsp) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            String domain = this.getDomain(req);
            for (Cookie c : cookies) {
                this.setCookiePath(c, domain);
                c.setMaxAge(0);
                rsp.addCookie(c);
            }
        }
    }

    private void setCookiePath(Cookie c, String domain) {
        c.setDomain(domain);
        c.setPath("/");
    }

    public String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("getLocalIp...{}", (Object)e.getMessage());
            return "127.0.0.1";
        }
    }

    public String getClientIp(HttpServletRequest req) {
        String ip = req.getHeader("X-Forwarded-For");
        log.debug("X-Forwarded-For...{}", (Object)ip);
        if ((this.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) && this.isEmpty(ip = req.getRemoteAddr())) {
            return "";
        }
        int p = ip.indexOf(44);
        return p > 0 ? ip.substring(0, p) : ip;
    }

    @Deprecated
    public String getLocale(HttpServletRequest req) {
        return req.getLocale().getLanguage();
    }

    public String buildUri(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringJoiner s = new StringJoiner("&");
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (this.isEmpty(e.getValue()) || this.isEmpty(e.getKey())) continue;
            s.add(e.getKey() + "=" + Digest.urlEncode(e.getValue()));
        }
        return s.toString();
    }

    public boolean notEmpty(String[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!this.isEmpty(values[i])) continue;
            return false;
        }
        return true;
    }

    public int toStep(int min, int max, int step) {
        int num = min + step;
        return num > max ? max : num;
    }

    @Deprecated
    public void close(Closeable[] closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                this.close(closeable);
            }
        }
    }

    public void close(Closeable closeable1, Closeable closeable2) {
        this.close(closeable1);
        this.close(closeable2);
    }

    public void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            log.error("close...{}", (Object)e.getMessage());
        }
    }

    public String toYuan(String money) {
        return this.toYuan(money, null);
    }

    public String toYuan(String money, String def) {
        return FmtUtil.toYuan(money, def);
    }

    public String toCent(String money) {
        return this.toCent(money, null);
    }

    public String toCent(String money, String def) {
        String val = "0";
        try {
            double d = 0.0;
            if (!this.isEmpty(money) && this.isNumeric(money = money.replace(",", ""))) {
                d = Double.valueOf(money) * 100.0;
            }
            val = new DecimalFormat("#0").format(d);
        }
        catch (Exception e) {
            this.error("toCent...{}", money);
        }
        return def != null && this.isNil(val) ? def : val;
    }

    public String toRmb(String money) {
        return FmtUtil.toRmb(money);
    }

    public String toRmb(long num) {
        return FmtUtil.toRmb(num);
    }

    public String newLeafId(Object pid, List<Map<String, String>> list, String key, int bitW) {
        if (this.isEmpty(list)) {
            return this.idCode(pid, 1, bitW);
        }
        String maxId = list.get(list.size() - 1).get(key);
        int id = Integer.parseInt(maxId.substring(maxId.length() - bitW));
        if (id > list.size()) {
            for (int i = 0; i < list.size(); ++i) {
                maxId = list.get(i).get(key);
                id = Integer.parseInt(maxId.substring(maxId.length() - bitW));
                if (id <= i + 1) continue;
                return this.idCode(pid, i + 1, bitW);
            }
        }
        return this.idCode(pid, list.size() + 1, bitW);
    }

    public String pHolder(Object key, String opr) {
        return FmtUtil.pHolder(key, opr);
    }

    public String quote(Object key, String ch) {
        return FmtUtil.quote(key, ch);
    }

    String quote(Object key) {
        return FmtUtil.quote(key, "'");
    }

    private class TypeRef<T>
    extends TypeReference<T> {
        private TypeRef() {
        }
    }
}

