/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static Logger log = LoggerFactory.getLogger(ThirdService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;
    @Autowired
    private HttpServletRequest req;

    public boolean certifyWith() {
        String cK = this.req.getParameter("k");
        String jsonStr = this.req.getParameter("jsonstr");
        String appKey = ConfUtil.appKey();
        if (appKey.equals(cK)) {
            if (jsonStr == null) {
                return true;
            }
            return this.setJsonAttr(this.utils.json2Map(jsonStr));
        }
        String ticket = this.req.getParameter("ticket");
        if (ticket != null) {
            return this.certifyApiKey(jsonStr, ticket);
        }
        if (cK == null) {
            return false;
        }
        String priKey = this.redis.getCertKey(cK);
        if (priKey != null && jsonStr != null && (jsonStr = Digest.sm2Decrypt(jsonStr, priKey)) != null) {
            return this.setJsonAttr(this.utils.json2Map(jsonStr));
        }
        log.warn("Auth failed > {} : {}", (Object)cK, (Object)appKey);
        return false;
    }

    private boolean certifyApiKey(String jsonStr, String ticket) {
        Map<String, Object> params;
        if (!ConfUtil.isApiOpen() || jsonStr == null) {
            return false;
        }
        String spec = this.redis.get("a." + ticket);
        if (spec == null) {
            spec = (String)ConfUtil.invoke(null, "appCert", ticket);
            if (this.utils.isEmpty(spec)) {
                return false;
            }
            this.redis.set("a." + ticket, spec, this.getSecond());
        }
        if ((params = this.utils.json2Map(jsonStr = Digest.sm4Decrypt(jsonStr, spec))).isEmpty()) {
            return false;
        }
        return this.setJsonAttr(params);
    }

    private boolean setJsonAttr(Map<String, Object> params) {
        params.remove("base");
        Object dbid = params.get(ConfUtil.dbid());
        String base = "";
        if (dbid != null) {
            if (Pattern.matches("\\w+", String.valueOf(dbid))) {
                base = this.baseNameOf(dbid);
                params.put("base", base);
            } else {
                params.remove(ConfUtil.dbid());
            }
        }
        Object i18n = params.get("i18n");
        if (!this.utils.findIn(ConfUtil.locales(), i18n)) {
            params.put("i18n", this.getUserLang());
        }
        this.req.setAttribute("json", params);
        log.debug("setJsonAttr...{}", params);
        return true;
    }

    private String baseNameOf(Object dbid) {
        return ConfUtil.dataIsolation() ? "" : ConfUtil.baseName() + dbid + ConfUtil.baseDot();
    }

    private String getUserLang() {
        String lang = this.utils.userSelf(this.req).get("userLang");
        if (this.utils.isEmpty(lang)) {
            lang = this.req.getLocale().getLanguage().toUpperCase();
        }
        return lang;
    }

    public boolean authAccess(HttpServletRequest request, HttpServletResponse response, Map<String, String> token) {
        String userId = token.get("userId");
        Map<String, String> user = this.redis.getUserInfo(userId);
        if (user.isEmpty()) {
            this.redis.clearToken(token);
            return this.invlidToken(response);
        }
        String jsonStr = request.getParameter("jsonstr");
        Map<String, Object> params = this.decryptParams(user, token, jsonStr);
        if (params == null) {
            return this.invlidToken(response);
        }
        Object appCode = params.get("appCode");
        String appSign = ConfUtil.appSign();
        String uri = this.utils.getRequestURI(this.req);
        if (this.utils.isEmpty(appCode)) {
            if (appSign.length() > 0) {
                params.put("appCode", appSign);
                String role = this.trustedRole(params, user, uri);
                log.debug("trustedRole...{}", (Object)role);
                if (!"1".equals(role)) {
                    return this.denyAccess(response);
                }
            }
            if (jsonStr == null && params.isEmpty()) {
                this.requestParams(params);
            }
        } else if (!this.certifyPermit(appSign, appCode, uri)) {
            return this.denyAccess(response);
        }
        log.debug("request... {}", (Object)uri);
        if (!this.certifyParams(params, uri)) {
            return this.invlidParams(response);
        }
        if (!this.isTenant(appSign, params.get(ConfUtil.dbid()), user)) {
            return this.invlidParams(response);
        }
        return this.setJsonAttr(params);
    }

    private Map<String, Object> decryptParams(Map<String, String> user, Map<String, String> token, String jsonStr) {
        String spec = token.get("certId");
        this.req.setAttribute("user", user);
        this.req.setAttribute("userId", (Object)user.get("userId"));
        this.req.setAttribute("certId", (Object)spec);
        if (!ConfUtil.isEncOmit() && !this.utils.isEmpty(jsonStr) && (jsonStr = Digest.sm4Decrypt(jsonStr, spec)) == null) {
            return null;
        }
        log.debug("decryptParams...{}", (Object)jsonStr);
        return this.utils.json2Map(jsonStr);
    }

    private void requestParams(Map<String, Object> params) {
        Enumeration map = this.req.getParameterNames();
        while (map.hasMoreElements()) {
            String key = (String)map.nextElement();
            params.put(key, this.req.getParameter(key));
        }
    }

    private boolean certifyPermit(String appSign, Object appCode, String uri) {
        if (appSign.length() == 0) {
            return true;
        }
        String app = String.valueOf(appCode);
        String[] arr = new String[]{"a.", appSign, ".", app};
        String key = this.utils.join(arr);
        Map<String, String> permit = this.redis.hmget(key);
        if (permit.isEmpty()) {
            permit = this.getActionPermit(appSign, app);
            log.debug("certifyPermit...{}", permit);
            if (permit.isEmpty()) {
                return false;
            }
            this.redis.hmset(key, permit, 3600);
        }
        return permit.containsKey(uri);
    }

    private boolean certifyParams(Map<?, ?> params, String uri) {
        String keys = ConfUtil.getValid(uri);
        if (keys.length() == 0) {
            return true;
        }
        if (ConfUtil.mustValid()) {
            keys = keys + "," + ConfUtil.dbid();
        } else if (params.containsKey(ConfUtil.dbid())) {
            params.remove(ConfUtil.dbid());
        }
        return this.utils.availParams(params, keys.split(",|;"));
    }

    private boolean isTenant(String appSign, Object dbid, Map<String, String> user) {
        Map userBase;
        String tenantId;
        return appSign.length() <= 0 || dbid == null || this.utils.isEmpty(tenantId = (String)(userBase = this.utils.json2Map(user.get("userBase"))).get(appSign)) || "0".equals(tenantId) || tenantId.equals(dbid);
    }

    private Map<String, String> getActionPermit(String appSign, String appCode) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("actApp", appSign);
        where.put("actMark", "0");
        where.put("actState", "1");
        if (ConfUtil.apiPermit()) {
            String[] arr = new String[]{"({", "actPermit", "} is NULL OR ", this.utils.jsonExt("actPermit", appCode), "{0} OR ", this.utils.jsonExt("actPermit", "all"), "{0})"};
            where.put(this.utils.join(arr), "1");
        }
        log.debug("getActionPermit...{}", where);
        List<Map<String, String>> list = this.aolai.findList("ACTION", where);
        return this.aolai.actionRole(list);
    }

    private String trustedRole(Map<String, Object> params, Map<String, String> user, String uri) {
        Map<String, Object> duty = this.aolai.getRoleParams(params, user);
        Object[] keys = new Object[]{params.get("appCode"), duty.get("compId"), duty.get("dutyId")};
        return this.redis.getActionRole(this.utils.join(keys, "."), uri);
    }

    private boolean invlidParams(HttpServletResponse rsp) {
        return this.invalidResult(rsp, "2");
    }

    public boolean invlidToken(HttpServletResponse rsp) {
        return this.invalidResult(rsp, "3");
    }

    private boolean denyAccess(HttpServletResponse rsp) {
        return this.invalidResult(rsp, "5");
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        try (PrintWriter out = rsp.getWriter();){
            out.write(this.utils.obj2Str(this.utils.result(status)));
            out.flush();
        }
        catch (Exception e) {
            log.error("invalidResult...{}", (Object)e.getMessage());
        }
        return false;
    }

    private int getSecond() {
        String sec = this.req.getParameter("sec");
        return this.utils.isInteger(sec) ? Integer.parseInt(sec) : ConfUtil.cacheTime();
    }
}

