package cn.ps1.aolai.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Digest;

/**
 * 根据url、应用app、主服务main、账套dbid、用户、密码，模拟请求服务
 * @author fulin
 *
 */
public class TestUtil {

	private static Logger log = LoggerFactory.getLogger(TestUtil.class);
	private static final String TICKET = "ticket";
	private static final String TOKENS = "tokens";
	private static final int TIMES = 1; // 最大重试次数
	// 主要的参数
	private String main = "culai/w/";
	// 账套参数： "2676";
	private String dbid = "";
	// 服务地址："http://mytest.ps1.cn:8080/"
	private String url = "";
	// 应用名称："muya/w/"
	private String app = "";
	// 用户名及密码，如："18666666666"\"Test@culai"
	private String user = "";
	private String pass = "";

	UtilsService utils = new UtilsService();
	HttpsService https = new HttpsService();
	Set<String> cookies = new HashSet<>();
	String spec = null;
	int count = 0;

	public TestUtil(Map<String, String> params) {
		this.url = params.get("url");
		this.app = params.get("app");
		this.main = params.get("main");
		this.dbid = params.get("dbid");
		this.user = params.get("user");
		this.pass = params.get("pass");
	}

	public TestUtil(String url, String app, String main, String dbid, String user, String pass) {
		this.url = url;
		this.app = app + "/w/";
		this.main = main + "/w/";
		this.dbid = dbid;
		this.user = user;
		this.pass = pass;
	}

	/**
	 * 获取许可证书
	 */
	private String getCertKey() {
		Map<String, String> params = new HashMap<>();
		params.put(TICKET, "BNQTJMFP"); //CERT_KEY=OzLIyAcHudSKGVrXEw
		params.put("k", "www.ps1.cn");
		String res = https.httpPost(url + main + "getTicket", params);
		Map<String, String> map = utils.json2Map(res);
		map = utils.obj2Map(map.get(Const.INFO));
		return map.get("certKey");
	}

	/** 发送服务请求 */
	public Map<String, Object> doPost(String ws, Map<String, Object> params) {
		if (cookies.isEmpty())
			readCookies();

		Map<String, String> map = new HashMap<>();
		String jsonstr = utils.obj2Str(params);
		map.put(ConfUtil.JSONSTR, Digest.sm4Encrypt(jsonstr, spec));
		String res = https.httpPost(url + app + ws, cookies, map);
		log.debug("->> result:{}", res);

		Map<String, Object> result = utils.json2Map(res);

		Object status = result.get(Const.STS);
		if ("3".equals(status)) {
			// 重试
			while (count++ < TIMES) {
				// 删除文件，清除缓存的cookies
				deleteFile(TOKENS);
				deleteFile(TICKET);
				// 重试
				autoSignIn();
				return doPost(ws, params);
			}
		} else if ("1".equals(status)) {
			log.debug("->> success! ");
		} else {
			log.debug("->> failed! {}", map);
		}
		return result;
	}

	/**
	 * 自动登录系统
	 */
	private void autoSignIn() {
		String certKey = getCertKey(); // 获取证书
		spec = Digest.genRawKey(); // 生成动态密钥
		Map<String, String> map = new HashMap<>();
		map.put("user", user);
		map.put("pass", Digest.md5(pass));
		map.put(TICKET, certKey);
		map.put("spec", spec);
		// 加密
		String jsonstr = Digest.sm2Encrypt(utils.obj2Str(map), certKey);
		// 请求参数
		Map<String, String> params = new HashMap<>();
		params.put(ConfUtil.JSONSTR, jsonstr);
		params.put("k", certKey);

		https.httpPost(url + main + "signIn", params);
		// 返回当前响应Cookies
		cookies = https.getCookies();
		saveTokens(TOKENS, cookies);
		saveTicket(TICKET, spec);
	}

	/** 读出cookies和ticket */
	private void readCookies() {
		cookies = readContent(TOKENS);
		if (cookies.isEmpty()) {
			autoSignIn();
		} else {
			// ticket只有一行数据
			Set<String> vaules = readContent(TICKET);
			for (String str : vaules)
				spec = str;
		}
	}

	/**
	 * 读取文件获取信息
	 */
	private Set<String> readContent(String fileName) {
		Set<String> set = new HashSet<>();
		File file = new File(fileName + ".txt");
		try (BufferedReader br = new BufferedReader(new FileReader(file))) {
			String line;
			while ((line = br.readLine()) != null) {
				set.add(line);
				log.debug(">{} = \"{}\"", fileName, line);
			}
			br.close();
		} catch (IOException e) {
			log.debug(">{} is null.", fileName);
		}
		return set;
	}

	private void saveTokens(String name, Set<String> arr) {
		try {
			log.debug("> save to {}", name);
			File file = new File(name + ".txt");
			if (!file.exists())
				file.createNewFile();
			// 替换所有现有的内容与新的内容
			FileWriter writer = new FileWriter(file);
			for (String str : arr)
				writer.write(str + "\n");
			writer.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 删除临时文件
	 */
	private void deleteFile(String name) {
		File file = new File(name + ".txt");
		if (!file.delete()) {
			log.debug("> Delete file failed.");
		}
	}

	private void saveTicket(String name, String... arr) {
		try {
			log.debug("> save to {}", name);
			File file = new File(name + ".txt");
			if (!file.exists())
				file.createNewFile();
			// 替换所有现有的内容与新的内容
			FileWriter writer = new FileWriter(file);
			for (String str : arr)
				writer.write(str + "\n");
			writer.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 仅仅为了方便测试而开发此方法
	 */
	public Map<String, Object> newParams() {
		Map<String, Object> params = new HashMap<>();
		if (dbid != null && dbid.length() > 0)
			params.put("dbid", dbid);
		return params;
	}

}
