/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtUtil {
    private static Logger log = LoggerFactory.getLogger(FmtUtil.class);
    private static final String NIL = "0.00";
    private static final String RMB = "#,##0.00";
    private static final String[] STAR = new String[]{"", "*", "**", "***", "****"};
    private static final String WD = "[\\w+ \u4e00-\u9fa5]+";

    private FmtUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isValidWord(String val) {
        return Pattern.matches(WD, val);
    }

    public static String blur(String str, String diff) {
        if ("PN".equals(diff)) {
            str = FmtUtil.blur(str, 4, 3);
        } else if ("ID".equals(diff)) {
            str = FmtUtil.blur(str, 4, 4);
        } else if ("BA".equals(diff)) {
            str = FmtUtil.blur(str, 4, 3);
        } else if ("EM".equals(diff)) {
            CharSequence[] arr = str.split("@");
            int len = arr[0].length();
            if (arr.length == 2 && len > 0) {
                arr[0] = len > 3 ? FmtUtil.blur(arr[0], len - 4, 3) : FmtUtil.blur(arr[0], 0, len - 1);
                str = String.join((CharSequence)"@", arr);
            }
        }
        return str;
    }

    public static String blur(String str, int pos, int num) {
        pos = str.length() - pos - num;
        if (pos < 0) {
            return str;
        }
        return str.substring(0, pos) + STAR[num] + str.substring(pos + num);
    }

    public static String timeParse(String str, String pat0, String pat1) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat(pat0).parse(str));
            return FmtUtil.timeParse(cal, pat1);
        }
        catch (Exception e) {
            log.error("timeParse...{}", (Object)str);
            return str;
        }
    }

    public static String timeParse(Calendar cal, String pattern) {
        pattern = pattern == null ? "yyyy-MM-dd HH:mm:ss" : pattern;
        return new SimpleDateFormat(pattern).format(cal.getTime());
    }

    public static String indent(String str, int num, char chr) {
        StringBuilder pad = new StringBuilder();
        while (num-- > 0) {
            pad.append(chr);
        }
        return pad.toString() + (str == null ? "" : str);
    }

    public static String leftPad(String str, int size, char chr) {
        return FmtUtil.indent(str, str == null ? size : size - str.length(), chr);
    }

    public static String nextSeq(String seqNo) {
        return FmtUtil.leftPad(Digest.nextSeq(seqNo), seqNo.length(), '0');
    }

    public static String commaFmt(String str, int digit) {
        return FmtUtil.commaFmt(FmtUtil.toNumeric(str), digit);
    }

    public static String commaFmt(String str, int digit, String def) {
        return FmtUtil.commaFmt(FmtUtil.toNumeric(str), digit, def);
    }

    public static String commaFmt(double num, int digit) {
        return FmtUtil.commaFmt(num, digit, "-");
    }

    public static String commaFmt(double num, int digit, String def) {
        String str = FmtUtil.parse(num, "#,##0", digit);
        return FmtUtil.isZero(str) ? def : str;
    }

    public static String parse(String str, int digit) {
        return FmtUtil.parse(FmtUtil.toNumeric(str), digit);
    }

    public static String parse(double num, int digit) {
        return FmtUtil.parse(num, "#0", digit);
    }

    private static String parse(double num, String pattern, int digit) {
        pattern = digit > 0 ? pattern + "." : pattern;
        StringBuilder pad = new StringBuilder();
        while (digit-- > 0) {
            pad.append("0");
        }
        return FmtUtil.parse(num, pattern + pad.toString());
    }

    private static String parse(double num, String pattern) {
        return new DecimalFormat(pattern).format(num);
    }

    public static String ifZero(String str, String def) {
        return str == null || FmtUtil.isZero(str) ? def : str;
    }

    public static boolean isZero(Object obj) {
        return Pattern.matches("(-?0)(\\.0+)?", String.valueOf(obj));
    }

    private static double toNumeric(String str) {
        try {
            return FmtUtil.isNumeric(str) ? Double.parseDouble(str) : 0.0;
        }
        catch (Exception e) {
            log.error("toNumeric...{}", (Object)str);
            return 0.0;
        }
    }

    public static String toYuan(String str, String def) {
        str = FmtUtil.parse(FmtUtil.toNumeric(str) / 100.0, RMB);
        return def != null && NIL.equals(str) ? def : str;
    }

    public static String toRmb(String money) {
        return FmtUtil.isInteger(money) ? FmtUtil.toRmb(Long.parseLong(money)) : "";
    }

    public static String toRmb(long num) {
        int i;
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] units = new String[][]{{"\u5206", "\u89d2", "\u5143", "\u4e07", "\u4ebf", "\u4e07"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = num < 0L ? "\u8d1f" : "";
        num = Math.abs(num);
        StringBuilder rmb = new StringBuilder();
        for (i = 0; i < 2 && num > 0L; num /= 10L, ++i) {
            rmb.insert(0, digit[(int)(num % 10L)] + units[0][i]);
        }
        for (i = 2; i < units[0].length && num > 0L; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < units[1].length && num > 0L; num /= 10L, ++j) {
                sb.insert(0, digit[(int)(num % 10L)] + units[1][j]);
            }
            String p = sb.toString();
            p = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6");
            rmb.insert(0, p + units[0][i]);
        }
        String s = rmb.toString();
        s = s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceAll("(\u96f6.)+", "\u96f6");
        return head + s.replaceAll("\u96f6$", "\u6574");
    }

    public static boolean isInteger(String str) {
        return str != null && FmtUtil.isInt(str);
    }

    public static boolean isNumeric(String str) {
        return FmtUtil.isMatch(str, "(-?\\d+)(\\.\\d+)?");
    }

    public static String quote(Object str, String ch) {
        return ch + str + ch;
    }

    public static String pHolder(Object key, String opr) {
        return "{" + key + "}" + FmtUtil.quote(opr, " ");
    }

    public static boolean isMatch(String str, String regex) {
        return str != null && Pattern.matches(regex, str);
    }

    public static boolean findIn(String str, String regex) {
        if (str == null) {
            throw new FailedException();
        }
        return Pattern.compile(regex).matcher(str).find();
    }

    static int getInt(String val, int def) {
        return FmtUtil.isInt(val) ? Integer.parseInt(val) : def;
    }

    private static boolean isInt(String val) {
        return Pattern.matches("-?\\d+", val);
    }
}

