package cn.ps1.aolai.utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * 通过IOC容器，映射ApplicationContext，并在应用中任意获取指定的Bean
 * 
 * @author Aolai
 * @version 1.0
 *
 */
@Component
public class SpringContext implements ApplicationContextAware {

	private static ApplicationContext appCtx = null;

	static synchronized void init(ApplicationContext ctx) {
		if (appCtx == null) {
			appCtx = ctx;
		}
	}

	@Override
	public void setApplicationContext(ApplicationContext ctx) {
		SpringContext.init(ctx);
		ConfUtil.initAppGconf();
	}

	// 获取appCtx上下文
	public ApplicationContext getApplicationContext() {
		return appCtx;
	}

	// 通过name获取 Bean.
	public static synchronized Object getBean(String beanName) {
		return appCtx.getBean(beanName);
	}

	// 通过class获取Bean.
	public static synchronized <T> T getBean(Class<T> clazz) {
		return appCtx.getBean(clazz);
	}

	// 通过name,以及Clazz返回指定的Bean
	public static synchronized <T> T getBean(String name, Class<T> clazz) {
		return appCtx.getBean(name, clazz);
	}

}
