/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.ThirdService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class Interceptor
implements HandlerInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(Interceptor.class);
    private static final String REQ_TIME = "REQ_TIME";
    @Autowired
    private RedisService redis;
    @Autowired
    private ThirdService third;
    @Autowired
    private UtilsService utils;
    @Autowired
    private AolaiService aolai;

    public boolean preHandle(HttpServletRequest req, HttpServletResponse rsp, Object handler) throws Exception {
        this.defineConfig(req);
        Map<String, String> cookies = this.utils.getCookies(req);
        Map<String, String> token = this.validToken(req, cookies);
        if (token != null) {
            return this.third.authAccess(rsp, token);
        }
        return this.third.verifySecret() ? true : this.third.invlidToken(rsp);
    }

    private void defineConfig(HttpServletRequest req) {
        if (ConfUtil.isTracking()) {
            String tid = req.getHeader("traceId");
            MDC.put((String)"traceId", (String)(tid == null ? Digest.uuid() : tid));
        }
        req.setAttribute(REQ_TIME, (Object)System.currentTimeMillis());
    }

    private Map<String, String> validToken(HttpServletRequest req, Map<String, String> cookies) {
        String uuid = cookies.get("token");
        if (uuid == null && (uuid = req.getHeader("token")) == null) {
            uuid = req.getParameter("token");
        }
        if (uuid == null) {
            LOG.debug("validToken...NULL");
            return null;
        }
        return this.redis.verifyToken(uuid);
    }

    public void postHandle(HttpServletRequest req, HttpServletResponse rsp, Object handler, ModelAndView modelAndView) throws Exception {
        String args;
        long msec = System.currentTimeMillis() - (Long)req.getAttribute(REQ_TIME);
        Map<String, String> user = this.utils.userSelf(req);
        HashMap<String, Object> logInfo = new HashMap<String, Object>();
        logInfo.put("logUid", user.get("userId"));
        logInfo.put("logComp", user.get("userComp"));
        logInfo.put("logUri", this.utils.getRequestURI(req));
        logInfo.put("logIp", this.utils.getClientIp(req));
        logInfo.put("logMsec", msec);
        Object body = req.getAttribute("PLAIN_BODY");
        if (body instanceof Map) {
            Map map = this.utils.obj2Map(body);
            Object status = map.get("status");
            if (!"1".equals(status)) {
                logInfo.put("logInfo", map.get("info"));
            }
            logInfo.put("logStatus", status);
        }
        Map json = this.utils.obj2Map(req.getAttribute("json"));
        logInfo.put("i18n", json.get("i18n"));
        if (ConfUtil.logArgs() > 0 && (args = this.utils.obj2Str(json)) != null && args.length() < ConfUtil.IS_LOG_ARGS) {
            logInfo.put("logArgs", args);
        }
        LOG.debug("logInfo:{}", logInfo);
        if (!ConfUtil.isLogResp()) {
            return;
        }
        try {
            this.aolai.addRecord(json.get("base"), "OPERLOG", logInfo);
        }
        catch (Exception e) {
            LOG.warn("OPERLOG...{}", (Object)e.getMessage());
        }
    }

    public void afterCompletion(HttpServletRequest req, HttpServletResponse rsp, Object handler, Exception ex) throws Exception {
        MDC.remove((String)"traceId");
    }
}

