/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtUtil {
    private static Logger LOG = LoggerFactory.getLogger(FmtUtil.class);
    private static final String NIL = "0.00";
    private static final String RMB = "#,##0.00";

    public static String timeParse(String str, String pat0, String pat1) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat(pat0).parse(str));
            return FmtUtil.timeParse(cal, pat1);
        }
        catch (Exception e) {
            LOG.error("timeParse...{}", (Object)str);
            return str;
        }
    }

    public static String timeParse(Calendar cal, String pattern) {
        pattern = pattern == null ? "yyyy-MM-dd HH:mm:ss" : pattern;
        return new SimpleDateFormat(pattern).format(cal.getTime());
    }

    public static String indent(String str, int num, char chr) {
        String string = str = str == null ? "" : str;
        while (num-- > 0) {
            str = chr + str;
        }
        return str;
    }

    public static String leftPad(String str, int size, char chr) {
        return FmtUtil.indent(str, str == null ? size : size - str.length(), chr);
    }

    public static String commaFmt(String str, int prec) {
        return FmtUtil.commaFmt(FmtUtil.toNumeric(str), prec);
    }

    public static String commaFmt(String str, int prec, String def) {
        return FmtUtil.commaFmt(FmtUtil.toNumeric(str), prec, def);
    }

    public static String commaFmt(double num, int prec) {
        return FmtUtil.commaFmt(num, prec, "-");
    }

    public static String commaFmt(double num, int prec, String def) {
        String str = FmtUtil.parse(num, "#,##0", prec);
        return FmtUtil.isZero(str) ? def : str;
    }

    public static String parse(String str, int prec) {
        return FmtUtil.parse(FmtUtil.toNumeric(str), prec);
    }

    public static String parse(double num, int prec) {
        return FmtUtil.parse(num, "#0", prec);
    }

    private static String parse(double num, String pattern, int prec) {
        String string = pattern = prec > 0 ? pattern + "." : pattern;
        while (prec-- > 0) {
            pattern = pattern + "0";
        }
        return FmtUtil.parse(num, pattern);
    }

    private static String parse(double num, String pattern) {
        return new DecimalFormat(pattern).format(num);
    }

    public static String ifZero(String str, String def) {
        return str == null || FmtUtil.isZero(str) ? def : str;
    }

    public static boolean isZero(Object obj) {
        return Pattern.matches("(-?0)(\\.0+)?", String.valueOf(obj));
    }

    private static double toNumeric(String str) {
        try {
            return FmtUtil.isNumeric(str) ? Double.parseDouble(str) : 0.0;
        }
        catch (Exception e) {
            LOG.error("toNumeric...{}", (Object)str);
            return 0.0;
        }
    }

    public static String toYuan(String str, String def) {
        str = FmtUtil.parse(FmtUtil.toNumeric(str) / 100.0, RMB);
        return def != null && NIL.equals(str) ? def : str;
    }

    public static String toRmb(String money) {
        return FmtUtil.isInteger(money) ? FmtUtil.toRmb(Long.parseLong(money)) : "";
    }

    public static String toRmb(long num) {
        int i;
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] units = new String[][]{{"\u5206", "\u89d2", "\u5143", "\u4e07", "\u4ebf", "\u4e07"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String s = "";
        String head = num < 0L ? "\u8d1f" : "";
        num = Math.abs(num);
        for (i = 0; i < 2 && num > 0L; num /= 10L, ++i) {
            s = digit[(int)(num % 10L)] + units[0][i] + s;
        }
        for (i = 2; i < units[0].length && num > 0L; ++i) {
            String p = "";
            for (int j = 0; j < units[1].length && num > 0L; num /= 10L, ++j) {
                p = digit[(int)(num % 10L)] + units[1][j] + p;
            }
            p = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6");
            s = p + units[0][i] + s;
        }
        s = s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceAll("(\u96f6.)+", "\u96f6");
        return head + s.replaceAll("\u96f6$", "\u6574");
    }

    public static boolean isInteger(String str) {
        return str != null && Pattern.matches("-?\\d+", str);
    }

    public static boolean isNumeric(String str) {
        return str != null && Pattern.matches("(-?\\d+)(\\.\\d+)?", str);
    }
}

