/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

public class DigitUtil {
    public static int hex2Dec(char ch) {
        return Character.digit(ch, 16);
    }

    public static int hex2Dec(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static byte hex2Byte(char ch) {
        return (byte)DigitUtil.hex2Dec(ch);
    }

    public static byte hex2Byte(String hexStr) {
        int val = DigitUtil.hex2Dec(hexStr);
        return (byte)(val & 0xFF);
    }

    public static String toHexStr(int i) {
        String hex = Integer.toHexString(i);
        return hex.length() == 1 ? '0' + hex : hex;
    }

    public static String toHexStr(byte b) {
        return DigitUtil.toHexStr(b & 0xFF);
    }

    public static String[] toHex(byte[] data) {
        return DigitUtil.toHex(data, 0, data.length);
    }

    public static String[] toHex(byte[] data, int begin, int end) {
        String[] hexArr = new String[end - begin];
        for (int i = begin; i < end; ++i) {
            hexArr[i] = DigitUtil.toHexStr(data[i]);
        }
        return hexArr;
    }

    public static String toHexStr(byte[] data) {
        return DigitUtil.toHexStr(data, 0, data.length);
    }

    public static String toHexStr(byte[] data, int begin, int end) {
        StringBuilder builder = new StringBuilder(2 * (end - begin));
        for (int i = begin; i < end; ++i) {
            builder.append(DigitUtil.toHexStr(data[i]));
        }
        return builder.toString();
    }

    public static byte[] hex2Bytes(String hexStr) {
        hexStr = hexStr.replaceAll("\\s*", "");
        char[] hexChs = hexStr.toCharArray();
        int len = hexStr.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            bytes[i] = (byte)(DigitUtil.hex2Byte(hexChs[pos]) << 4 | DigitUtil.hex2Byte(hexChs[pos + 1]));
        }
        return bytes;
    }

    public static byte xorCheck(byte[] arr) {
        byte b = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            b = (byte)(b ^ arr[i]);
        }
        return b;
    }

    public static String hex2Temperature(String str) {
        int i = DigitUtil.hex2Dec(str);
        double temperature = 0.0;
        temperature = i >> 15 == 1 ? (double)(-(i << 17 >> 17)) / 10.0 : (double)i / 10.0;
        return String.valueOf(temperature);
    }
}

