/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpsService {
    private static Logger LOG = LoggerFactory.getLogger(HttpsService.class);
    private Map<String, String> headers = new HashMap<String, String>();
    private static RequestConfig DEF_CONF = null;
    private static String MAIN_URL = null;
    public Header[] getHeaders;
    @Autowired
    UtilsService utils;

    private RequestConfig requestConf() {
        if (DEF_CONF == null) {
            DEF_CONF = RequestConfig.custom().setRedirectsEnabled(false).setConnectTimeout(ConfUtil.httpTimeout()).setConnectionRequestTimeout(ConfUtil.httpTimeout()).setSocketTimeout(ConfUtil.httpTimeout()).build();
        }
        return DEF_CONF;
    }

    public Set<String> getCookies() {
        return this.getHeader("Set-Cookie");
    }

    public Set<String> getHeader(String name) {
        HashSet<String> values = new HashSet<String>();
        for (Header header : this.getHeaders) {
            if (!header.getName().equals(name)) continue;
            values.add(header.getValue());
        }
        return values;
    }

    public String httpGet(String url, Map<String, String> params) {
        return this.httpGet(url, null, params);
    }

    public String httpGet(String url, Set<String> cookies) {
        return this.httpGet(url, cookies, new HashMap<String, String>());
    }

    public String httpGet(String url, Set<String> cookies, Map<String, String> params) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            HttpGet httpGet = new HttpGet(this.buildUrl(url, params));
            httpGet.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpGet, url, cookies, null);
            resp = client.execute((HttpUriRequest)httpGet);
            String string = this.getResult(this.doResponse(resp));
            this.utils.close((Closeable)resp, (Closeable)client);
            return string;
        }
        catch (Exception e) {
            try {
                LOG.error("httpGet...{}", (Object)url);
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close((Closeable)resp, (Closeable)client);
                throw throwable;
            }
        }
    }

    public String httpPost(String url, String jsonStr, String k) {
        return this.httpPost(url, this.withKey(jsonStr, k));
    }

    public String httpPost(String url) {
        return this.httpPost(url, null, new HashMap<String, String>(), "UTF-8");
    }

    public String httpPost(String url, Set<String> cookies) {
        return this.httpPost(url, cookies, new HashMap<String, String>(), "UTF-8");
    }

    public String httpPost(String url, Map<String, String> params) {
        return this.httpPost(url, null, params, "UTF-8");
    }

    public String httpPost(String url, Set<String> cookies, Map<String, String> params) {
        return this.httpPost(url, cookies, params, "UTF-8");
    }

    public String httpPost(String url, Set<String> cookies, Map<String, String> params, String encoding) {
        return this.httpPost(url, cookies, params, encoding, null);
    }

    public String httpPost(String url, Set<String> cookies, Map<String, String> params, String encoding, Map<String, String> exHeadres) {
        try {
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            return this.httpPost(url, cookies, (HttpEntity)entity, exHeadres);
        }
        catch (Exception e) {
            throw new FailedException("httpFailed");
        }
    }

    public String httpPost(String url, Set<String> cookies, HttpEntity entity, Map<String, String> exHeaders) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            LOG.info("> httpPost...{}", (Object)url);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpPost, url, cookies, exHeaders);
            httpPost.setEntity(entity);
            resp = client.execute((HttpUriRequest)httpPost);
            String string = this.getResult(this.doResponse(resp));
            this.utils.close((Closeable)resp, (Closeable)client);
            return string;
        }
        catch (Exception e) {
            try {
                LOG.error("httpPost...{}", (Object)url);
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close((Closeable)resp, (Closeable)client);
                throw throwable;
            }
        }
    }

    public String httpPost(String url, Set<String> cookies, HttpEntity entity) {
        return this.httpPost(url, cookies, entity, null);
    }

    public String postData(String url, String json) {
        return this.httpPost(url, null, (HttpEntity)this.stringEntity(json));
    }

    private StringEntity stringEntity(String json) {
        try {
            StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
            entity.setContentType("application/json");
            return entity;
        }
        catch (Exception e) {
            LOG.error("stringEntity...{}", (Object)e.getMessage());
            throw new FailedException();
        }
    }

    private HttpEntity doResponse(CloseableHttpResponse resp) {
        StatusLine sLine = resp.getStatusLine();
        if (sLine.getStatusCode() == 200 || sLine.getStatusCode() == 302) {
            this.getHeaders = resp.getAllHeaders();
            return resp.getEntity();
        }
        LOG.error("> doResponse...{}", (Object)sLine);
        throw new FailedException("httpFailed");
    }

    private String getResult(HttpEntity entity) throws Exception {
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            if (result.length() > 200) {
                LOG.debug("{}{}", (Object)result.substring(0, 200), (Object)"...");
            } else {
                LOG.debug(result);
            }
        }
        return result;
    }

    private String buildUrl(String url, Map<String, String> params) {
        if (url != null) {
            String str = this.utils.buildUri(params);
            boolean islast = url.lastIndexOf(63) == url.length() - 1;
            url = url + (islast ? str : "&" + str);
        }
        return url;
    }

    private void setHeaders(HttpMessage msg, String url, Set<String> cookies, Map<String, String> exHeaders) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            msg.addHeader(entry.getKey(), entry.getValue());
        }
        if (cookies != null) {
            for (String string : cookies) {
                msg.addHeader("Cookie", string);
            }
            LOG.info("setCookies...{}", cookies);
        }
        if (exHeaders != null) {
            for (Map.Entry entry : exHeaders.entrySet()) {
                msg.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        msg.addHeader("Referer", url);
        String tid = MDC.get((String)"traceId");
        if (tid != null) {
            msg.addHeader("traceId", tid);
        }
    }

    private List<NameValuePair> setParams(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                if (val == null) continue;
                nvpList.add((NameValuePair)new BasicNameValuePair(key, val));
            }
        }
        return nvpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean digestDownload(String userName, String password, String url, String filePath) {
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        try {
            HttpGet request = new HttpGet(url);
            resp = client.execute((HttpUriRequest)request);
            HttpEntity entity = resp.getEntity();
            InputStream ins = entity.getContent();
            FileOutputStream fos = new FileOutputStream(filePath, false);
            int data = ins.read();
            while (data != -1) {
                fos.write(data);
                data = ins.read();
            }
            fos.close();
            EntityUtils.consume((HttpEntity)entity);
            boolean bl = true;
            this.utils.close((Closeable)resp, (Closeable)client);
            return bl;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.utils.close((Closeable)resp, (Closeable)client);
            }
            catch (Throwable throwable) {
                this.utils.close((Closeable)resp, (Closeable)client);
                throw throwable;
            }
        }
        return false;
    }

    public String digestJsonRequest(String userName, String password, String url, String json, String method) {
        RequestBuilder builder = this.setBuilder((HttpEntity)this.stringEntity(json), method);
        HttpUriRequest request = builder.setUri(url).build();
        json = this.digestRequest(userName, password, request);
        LOG.info("> digestJsonRequest...{}", (Object)json);
        return json;
    }

    public String digestRequest(String userName, String password, HttpUriRequest uriRequest) {
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        String result = null;
        try {
            resp = client.execute(uriRequest);
            result = this.getResult(this.doResponse(resp));
        }
        catch (Exception e) {
            throw new FailedException("httpFailed");
        }
        finally {
            this.utils.close((Closeable)client, (Closeable)resp);
        }
        return result;
    }

    private RequestBuilder setBuilder(HttpEntity entity, String method) {
        RequestBuilder request = null;
        if ("POST".equals(method)) {
            request = RequestBuilder.post();
        } else if ("GET".equals(method)) {
            request = RequestBuilder.get();
        } else if ("PUT".equals(method)) {
            request = RequestBuilder.put();
        } else if ("DELETE".equals(method)) {
            request = RequestBuilder.delete();
        }
        return request.setEntity(entity);
    }

    private CloseableHttpClient digestHttpClient(String user, String pass) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
        HttpClientBuilder http = HttpClientBuilder.create();
        http.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        return http.build();
    }

    public String urlConnect(String url, Map<String, String> params) {
        return this.urlConnect(this.buildUrl(url, params), new byte[0], "GET");
    }

    public String urlConnect(String url, String str, String method) {
        if (str == null) {
            return null;
        }
        return this.urlConnect(url, str.getBytes(StandardCharsets.UTF_8), method);
    }

    public String urlConnect(String url, byte[] bytes, String method) {
        HttpURLConnection conn = null;
        try {
            LOG.debug("urlConnect...{}", (Object)url);
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            this.setProperty(conn).setRequestMethod(method);
            conn.getOutputStream().write(bytes);
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 204) {
                return this.respAsString(conn.getInputStream());
            }
            return this.respAsString(conn.getErrorStream());
        }
        catch (Exception e) {
            LOG.error("> urlConnect...{}", (Object)url);
            return null;
        }
    }

    private HttpURLConnection setProperty(HttpURLConnection conn) {
        this.requestConf();
        conn.setConnectTimeout(ConfUtil.httpTimeout());
        conn.setReadTimeout(ConfUtil.httpTimeout());
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            conn.setRequestProperty(e.getKey(), e.getValue());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String respAsString(InputStream inp) {
        StringBuilder strBuf = new StringBuilder();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = new InputStreamReader(inp, StandardCharsets.UTF_8);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                strBuf.append(line);
            }
        }
        catch (IOException e) {
            try {
                LOG.error("> respAsString...{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                Closeable[] keys = new Closeable[]{inp, isr, br};
                this.utils.close(keys);
                throw throwable;
            }
            Closeable[] keys = new Closeable[]{inp, isr, br};
            this.utils.close(keys);
        }
        Closeable[] keys = new Closeable[]{inp, isr, br};
        this.utils.close(keys);
        return strBuf.toString();
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params, String k) {
        return this.doPost(url, this.utils.obj2Str(params), k);
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params) {
        return this.doPost(url, this.utils.obj2Str(params), null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr) {
        return this.doPost(url, jsonStr, null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr, String k) {
        Map<String, String> params = this.withKey(jsonStr, k);
        return this.utils.json2Map(this.httpPost(url, null, params, "UTF-8"));
    }

    private Map<String, String> withKey(String jsonStr, String k) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (jsonStr != null) {
            params.put("jsonstr", jsonStr);
        }
        params.put("k", k == null ? ConfUtil.appKey() : k);
        return params;
    }

    public byte[] sendPost(String url, String jsonStr) {
        return this.sendPost(url, this.withKey(jsonStr, null));
    }

    public byte[] sendPost(String url, String jsonStr, String k) {
        return this.sendPost(url, this.withKey(jsonStr, k));
    }

    public byte[] sendPost(String url, Map<String, String> params) {
        return this.sendPost(url, null, params);
    }

    public byte[] sendPost(String url, Set<String> cookies, Map<String, String> params) {
        return this.sendPost(url, cookies, params, "UTF-8");
    }

    public byte[] sendPost(String url, Set<String> cookies, Map<String, String> params, String encoding) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConf());
            this.setHeaders((HttpMessage)httpPost, url, cookies, null);
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            httpPost.setEntity((HttpEntity)entity);
            resp = client.execute((HttpUriRequest)httpPost);
            byte[] byArray = this.getStream(this.doResponse(resp));
            this.utils.close((Closeable)resp, (Closeable)client);
            return byArray;
        }
        catch (Exception e) {
            try {
                LOG.error("sendPost...{}", (Object)url);
                throw new FailedException("httpFailed");
            }
            catch (Throwable throwable) {
                this.utils.close((Closeable)resp, (Closeable)client);
                throw throwable;
            }
        }
    }

    private byte[] getStream(HttpEntity entity) throws Exception {
        return entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
    }

    public HttpsService() {
        this.headers.put("Accept", "*/*");
        this.headers.put("Cache-Control", "no-cache");
        this.headers.put("Connection", "keep-alive");
        this.getHeaders = null;
        this.utils = new UtilsService();
    }

    public <T> Map<String, T> ssoPost(String ws, Map<?, ?> params) {
        return this.doPost(this.ssoUrl(ws), this.utils.obj2Str(params), null);
    }

    public <T> Map<String, T> ssoPost(String ws, String jsonStr) {
        return this.doPost(this.ssoUrl(ws), jsonStr, null);
    }

    public <T> Map<String, T> ssoPost(HttpServletRequest req) {
        return this.ssoPost(this.utils.getRequestURI(req), this.utils.jsonParams(req));
    }

    public <T> Map<String, T> forward(HttpServletRequest req) {
        String url = this.mainUrl(this.utils.getRequestURI(req));
        return this.utils.obj2Map(this.forward(req, url));
    }

    public String forward(HttpServletRequest req, String url) {
        String jsonStr = req.getParameter("jsonstr");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jsonstr", jsonStr);
        HashSet<String> cookies = new HashSet<String>();
        Enumeration enu = req.getHeaders("Cookie");
        while (enu.hasMoreElements()) {
            cookies.add((String)enu.nextElement());
        }
        LOG.info("forward with cookies={}", cookies);
        return this.httpPost(url, cookies, params, "UTF-8");
    }

    public <T> Map<String, T> forward(String url, HttpServletRequest req) {
        return this.utils.json2Map(this.forward(req, url));
    }

    public String ssoUrl(String ws) {
        LOG.debug("ssoUrl...{}{}", (Object)ConfUtil.ssoUrl(), (Object)ws);
        return ConfUtil.ssoUrl() + ws;
    }

    public String mainUrl(String ws) {
        if (MAIN_URL == null) {
            MAIN_URL = ConfUtil.appCore() + ConfUtil.appMain();
        }
        return MAIN_URL + ws;
    }

    public <T> Map<String, T> corePost(String ws, Map<?, ?> params) {
        String[] spec = ConfUtil.appSpec();
        if (spec.length > 1) {
            String res = this.httpPost(spec, this.mainUrl(ws), params);
            return this.utils.obj2Map(res);
        }
        return this.doPost(this.mainUrl(ws), params);
    }

    public String httpPost(Map<String, String> host, Map<?, ?> cond) {
        String[] keys = new String[]{"ticket", "spec", "url"};
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = host.get(keys[i]);
        }
        if (this.utils.notEmpty(keys)) {
            String[] spec = new String[]{keys[0], keys[1]};
            return this.httpPost(spec, keys[2], cond);
        }
        return null;
    }

    private String httpPost(String[] spec, String url, Map<?, ?> cond) {
        return this.httpPost(url, this.withSpec(this.utils.obj2Str(cond), spec));
    }

    private Map<String, String> withSpec(String jsonStr, String[] spec) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (jsonStr != null) {
            params.put("ticket", spec[0]);
            params.put("jsonstr", Digest.sm4Encrypt(jsonStr, spec[1]));
        }
        return params;
    }
}

