/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.dao.AolaiDao;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class GmetaService {
    private static Logger LOG = LoggerFactory.getLogger(GmetaService.class);
    static final String META = "GMETA";
    static final String META_SORT = "META_SORT";
    static final String TENANT = "TENANT";
    static final String NUL = "''";
    static final Pattern P_DIGIT = Pattern.compile("\\d+");
    static final Pattern P_QUOTE = Pattern.compile("\\{ *\\w+ *\\}");
    static final Pattern P_PLACE = Pattern.compile("\\{ *V* *\\}");
    static final Pattern P_JSON = Pattern.compile("^,'\\$(\\.\\w+)+'\\)$");
    static final String PKEY = "pkey";
    static final String DUPL = "dupl";
    static final String M_PKEY = "!p";
    static final String M_I18N = "!i";
    static final String M_TYPE = "!t";
    static final String NULL = "null";
    static final String LEFT = "left";
    static final String DEFT = "default";
    static final String WHERE = "where";
    static final String _S = "_";
    static final String _W = "\\w+";
    static final String CAST = "CAST(";
    static final String R_PAREN = "')";
    @Autowired
    AolaiDao dao;
    @Autowired
    RedisService redis;
    @Autowired
    UtilsService utils;
    @Autowired
    HttpServletRequest req;
    @Autowired
    private ApplicationContext appCtx;
    static Map<String, String> gmeta = new HashMap<String, String>();

    boolean isPostgres() {
        return this.appCtx.containsBean("dsPostgres");
    }

    void setDataIsolation(Map<String, Object> cond, String table) {
        if (ConfUtil.dataIsolation()) {
            cond.put(this.tenantKey(table) + "=", this.req.getAttribute(ConfUtil.dbid()));
        }
    }

    String tenantKey(String table) {
        return table + _S + TENANT;
    }

    Map<String, String> addRecord(Object base, String table, Map<String, String> dto, Map<String, Object> data, boolean dupl) {
        base = base == null ? data.get("base") : base;
        data = this.setFieldData(dto, data, true);
        if (ConfUtil.dataIsolation()) {
            data.put(this.tenantKey(table), this.req.getAttribute(ConfUtil.dbid()));
        }
        Map<String, String> map = this.duplCheck(base, table, dto, dupl);
        LOG.debug("addRecord...{}", data);
        return this.utils.result(this.dao.addOne(map, data) > 0);
    }

    private Map<String, String> duplCheck(Object base, String table, Map<String, String> dto, boolean dupl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        if (dupl) {
            map.put(DUPL, this.getDuplPks(table, dto));
        }
        return map;
    }

    private String getDuplPks(String table, Map<String, String> dto) {
        if (!this.isPostgres()) {
            return "";
        }
        return this.getMetaPks(dto, ConfUtil.dataIsolation() ? this.tenantKey(table) : "");
    }

    private String getMetaPks(Map<String, String> dto, String pk) {
        StringJoiner jt = new StringJoiner(",");
        if (pk.length() > 0) {
            jt.add(pk);
        }
        for (Map.Entry<String, String> e : dto.entrySet()) {
            if (!e.getKey().contains(M_PKEY) || !"1".equals(e.getValue())) continue;
            jt.add(dto.get(e.getKey().split("!")[0]));
        }
        return jt.toString();
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(base, table, this.getDto(table), data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(null, table, data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data) {
        return this.addRecord(null, table, data, false);
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data) {
        return this.addRecord(base, table, data, false);
    }

    private Map<String, String> batchAdd(Object base, String table, Map<String, String> dto, List<Map<String, Object>> list, Object lang, boolean dupl) {
        if (list.size() == 0) {
            throw new FailedException();
        }
        Map<String, Object> data = list.get(0);
        base = base == null ? data.get("base") : base;
        data.put("i18n", lang);
        data = this.setFieldData(dto, data, false);
        if (ConfUtil.dataIsolation()) {
            data.put(this.tenantKey(table), TENANT);
        }
        for (Map<String, Object> item : list) {
            for (Map.Entry<String, Object> e : item.entrySet()) {
                this.validationRules(dto, e);
            }
            if (!ConfUtil.dataIsolation()) continue;
            item.put(TENANT, this.req.getAttribute(ConfUtil.dbid()));
        }
        Map<String, String> map = this.duplCheck(base, table, dto, dupl);
        LOG.debug("batchAdd...{}", map);
        return this.utils.result(this.dao.batchAdd(map, data, list) > 0);
    }

    public Map<String, String> batchAdd(Object base, String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(base, table, this.getDto(table), items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map, boolean dupl) {
        return this.batchAdd(map.get("base"), table, items, this.i18n(map), dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map) {
        return this.batchAdd(table, items, map, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(null, table, items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang) {
        return this.batchAdd(null, table, items, lang, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items) {
        return this.batchAdd(table, items, new HashMap<String, Object>());
    }

    public Map<String, String> batchAdd(Map<String, String> map) {
        List<Map<String, Object>> list = this.utils.json2List(map.get("items"));
        boolean dupl = map.containsKey(DUPL);
        return this.batchAdd(this.getBase(map), this.getTable(map), list, this.i18n(map), dupl);
    }

    Map<String, String> delete(Object base, String table, Map<String, String> dto, Map<String, Object> cond, Object joint) {
        if ((cond = this.setCondition(dto, cond, joint)).isEmpty()) {
            throw new FailedException();
        }
        base = base == null ? cond.get("base") : base;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        this.setDataIsolation(cond, table);
        return this.utils.result(this.dao.delete(map, cond) > 0);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> cond, Object joint) {
        return this.delete(base, table, this.getDto(table), cond, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> cond, Object joint) {
        return this.delete(null, table, cond, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> cond) {
        return this.delete(null, table, cond, null);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> cond) {
        return this.delete(base, table, cond, null);
    }

    public Map<String, String> delete(Map<String, String> params) {
        Map<String, Object> cond = this.utils.json2Map(params.get(WHERE));
        return this.delete(this.getBase(params), this.getTable(params), cond);
    }

    Map<String, String> batchDelete(Object base, String table, Map<String, String> dto, List<Map<String, Object>> list, String joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> cond = this.setCondition(dto, list.get(i), joint);
            if (cond.isEmpty()) continue;
            this.setDataIsolation(cond, table);
            count += this.dao.delete(map, cond);
        }
        return this.utils.result(count > 0);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list) {
        return this.batchDelete(base, table, this.getDto(table), list, null);
    }

    public Map<String, String> batchDelete(Object base, String table, Object cond) {
        String whr = String.valueOf(cond);
        return this.batchDelete(base, table, this.utils.json2List(whr));
    }

    public Map<String, String> batchDelete(String table, List<Map<String, Object>> list) {
        return this.batchDelete(null, table, list);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list, String joint) {
        return this.batchDelete(base, table, this.getDto(table), list, joint);
    }

    public Map<String, String> batchDelete(String table, Object cond) {
        return this.batchDelete(null, table, cond);
    }

    public Map<String, String> batchDelete(Map<String, Object> params) {
        if (params == null) {
            return this.utils.result(false);
        }
        String table = String.valueOf(params.get("table"));
        return this.batchDelete(params.get("base"), table, params.get(WHERE));
    }

    private Map<String, String> update(Object base, String table, Map<String, String> dto, Map<String, ?> fields, Map<String, Object> cond, Object joint) {
        cond = this.setCondition(dto, cond, joint);
        fields = this.setCondition(dto, fields, null);
        if (cond.isEmpty() || fields.isEmpty()) {
            throw new FailedException();
        }
        base = base == null ? cond.get("base") : base;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        this.setDataIsolation(cond, table);
        return this.utils.result(this.dao.update(map, fields, cond) > 0);
    }

    public Map<String, String> update(Object base, String table, Map<String, ?> fields, Map<String, Object> cond, Object joint) {
        return this.update(base, table, this.getDto(table), fields, cond, joint);
    }

    public Map<String, String> update(Object base, String table, Map<String, ?> fields, Map<String, Object> cond) {
        return this.update(base, table, fields, cond, null);
    }

    public Map<String, String> update(String table, Map<String, ?> fields, Map<String, Object> cond, Object joint) {
        return this.update(null, table, fields, cond, joint);
    }

    public Map<String, String> update(String table, Map<String, ?> fields, Map<String, Object> cond) {
        return this.update(null, table, fields, cond, null);
    }

    public Map<String, String> update(Map<String, String> map, Object lang) {
        Map fields = this.utils.json2Map(map.get("fields"));
        Map<String, Object> cond = this.utils.json2Map(map.get(WHERE));
        fields.put("i18n", lang);
        cond.put("i18n", lang);
        return this.update(this.getBase(map), this.getTable(map), fields, cond);
    }

    public <T> List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String limit) {
        return this.findList(base, tables, uriKey, cond, sort, LEFT, limit);
    }

    public <T> List<Map<String, T>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> cond, Map<String, String> sort, String left, String limit) {
        Map<String, String> dto;
        String[] table = this.joinTables(base = base == null ? cond.get("base") : base, dto = this.getMetaDto(base, uriKey), tables, left);
        if (table == null) {
            return new ArrayList<Map<String, T>>();
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", table[1]);
        args.put("alias", uriKey);
        args.put("limit", limit);
        cond = this.setArgsAndCond(args, dto, cond, sort);
        this.setDataIsolation(cond, table[0]);
        return this.dao.findList(args, cond);
    }

    String[] joinTables(Object base, Map<String, String> dto, Map<String, Map<String, String>> tables, String left) {
        String[] stringArray;
        if (tables == null) {
            return null;
        }
        String dbid = this.utils.sqlVal(this.req.getAttribute(ConfUtil.dbid()));
        String table = null;
        String T0 = null;
        String T = null;
        StringJoiner jt = new StringJoiner(" ", " ", "");
        for (String key : tables.keySet()) {
            Map<String, String> cond = tables.get(key);
            table = this.getTable(base, key);
            if (this.utils.isEmpty(cond)) {
                T0 = table;
                T = key;
                continue;
            }
            if (!this.utils.isEmpty(left)) {
                jt.add(left);
            }
            jt.add("join").add(table).add("on");
            if (ConfUtil.dataIsolation()) {
                jt.add(this.tenantKey(key) + "=" + dbid);
            }
            int n = 0;
            for (Map.Entry<String, String> e : cond.entrySet()) {
                String val = e.getValue();
                if (val == null) continue;
                if (n++ > 0 || ConfUtil.dataIsolation()) {
                    jt.add("and");
                }
                val = dto.containsKey(val) ? this.i18n(dto, val, null) : (this.utils.isMatch(val, _W) ? this.utils.sqlVal(val) : NUL);
                jt.add(this.i18n(dto, e.getKey(), null) + "=" + val);
            }
        }
        if (T == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = T;
            stringArray = stringArray2;
            stringArray2[1] = T0 + jt.toString();
        }
        return stringArray;
    }

    private void setLimitRows(Map<String, String> args, Map<String, Object> cond) {
        String[] keys = new String[]{"pageNo", "pageSize"};
        if (this.utils.availParams(cond, keys)) {
            int pNo = this.utils.getInt(cond, keys[0]);
            int pSize = this.utils.getInt(cond, keys[1]);
            args.put("floor", String.valueOf((pNo - 1) * pSize));
            args.put("limit", String.valueOf(pSize));
            return;
        }
        String limit = args.get("limit");
        if (!this.utils.isInteger(limit)) {
            args.put("limit", ConfUtil.limitRows());
        } else if ("0".equals(limit)) {
            args.remove("limit");
        }
    }

    Map<String, Object> setArgsAndCond(Map<String, String> args, Map<String, String> dto, Map<String, Object> cond, Map<String, String> sort) {
        Object lang = this.i18n(cond);
        args.put("alias", this.setAlias(dto, args.get("alias"), lang));
        args.put("order", this.orderBy(dto, sort, lang));
        this.setLimitRows(args, cond);
        return this.setCondition(dto, cond, args.get("joint"));
    }

    public <T> List<Map<String, T>> findList(Map<String, String> args, Map<String, Object> cond, Map<String, String> sort) {
        String table = this.getTable(args);
        Map<String, String> dto = this.getDto(table);
        Object base = this.getBase(args);
        base = base == null ? cond.get("base") : base;
        args.put("table", this.getTable(base, table));
        cond = this.setArgsAndCond(args, dto, cond, sort);
        this.setDataIsolation(cond, table);
        return this.dao.findList(args, cond);
    }

    public <T> List<Map<String, T>> findList(Map<String, String> args, Map<String, Object> cond) {
        return this.findList(args, cond, null);
    }

    public <T> List<Map<String, T>> findList(Object base, String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        String db = base == null ? null : String.valueOf(base);
        return this.findAll(cond, sort, new String[]{db, table, uriKey});
    }

    public <T> List<Map<String, T>> findAll(Object base, String table, String uriKey, Map<String, Object> cond, Map<String, String> sort) {
        String db = base == null ? null : String.valueOf(base);
        String[] args = new String[]{db, table, uriKey, "0"};
        return this.findAll(cond, sort, args);
    }

    public <T> List<Map<String, T>> findList(Object base, String table, String uriKey, Map<String, Object> cond) {
        return this.findList(base, table, uriKey, cond, null);
    }

    public <T> List<Map<String, T>> findAll(Object base, String table, String uriKey, Map<String, Object> cond) {
        return this.findAll(base, table, uriKey, cond, null);
    }

    public <T> List<Map<String, T>> findList(String table, String uriKey, Map<String, Object> cond) {
        return this.findList(null, table, uriKey, cond, null);
    }

    public <T> List<Map<String, T>> findAll(String table, String uriKey, Map<String, Object> cond) {
        return this.findAll(null, table, uriKey, cond, null);
    }

    public <T> List<Map<String, T>> findList(String table, Map<String, Object> cond) {
        return this.findList(table, null, cond);
    }

    public <T> List<Map<String, T>> findAll(String table, Map<String, Object> cond) {
        return this.findAll(table, null, cond);
    }

    Map<String, String> convertArgs(String[] params) {
        if (params == null || params.length < 2) {
            return null;
        }
        String[] keys = new String[]{"base", "table", "alias", "limit"};
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < params.length && i < keys.length; ++i) {
            args.put(keys[i], params[i]);
        }
        return args;
    }

    public <T> List<Map<String, T>> findAll(Map<String, Object> cond, Map<String, String> sort, String[] params) {
        Map<String, String> args = this.convertArgs(params);
        return args == null ? new ArrayList<Map<String, T>>() : this.findList(args, cond, sort);
    }

    private Map<String, String> findOne(Object base, String table, Map<String, String> dto, Map<String, Object> cond, String uriKey) {
        base = base == null ? cond.get("base") : base;
        Map<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("alias", this.setAlias(dto, uriKey, this.i18n(cond)));
        cond = this.setCondition(dto, cond, null);
        this.setDataIsolation(cond, table);
        map = this.dao.findOne(map, cond);
        return this.utils.isEmpty(map) ? this.utils.result(false) : map;
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> cond, String uriKey) {
        return this.findOne(base, table, this.getDto(table), cond, uriKey);
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> cond) {
        return this.findOne(base, table, cond, null);
    }

    public Map<String, String> findOne(String table, Map<String, Object> cond, String uriKey) {
        return this.findOne(null, table, cond, uriKey);
    }

    public Map<String, String> findOne(String table, Map<String, Object> cond) {
        return this.findOne(null, table, cond, null);
    }

    public Map<String, String> findOne(Map<String, String> map, String uriKey) {
        Map<String, Object> cond = this.utils.json2Map(map.get(WHERE));
        return this.findOne(this.getBase(map), this.getTable(map), cond, uriKey);
    }

    public Map<String, String> findOne(Map<String, String> map) {
        return this.findOne(map, null);
    }

    private boolean exists(Object base, String table, Map<String, String> dto, Map<String, Object> cond, Object joint) {
        base = base == null ? cond.get("base") : base;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        cond = this.setCondition(dto, cond, joint);
        this.setDataIsolation(cond, table);
        return this.dao.countRows(map, cond) > 0;
    }

    public boolean exists(Object base, String table, Map<String, Object> cond, Object joint) {
        return this.exists(base, table, this.getDto(table), cond, joint);
    }

    public boolean exists(Object base, String table, Map<String, Object> cond) {
        return this.exists(base, table, cond, null);
    }

    public boolean exists(String table, Map<String, Object> cond, Object joint) {
        return this.exists(null, table, cond, joint);
    }

    public boolean exists(String table, Map<String, Object> cond) {
        return this.exists(null, table, cond, null);
    }

    public boolean exists(Map<String, String> map) {
        Map<String, Object> cond = this.utils.json2Map(map.get(WHERE));
        return this.exists(this.getBase(map), this.getTable(map), cond);
    }

    public int count(String table, Map<String, Object> cond) {
        return this.count(null, table, cond, null);
    }

    public int count(Object base, String table, Map<String, Object> cond) {
        return this.count(base, table, cond, null);
    }

    public int count(Object base, String table, Map<String, Object> cond, String joint) {
        base = base == null ? cond.get("base") : base;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", this.getTable(base, table));
        cond = this.setCondition(this.getDto(table), cond, joint);
        this.setDataIsolation(cond, table);
        return this.dao.countRows(args, cond);
    }

    private Map<String, String> cacheActionRole(Map<String, Object> map) {
        map.put("alias", this.setAlias("ACTION", null));
        List<Map<String, String>> list = this.dao.getActionRole(map);
        Map<String, String> actMap = this.utils.list2Map(list, "actUri", "actState");
        if (!actMap.isEmpty()) {
            Object[] keys = new Object[]{map.get("appCode"), map.get("compId"), map.get("dutyId")};
            String key = this.utils.join(keys, ".");
            this.redis.setActionRole(key, actMap);
            LOG.debug("cacheActionRole...{}", actMap);
        }
        return actMap;
    }

    public List<Map<String, String>> getMenuRole(Map<String, Object> params) {
        if (this.utils.isEmpty(params)) {
            return new ArrayList<Map<String, String>>();
        }
        this.cacheActionRole(params);
        params.put("alias", this.getAlias("getMenuRole", this.i18n(params)));
        List<Map<String, String>> list = this.dao.getMenuRole(params);
        this.mergeMenuRole(list);
        return list;
    }

    public Map<String, Object> getRoleParams(Map<String, Object> params, Map<String, String> user) {
        Map<String, Object> map = this.utils.newCond(params);
        Object appCode = params.get("appCode");
        if (appCode != null) {
            map.put("compId", user.get("userComp"));
            Map uDuty = this.utils.json2Map(user.get("userDuty"));
            if (uDuty.containsKey(appCode)) {
                map.put("dutyId", uDuty.get(appCode));
                map.put("appCode", appCode);
            }
        }
        return map;
    }

    private Map<String, String> mergeMenuRole(List<Map<String, String>> list) {
        String[] keys = new String[]{"pageId", "pageRoute", "roleAction"};
        if (list.size() == 1) {
            return this.utils.list2Map(list, keys[1], keys[2]);
        }
        HashMap<String, String> menu = new HashMap<String, String>();
        for (int i = list.size() - 1; i > 0; --i) {
            Map<String, String> tmp0 = list.get(i);
            Map<String, String> tmp1 = list.get(i - 1);
            String page0 = tmp0.get(keys[0]);
            String page1 = tmp1.get(keys[0]);
            int ra = Integer.valueOf(tmp0.get(keys[2]));
            if (page1.equals(page0)) {
                ra = Integer.valueOf(tmp1.get(keys[2])) | ra;
                tmp1.put(keys[2], String.valueOf(ra));
                list.remove(i);
            } else {
                menu.put(tmp0.get(keys[1]), tmp0.get(keys[2]));
            }
            if (i != 1) continue;
            menu.put(tmp1.get(keys[1]), tmp1.get(keys[2]));
        }
        return menu;
    }

    public Map<String, String> setParam(Map<String, Object> params) {
        Map<String, Object> cond = this.utils.newCond(params);
        cond.put("paramBb", params.get("kmbb"));
        cond.put("paramKey", params.get("paramKey"));
        return this.update(params.get("base"), "PARAM", params, cond);
    }

    private String getParam(Object base, Object kmbb, Object key) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("paramKey", key);
        cond.put("paramBb", kmbb == null ? "00" : kmbb);
        return this.findOne(base, "PARAM", cond, "").get("paramVal");
    }

    public String getParam(Map<String, ?> cond, Object key) {
        return this.getParam(this.getBase(cond), cond.get("kmbb"), key);
    }

    public List<Map<String, String>> getParams(Map<String, Object> cond) {
        return this.findList(this.getBase(cond), "PARAM", "", cond);
    }

    private String i18n(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        if (dto.containsKey(key + M_I18N)) {
            return this.utils.isEmpty(lang) ? NUL : field + _S + lang;
        }
        return field;
    }

    private <T> Object i18n(Map<String, T> params) {
        return params == null ? null : params.get("i18n");
    }

    private String orderBy(Map<String, String> dto, Map<String, String> sort, Object lang) {
        if (this.utils.isEmpty(sort)) {
            return this.getMetaPks(dto, "");
        }
        StringJoiner jt = new StringJoiner(",");
        for (Map.Entry<String, String> e : sort.entrySet()) {
            if (!dto.containsKey(e.getKey())) continue;
            String key = this.i18n(dto, e.getKey(), lang);
            String val = e.getValue();
            jt.add(this.utils.isEmpty(val) ? key : key + " " + val);
        }
        return jt.toString();
    }

    private <T> Map<String, T> setCondition(Map<String, String> dto, Map<String, T> map, Object joint) {
        LinkedHashMap<String, T> cond = new LinkedHashMap<String, T>();
        if (map == null) {
            return cond;
        }
        Object lang = this.i18n(map);
        for (Map.Entry<String, T> e : map.entrySet()) {
            T val = e.getValue();
            if (val == null) continue;
            String key = e.getKey();
            if (dto.containsKey(key)) {
                this.validationRules(dto, e);
                key = this.i18n(dto, key, lang);
                key = key + (joint == null ? "=" : " " + joint);
                cond.put(key, val);
                continue;
            }
            if (!P_QUOTE.matcher(key).find()) continue;
            boolean noneVar = P_PLACE.matcher(key).find();
            if ((key = this.getFieldKey(dto, key, val, lang)) == null) continue;
            cond.put(key, noneVar ? null : (Object)val);
        }
        LOG.debug("setCondition...{}", (Object)this.utils.obj2Str(cond));
        return cond;
    }

    public String getWhere(Map<String, String> dto, String expr, Object lang) {
        return this.getFieldKey(dto, expr, new String[0], lang);
    }

    private <T> String getFieldKey(Map<String, String> dto, String expr, T valArr, Object lang) {
        String[] vArr;
        String[] arr = expr.split("\\{ *");
        int v = 0;
        boolean isArr = valArr.getClass().isArray();
        String[] stringArray = vArr = isArr ? (String[])valArr : new String[]{};
        if (arr.length > 1 && this.isValidExpr(arr[0])) {
            for (int i = 1; i < arr.length; ++i) {
                String[] key = arr[i].split(" *\\}");
                if (key.length == 0) {
                    if (vArr.length <= v) continue;
                    arr[i] = vArr[v++];
                    continue;
                }
                if (dto.containsKey(key[0])) {
                    arr[i] = this.i18n(dto, key[0], lang);
                    if (key.length <= 1 || !this.isValidExpr(key[1])) continue;
                    int n = i;
                    arr[n] = arr[n] + key[1];
                    continue;
                }
                if (vArr.length <= v || !"".equals(key[0]) && !"V".equals(key[0])) continue;
                arr[i] = vArr[v++] + (key.length > 1 ? key[1] : "");
            }
            return this.utils.join(arr);
        }
        return null;
    }

    private boolean isValidExpr(String expr) {
        if (expr.length() > 0) {
            String[] arr;
            for (String str : arr = expr.split(" +")) {
                if (str.length() == 0 || this.utils.findIn(ConfUtil.SQL_EXPR, (Object)str.toLowerCase()) || P_JSON.matcher(str).find()) continue;
                LOG.error("invalid expr...{}", (Object)str);
                throw new FailedException();
            }
        }
        return true;
    }

    private Map<String, Object> setFieldData(Map<String, String> dto, Map<String, Object> params, boolean isValue) {
        if (params != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            Object lang = this.i18n(params);
            for (Map.Entry<String, Object> e : params.entrySet()) {
                if (!dto.containsKey(e.getKey())) continue;
                String key = this.i18n(dto, e.getKey(), lang);
                if (isValue && this.validationRules(dto, e)) {
                    data.put(key, e.getValue());
                    continue;
                }
                data.put(key, e.getKey());
            }
            if (!data.isEmpty()) {
                return data;
            }
        }
        throw new FailedException();
    }

    private boolean validationRules(Map<String, String> dto, Map.Entry<String, ?> e) {
        if (ConfUtil.avoidRules()) {
            return true;
        }
        String type = dto.get(e.getKey() + M_TYPE);
        if (type == null) {
            return false;
        }
        String str = String.valueOf(e.getValue());
        Matcher matcher = P_DIGIT.matcher(type);
        if (matcher.find()) {
            if (Integer.parseInt(matcher.group()) >= str.length()) {
                return true;
            }
        } else if (type.contains("IN")) {
            if (this.utils.isInteger(str)) {
                return true;
            }
        } else {
            if (type.contains("J")) {
                return true;
            }
            if (type.contains("T")) {
                if (this.utils.isDatetime(str, "yyyy-MM-dd HH:mm:ss")) {
                    return true;
                }
            } else if (type.contains("L")) {
                if (this.utils.isNumeric(str)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String key = String.join((CharSequence)_S, "invalidParams", e.getKey());
        throw new FailedException(key);
    }

    public String setAlias(String table, Object lang) {
        return this.setAlias(table, null, lang);
    }

    public String setAlias(String table, String uriKey, Object lang) {
        return this.setAlias(this.getDto(table), uriKey, lang);
    }

    private String setAlias(Map<String, String> dto, String uriKey, Object lang) {
        if (ConfUtil.isCustomCols() || this.utils.isEmpty(uriKey)) {
            return this.fieldAsAlias(dto, lang);
        }
        String val = ConfUtil.getParam(uriKey);
        if (val.length() == 0) {
            return this.fieldAsAlias(dto, lang);
        }
        return this.fieldAsAlias(dto, val.split(",|;"), lang);
    }

    private String fieldAsAlias(Map<String, String> dto, String[] arr, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (String key : arr) {
            jt.add(this.fieldAsAlias(dto, key, lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (String key : dto.keySet()) {
            if (key.contains("!")) continue;
            jt.add(this.fieldAsAlias(dto, key, lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        String type = dto.get(key + M_TYPE);
        String keyStr = this.utils.quote(key, "\"");
        if (type != null) {
            if (type.matches("[IJSBD].+") || type.contains("IN")) {
                field = this.isPostgres() ? CAST + field + " as TEXT)" : CAST + field + " as CHAR)";
            } else if (type.matches("T.+")) {
                field = this.isPostgres() ? "to_char(" + field + ",'yyyy-MM-dd hh24:mi:ss" + (type.length() > 9 ? ".ms" : "") + R_PAREN : "DATE_FORMAT(" + field + ",'%Y-%m-%d %T" + (type.length() > 9 ? ".%f" : "") + R_PAREN;
            } else if (dto.containsKey(key + M_I18N)) {
                field = this.utils.isEmpty(lang) ? NUL : field + _S + lang;
            }
        } else if (field == null) {
            field = NUL;
        }
        return String.join((CharSequence)" ", field, "as", keyStr);
    }

    public String getAlias(String uriKey, Object lang) {
        return this.getAlias(null, uriKey, lang);
    }

    private String getAlias(Object base, String uriKey, Object lang) {
        return this.fieldAsAlias(this.getMetaDto(base, uriKey), lang);
    }

    public String getField(String table, Object lang) {
        return this.fieldAsAlias(this.getDto(table), lang);
    }

    private Map<String, String> getFields(String table, String[] keyArr, Object lang) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyArr != null) {
            Map<String, String> dto = this.getDto(table);
            for (String key : keyArr) {
                if (!dto.containsKey(key)) continue;
                map.put(key, this.i18n(dto, key, lang));
            }
        }
        return map;
    }

    Map<String, String> getDto(String table) {
        String rk = "m." + table;
        String dtoStr = this.redis.get(rk);
        if (dtoStr == null) {
            dtoStr = this.utils.obj2Str(this.getDto(this.getTableMeta(table)));
            this.redis.set(rk, dtoStr, 7200);
        }
        return this.utils.json2Map(dtoStr);
    }

    Map<String, String> getMetaDto(Object base, String uriKey) {
        boolean isCustom = ConfUtil.isCustomCols();
        String rk = "m." + (isCustom ? base : "") + uriKey;
        Map<String, String> dto = this.redis.hmget(rk);
        if (dto == null) {
            dto = isCustom ? this.getDto(this.getMeta(this.getFieldList(base, uriKey))) : this.getDto(this.getMeta(uriKey));
            this.redis.hmset(rk, dto, 36000);
        }
        return dto;
    }

    public List<Map<String, String>> getFieldList(Object base, String uriKey) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("fieldUri", uriKey);
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("fieldSort", "ASC");
        return this.findList(base, "FIELD", null, cond, sort);
    }

    private Map<String, String> getDto(List<Map<String, String>> metaList) {
        LinkedHashMap<String, String> dto = new LinkedHashMap<String, String>();
        for (int i = 0; i < metaList.size(); ++i) {
            Map<String, String> meta = metaList.get(i);
            String alias = meta.get("alias");
            dto.put(alias, meta.get("field"));
            dto.put(alias + M_TYPE, meta.get("type"));
            dto.put(alias + M_PKEY, meta.get(PKEY));
            if (!"1".equals(meta.get("i18n"))) continue;
            dto.put(alias + M_I18N, meta.get("i18n"));
        }
        if (dto.isEmpty()) {
            throw new FailedException();
        }
        return dto;
    }

    public List<Map<String, String>> getMeta(String uriKey) {
        String val = ConfUtil.getParam(uriKey);
        String[] keys = val.length() == 0 ? null : val.split(",|;");
        return this.getMeta(keys);
    }

    private List<Map<String, String>> getMeta(List<Map<String, String>> fieldList) {
        String[] keys = new String[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            keys[i] = fieldList.get(i).get("fieldAlias");
        }
        return this.getMeta(keys);
    }

    private List<Map<String, String>> getMeta(String[] keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(null, META));
        map.put("alias", this.fieldAsAlias(gmeta, null));
        return this.dao.getMeta(map, keys);
    }

    public List<Map<String, String>> getMetaList(String table) {
        return this.getTableMeta(table);
    }

    public List<Map<String, String>> getTableMeta(Object table) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(null, META));
        map.put("alias", this.fieldAsAlias(gmeta, null));
        map.put("order", META_SORT);
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("META_TABLE=", table);
        return this.dao.findList(map, cond);
    }

    public String getTable(Object base, String table) {
        if (this.isPostgres()) {
            if (base != null && !ConfUtil.dataIsolation()) {
                table = base + table;
                String db = String.valueOf(base);
                if (db.charAt(db.length() - 1) == '.') {
                    return table;
                }
            }
            CharSequence[] keys = new String[]{ConfUtil.baseMain(), table};
            return String.join((CharSequence)".", keys);
        }
        return base == null ? table : base + table;
    }

    private String getTable(Map<String, String> params) {
        return params.get("table");
    }

    private <T> Object getBase(Map<String, T> params) {
        return params.get("base");
    }

    public int getMaxCode(Object base, String table, String field) {
        return this.getMaxCode(base, table, field, null);
    }

    public int getMaxCode(Object base, String table, String field, Map<String, Object> cond) {
        String mv = this.getMaxValue(base, table, field, cond);
        return Integer.parseInt(mv) + 1;
    }

    public String getMaxValue(Object base, String table, String field) {
        return this.getMaxValue(base, table, field, null);
    }

    public String getMaxValue(Object base, String table, String field, Map<String, Object> cond) {
        return this.getMValue(base, table, field, cond, "MAX(");
    }

    public String getMinValue(Object base, String table, String field) {
        return this.getMinValue(base, table, field, null);
    }

    public String getMinValue(Object base, String table, String field, Map<String, Object> cond) {
        return this.getMValue(base, table, field, cond, "MIN(");
    }

    public String sumTotal(Object base, String table, String field, Map<String, Object> cond) {
        return this.getMValue(base, table, field, cond, "SUM(");
    }

    public String sumTotal(Object base, String table, String field) {
        return this.getMinValue(base, table, field, null);
    }

    private String getMValue(Object base, String table, String field, Map<String, Object> cond, String max) {
        Map<String, String> dto = this.getDto(table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", CAST + max + dto.get(field) + ") AS CHAR)");
        cond = this.setCondition(dto, cond, null);
        this.setDataIsolation(cond, table);
        return this.dao.getMValue(map, cond);
    }

    public List<Map<String, String>> groupCount(Object base, String table, String[] keys, Map<String, Object> cond) {
        Map<String, String> dto = this.getDto(table);
        Map<String, String> map = this.getFields(table, keys, null);
        cond = this.setCondition(dto, cond, null);
        this.setDataIsolation(cond, table);
        return this.dao.groupCount(this.getTable(base, table), map, cond);
    }

    static {
        gmeta.put("field", "META_FIELD");
        gmeta.put("alias", "META_ALIAS");
        gmeta.put("name", "META_NAME");
        gmeta.put("type", "META_TYPE");
        gmeta.put(NULL, "META_NULL");
        gmeta.put("i18n", "META_I18N");
        gmeta.put(PKEY, "META_PKEY");
        gmeta.put("width", "META_WIDTH");
        gmeta.put(DEFT, "META_DEFAULT");
        gmeta.put("sort", META_SORT);
    }
}

