package cn.ps1.aolai.utils;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * 通过IOC容器，映射ApplicationContext，并在应用中任意获取指定的Bean
 * 
 * @author Aolai
 * @version 1.0
 *
 */
@Component
public class SpringContext implements ApplicationContextAware {

	private static ApplicationContext appCtx = null;
	private static SpringContext myself = null;

	public synchronized static SpringContext init() {
		if (myself == null) {
			myself = new SpringContext();
		}
		return myself;
	}

	@Override
	public void setApplicationContext(ApplicationContext ctx)
			throws BeansException {
		if (appCtx == null) {
			appCtx = ctx;
			ConfUtil.initGconf();
		}
	}

	// 获取appCtx上下文
	public static ApplicationContext getApplicationContext() {
		return appCtx;
	}

	// 通过name获取 Bean.
	public synchronized static Object getBean(String beanName) {
		return appCtx.getBean(beanName);
	}

	// 通过class获取Bean.
	public synchronized static <T> T getBean(Class<T> clazz) {
		return appCtx.getBean(clazz);
	}

	// 通过name,以及Clazz返回指定的Bean
	public synchronized static <T> T getBean(String name, Class<T> clazz) {
		return appCtx.getBean(name, clazz);
	}

}
