package cn.ps1.aolai.utils;

/**
 * 这里为了事务控制，抛出异常触发回滚
 * 
 * @author Aolai
 * @since 2023/3/26
 */
public class FailedException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * 无效的请求参数，仅理论上程序测试阶段有此提示
	 */
	public FailedException() {
		super(ConfUtil.INVD_PARAMS); // 无效的请求参数
	}

	/**
	 * 系统自定义的其他例外
	 * 
	 * @param msgCode
	 */
	public FailedException(String msgCode) {
		super(msgCode); // 系统定义的其他参数
	}

	/**
	 * 自定义组合参数，如：invalidParams_userComp
	 */
	public FailedException(String msg, String field) {
		super(String.join("_", "".equals(msg) ? ConfUtil.INVD_PARAMS : msg,
				field));
	}

}
