package cn.ps1.aolai.utils;

/**
 * 全局静态变量的总集合
 * 
 * @author Aolai
 *
 */
public class Const {

	/** 推荐直接用 StandardCharsets.UTF_8 */

	/** 字符集转换，默认UTF-8 */
	public static final String UTF8 = "UTF-8";

	/** 常用的常量：info */
	public static final String INFO = "info";
	/** 常用的常量：base */
	public static final String BASE = "base";
	/** 常用的常量：json */
	public static final String JSON = "json";
	/** 常用的常量：i18n */
	public static final String I18N = "i18n";
	/** 常用的常量：like */
	public static final String LIKE = "like";
	/** 常用的常量：sort */
	public static final String SORT = "sort";
	/** 常用的常量：name */
	public static final String NAME = "name";
	/** 常用的常量：type */
	public static final String TYPE = "type";

	/** 数据版本 */
	public static final String KMBB = "kmbb";
	/** EXCEL文件 */
	public static final String XLSX = "xlsx";
	/** 数据列表 */
	public static final String ROWS = "rows";
	/** 编辑 */
	public static final String EDIT = "edit";
	/** 新增 */
	public static final String ADD = "add";
	/** EXCEL文件 */
	public static final String XLS = "xls";

	/** SQL中的别名映射 */
	public static final String AS = "as";
	/** SQL中的包含 */
	public static final String IN = "in";

	/** 约定表名 */
	public static final String TABLE = "table";
	/** 字段别名 */
	public static final String ALIAS = "alias";
	/** 字段名称 */
	public static final String FIELD = "field";
	/** 限定行数 */
	public static final String LIMIT = "limit";
	/** 定义连接符 */
	public static final String JOINT = "joint";
	/** 排序 */
	public static final String ORDER = "order";
	/** 数据集 */
	public static final String ITEMS = "items";
	/** 数据总数 */
	public static final String TOTAL = "total";
	/** 宽度 */
	public static final String WIDTH = "width";

	/** 插入：insert */
//	public static final String INSERT = "insert";
	/** 状态：status */
	public static final String STS = "status";
	/** 状态：status_0 */
	public static final String STR_0 = "0";
	/** 状态：status_1 */
	public static final String STR_1 = "1";
	/** 状态：status_2 */
	public static final String STR_2 = "2";
	/** JSON状态：val='1' */
	public static final String VAL_1 = "'1'";

	/** 特殊字符 */

	/** 字符串："0" */
	public static final String S_0 = "0";
	/** 字符串："1" */
	public static final String S_1 = "1";
	/** 字符串："2" */
	public static final String S_2 = "2";
	/** JSON状态：val='1' */
	public static final String V_1 = "'1'";

	/** 冒号 */
	public static final String COLON = ":";
	/** 逗号 */
	public static final String COMMA = ",";
	/** 小数点 */
	public static final String DOT = ".";
	/** 等于 = */
	public static final String EQU = "=";
	/** 不等于!= */
	public static final String NEQ = "!=";
	/** 全部 all */
	public static final String ALL = "all";

	/** 简单月份 */
	public static final String MON = "yyyyMM";
	/** 简单日期：yyyyMMdd */
	public static final String DAY = "yyyyMMdd";
	/** 简单日期：SimpleDateFormat */
	public static final String SDF = "yyyy-MM-dd";
	/** 时分秒：DateTimeFormat */
	public static final String DTF = "yyyy-MM-dd HH:mm:ss";
	/** 毫秒 */
	public static final String MSEC = "yyyy-MM-dd HH:mm:ss.SSS";

	/** 缓存有效期：1天=24小时=86400秒 */
	public static final int ONE_DD = 86400;
	/** 缓存有效期：10小时=3600秒 */
	public static final int TEN_HH = 36000;
	/** 缓存有效期：2小时=7200秒 */
	public static final int TWO_HH = 7200;
	/** 缓存有效期：1小时=3600秒 */
	public static final int ONE_HH = 3600;
	/** 缓存有效期：10分钟=600秒 */
	public static final int TEN_MM = 600;
	/** 缓存有效期：2分钟=120秒 */
	public static final int TWO_MM = 120;
	/** 缓存有效期：1分钟=60秒 */
	public static final int ONE_MM = 60;
	
	/** 1. 授权(Auth)的 AppId应用 */
	public static final String RDS_APPID = "a."; // 授权访问的ticket
	/** 2. 账套(base) */
	public static final String RDS_BASE = "b."; // 数据库分库
	/** 3. 公司(company) */
	public static final String RDS_COMP = "c."; // 公司
	/** 4. 拒绝(deny)的IP地址 */
	public static final String RDS_DENY = "d."; // 阻止IP访问（验证码防黑客）
	/** 标记(flag) */
	public static final String RDS_FLAG = "f."; // 标记=1
	/** 6. 通行证(certKey) */
	public static final String RDS_CERT = "k."; // certKey
	/** 7. 登录失败(loss)次数 */
	public static final String RDS_LOSS = "L."; // 登录失败次数（防暴力破解）
	/** 用以缓存客户端的IP地址(ipAddress) */
	public static final String RDS_ADDR = "i.";
	/** 9. 元数据(meta) */
	public static final String RDS_META = "m."; // 元数据表结构（频繁调用的DTO）
	/** 组织(organize) */
	public static final String RDS_ORGN = "o.";
	/** 页面控制(page) */
	public static final String RDS_PAGE = "p.";  // 缓存的页面权限
	/** 12. 页面权限控制(role) */
	public static final String RDS_ROLE = "r.";  // 缓存的页面权限
	/** 13. 缓存的 Token信息 */
	public static final String RDS_TOKEN = "t."; // 当前 Token信息
	/** 14. 用户信息(userInfo) */
	public static final String RDS_USER = "u."; // 当前用户信息
	/** 15. 验证码(verification code) */
	public static final String RDS_CODE = "v."; // 随机动态码

}
