package cn.ps1.aolai.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 全局通用的配置参数类（config.properties）
 * 
 * @author Aolai
 * @since 1.7 $Date: 2017.6.17
 * @version 1.0
 */

public class ConfUtil {

	private static Logger LOG = LoggerFactory.getLogger(ConfUtil.class);

	/** 以下为系统约定的全局变量定义及默认配置 */

	/** 应用的配置文件：config.properties */
	private static ResourceBundle CONF = ResourceBundle.getBundle("config");
	/** 前台传递的参数：config.properties */
	private static ResourceBundle PARAM = ResourceBundle.getBundle("params");
	/** 需要校验的参数：config.properties */
	private static ResourceBundle VALID = ResourceBundle.getBundle("valid");

	/** 数据库中（GCONF表中）的参数配置 */
	private static Map<String, String> GCONF = new HashMap<>();

	/** 约定为 “jsonstr”字符串 */
	public static final String JSONSTR = "jsonstr";
	/** 主键：“appCode” */
	public static final String APPCODE = "appCode";
	/** 保存在token中的客户端的IP地址的主键“ipaddr” */
	public static final String IPADDR = "ipaddr";
	/** “ticket” */
	public static final String TICKET = "ticket";
	/** “token” */
	public static final String TOKEN = "token";

	/** 前端传递的k参数，注意与certKey区别，与RDS_CERT无关 */
	public static final String CERT_K = "k";
	/** 分隔符",|;" */
	public static final String COMMA = ",|;";
	/** 跟踪编号 */
	public static final String TRACEID = "traceId";
	/** 证书编号 */
	public static final String CERTID = "certId";
	/** 公司编号 */
	public static final String COMPID = "compId";
	/** 用户编号 */
	public static final String USERID = "userId";

	/** 无效的参数 */
	public static final String INVD_PARAMS = "invalidParams";	
	/** 不能删除 */
	public static final String CANT_REMOVE = "cantRemove";	
	/** 不能更新 */
	public static final String CANT_UPDATE = "cantUpdate";	
	/** 超数量限制 */
	public static final String OVER_COUNTS = "overCounts";	
	/** 越权访问 */
	public static final String DENY_ACCESS = "denyAccess";	
	/** 重复命名 */
	public static final String DUPL_NAME = "duplicateName";

	/** 重复数据 */
	public static final String DUPL_DATA = "dataDuplicate";
	/** 数据并发冲突 */
	public static final String DATA_COLL = "dataCollision";

	/**
	 * 以下约定参数要与config.properties（或数据库GCONF表）中的配置相匹配
	 */

	/** 默认未启用GCONF */
	private static boolean usingGconf = false;

	/** 应用接口互访KEY */
	static String APP_KEY = "www.ps1.cn";
	/** 应用接口互访KEY */
	public static String appKey() {
		return APP_KEY;
	}

	/** 应用缩写的编码，如：“FF” */
	static String APP_CODE = "";
	/** 应用缩写的编码，如：“FF” */
	public static String appCode() {
		return APP_CODE;
	}

	/** 主应用的请求地址，如：http://host.ps1.cn */
	static String APP_CORE = "";
	/** 主应用的请求地址，如：http://host.ps1.cn */
	public static String appCore() {
		return APP_CORE;
	}

	/** 主应用，如："/doyea" */
	static String APP_MAIN = "/main";
	/** 主应用，如："/doyea" */
	public static String appMain() {
		return APP_MAIN;
	}

	/** 访问主应用的证书 */
	static String[] APP_SPEC = {};	
	/** 访问主应用的证书 */
	public static String[] appSpec() {
		return APP_SPEC;
	}

	/** 多租户分库时账套编号的KEY，如："dbid" 或 "baseId"，未配置默认"baseId" */
	static String BASE_DBID = "baseId";
	/** 多租户分库时账套编号的KEY，如："dbid" 或 "baseId"，未配置默认"baseId" */
	public static String dbid() {
		return BASE_DBID;
	}

	/** 多租户的分割符号"." 或 "_"，未配置默认"."，增加“0” */
	static String BASE_DOT = ".";
	/** 多租户的分割符号"." 或 "_"，未配置默认"."，增加“0” */
	public static String baseDot() {
		return BASE_DOT;
	}

	/** 多租户的账套名称的前缀，如："culai"、"base" */
	static String BASE_NAME = "";
	/** 多租户的账套名称的前缀，如："culai"、"base" */
	public static String baseName() {
		return BASE_NAME;
	}

	/** 用于区分Mysql、PG时public，Mysql可配置为空，如：mysql\public， */
	static String BASE_MAIN = "";
	/** 用于区分Mysql、PG时public，Mysql可配置为空，如：mysql\public， */
	public static String baseMain() {
		return BASE_MAIN;
	}

	/** 支持多语言参数，如：ZH,EN */
	static String[] I18N_LOCALES = { "ZH", "EN" };
	/** 支持多语言参数，如：ZH,EN */
	public static String[] locales() {
		return I18N_LOCALES;
	}

	/** 单点SSO请求单点登录的远程服务地址，如：http://sso.ps1.cn/aolai/s */
	static String SSO_URL = "";
	/** 单点SSO请求单点登录的远程服务地址，如：http://sso.ps1.cn/aolai/s */
	public static String ssoUrl() {
		return SSO_URL;
	}

	/** 各个接口通用校验项目（如：dbid等通用项），默认不用配置 */
	static String VALID_MUST = "";
	/** 各个接口通用校验项目（如：dbid等通用项），默认不用配置 */
	public static String mustValid() {
		return VALID_MUST;
	}

	/** 查询数据行数的限制，未配置默认limit.rows=''不限制数据 */
	static String LIMIT_ROWS = "2999";
	/** 查询数据行数的限制，未配置默认limit.rows=''不限制数据 */
	public static String limitRows() {
		return LIMIT_ROWS;
	}

	/** Http请求超时时间，默认2分钟超时，120秒 */
	static int HTTP_TIMEOUT = 120000;
	/** Http请求超时时间，默认2分钟超时，120秒 */
	public static int httpTimeout() {
		return HTTP_TIMEOUT;
	}

	/** Redis默认的用户缓存时间 2小时 */
	static int CACHE_TIME = Const.TWO_HH;
	/** Redis默认的用户缓存时间 2小时 */
	public static int cacheTime() {
		return CACHE_TIME;
	}

	/** Redis默认的验证码有效缓存时间（默认10分钟10000秒） */
	static int CODE_EXPIRED = Const.TEN_MM;
	/** Redis默认的验证码有效缓存时间（默认10分钟10000秒） */
	public static int vcodeDue() {
		return CODE_EXPIRED;
	}
	
	/** API是否需要对应三方应用授权才能访问 */
	static boolean API_PERMIT = false;
	/** API是否需要对应三方应用授权才能访问 */
	public static boolean apiPermit() {
		return API_PERMIT;
	}

	/** 应用请求路径跟踪标识，可不用配置 */
	static boolean IS_TRACKING = false;
	/** 应用请求路径跟踪标识，可不用配置 */
	public static boolean isTracking() {
		return IS_TRACKING;
	}

	/** 开放API接口标识，可不用配置，若需要配置为：true */
	static boolean IS_API_OPEN = false;
	/** 开放API接口标识，可不用配置，若需要配置为：true */
	public static boolean isApiOpen() {
		return IS_API_OPEN;
	}

	/** 响应内容加密，可不用配置 */
	static boolean IS_ENC_RESP = false;
	/** 响应内容加密，可不用配置 */
	public static boolean isEncResp() {
		return IS_ENC_RESP;
	}

	/** 响应日志记录，可不用配置 */
	static boolean IS_LOG_RESP = false;
	/** 响应日志记录，可不用配置 */
	public static boolean isLogResp() {
		return IS_LOG_RESP;
	}

	/** 请求内容是否忽略加密，默认加密（不忽略），可不用配置 */
	static boolean IS_ENC_OMIT = false;
	/** 请求内容是否忽略加密，默认加密（不忽略），可不用配置 */
	public static boolean isEncOmit() {
		return IS_ENC_OMIT;
	}

	/** 日志要不要保存“请求参数”的最大长度 */
	static int IS_LOG_ARGS = 0;
	/** 日志要不要保存“请求参数”的最大长度 */
	public static int logArgs() {
		return IS_LOG_ARGS;
	}

	/** 控制同一账户多人同时登录，未配置默认为仅限单用户登录使用 */
	static boolean IS_MULTI_LOGIN = false;
	/** 控制同一账户多人同时登录，未配置默认为仅限单用户登录使用 */
	public static boolean isMultLogin() {
		return IS_MULTI_LOGIN;
	}
	
	/** 是否支持自定义设置标签的隐藏和显示的数量 */
	static boolean IS_CUSTOM_COLS = false;
	/** 是否支持自定义设置标签的隐藏和显示的数量 */
	public static boolean isCustomCols() {
		return IS_CUSTOM_COLS;
	}

	/** 避开数据库校验规则 */
	static boolean AVOID_RULES = false;
	/** 避开数据库校验规则 */
	public static boolean avoidRules() {
		return AVOID_RULES;
	}

	/** 正则映射 */
	public static String REGEXP = " regexp";
	/** rlike 映射 */
	public static String RLIKE = " rlike";

	/** 有效的 SQL表达式，暂时禁用: "!","&&","||","XOR" */
	public static String[] SQL_EXPR = { "=", ">", "<", ">=", "<=", "<>", "!=",
			"regexp", "rlike", "is", "not", "null", "and", "or", "like", "in",
			"(", ")", "between", "length(", "json_extract(" };//, "max(", "min(" };

//	static {
//		// 根据配置判断是否启用数据库：GCONF
//		usingGconf = conf("app.gconf", "").length() > 0;
//	}

	/**
	 * 初始化全局配置，在 SpringContext中调用此方法
	 */
	public static void initGconf() {
		String cnf = conf("app.gconf", "");
		// 根据配置判断是否启用数据库：GCONF
		usingGconf = !"".equals(cnf);

		if (usingGconf) {
			// 获取数据库中的数据，并初始化
			initGconf(invoke(null, "appGconf", cnf));
		} else {
			APP_KEY = conf("app.key", APP_KEY);
			APP_CODE = conf("app.code", APP_CODE);
			APP_CORE = conf("app.core", APP_CORE);
			APP_MAIN = conf("app.main", APP_MAIN);
			// 格式为：ticket:apec
			// VJEFKISG:12044b9cbfb8eeaeba3e21d1d7a26611
			APP_SPEC = conf("app.spec", "").split(Const.COLON);

			BASE_DBID = conf("base.dbid", BASE_DBID);
			BASE_DOT = conf("base.dot", Const.DOT); // 默认'.'
			BASE_NAME = conf("base.name", "");
			// PG时public，Mysql可配置为空
			BASE_MAIN = conf("base.main", ""); // mysql时可配置为空

			I18N_LOCALES = conf("i18n.locales", "ZH,EN").split(COMMA);

			SSO_URL = conf("sso.url", "");
			VALID_MUST = conf("valid.must", "");
			LIMIT_ROWS = conf("limit.rows", LIMIT_ROWS);

			HTTP_TIMEOUT = conf("http.timeout", 90000);
			CACHE_TIME = conf("cache.time", Const.TWO_HH);
			CODE_EXPIRED = conf("code.expired", Const.TEN_MM);

			API_PERMIT = conf("api.permit", "").length() > 0;
			IS_TRACKING = conf("app.trace", "").length() > 0;
			IS_API_OPEN = conf("api.open", "").length() > 0; // 开放API模式:"true"
			IS_ENC_RESP = conf("enc.resp", "").length() > 0;
			IS_LOG_RESP = conf("log.resp", "").length() > 0;
			IS_ENC_OMIT = conf("enc.omit", "").length() > 0;
			// 日志要不要保存“请求参数”的最大长度
			IS_LOG_ARGS = Integer.parseInt(conf("log.args", Const.S_0));

			IS_MULTI_LOGIN = conf("multi.login", "").length() > 0;
			IS_CUSTOM_COLS = conf("cols.custom", "").length() > 0;

			AVOID_RULES = conf("avoid.rules", "").length() > 0;

			REGEXP = conf("sql.regexp", REGEXP);
			RLIKE = conf("sql.rlike", RLIKE);

			// 可以自定义SQL注入的关键字
			cnf = conf("sql.expr", "");
			if (cnf.length() > 0)
				SQL_EXPR = cnf.split(COMMA);
		}
	}

	/**
	 * 初始化加载数据，从数据库中读取系统配置参数
	 */
	private static void initGconf(Object res) {
		GCONF = obj2Map(res);
		if (GCONF.isEmpty()) {
			LOG.error("initGconf... GCONF is null");
			return;
		}
		LOG.info("getConf()...{}" , GCONF);
		LOG.info("------------");

		APP_KEY = gconf("app.key", APP_KEY);
		APP_KEY = gconf("app.key", APP_KEY);
		APP_CODE = gconf("app.code", APP_CODE);
		APP_CORE = gconf("app.core", APP_CORE);
		APP_MAIN = gconf("app.main", APP_MAIN);
		// 格式为：ticket:apec
		// VJEFKISG:12044b9cbfb8eeaeba3e21d1d7a26611
		APP_SPEC = gconf("app.spec", "").split(Const.COLON);

		BASE_DBID = gconf("base.dbid", BASE_DBID);
		BASE_DOT = gconf("base.dot", Const.DOT); // 默认'.'
		BASE_NAME = gconf("base.name", "");
		// PG时public，Mysql可配置为空
		BASE_MAIN = gconf("base.main", ""); // mysql时可配置为空

		I18N_LOCALES = gconf("i18n.locales", "ZH,EN").split(COMMA);

		SSO_URL = gconf("sso.url", "");
		VALID_MUST = gconf("valid.must", "");
		LIMIT_ROWS = gconf("limit.rows", LIMIT_ROWS);

		HTTP_TIMEOUT = gconf("http.timeout", 90000);
		CACHE_TIME = gconf("cache.time", Const.TWO_HH);
		CODE_EXPIRED = gconf("code.expired", Const.TEN_MM);

		API_PERMIT = gconf("api.permit", "").length() > 0;
		IS_TRACKING = gconf("app.trace", "").length() > 0;
		IS_API_OPEN = gconf("api.open", "").length() > 0; // 开放API模式:"true"
		IS_ENC_RESP = gconf("enc.resp", "").length() > 0;
		IS_LOG_RESP = gconf("log.resp", "").length() > 0;
		IS_ENC_OMIT = gconf("enc.omit", "").length() > 0;
		// 日志要不要保存“请求参数”的最大长度
		IS_LOG_ARGS = Integer.parseInt(gconf("log.args", Const.S_0));

		IS_MULTI_LOGIN = gconf("multi.login", "").length() > 0;
		IS_CUSTOM_COLS = gconf("cols.custom", "").length() > 0;

		AVOID_RULES = gconf("avoid.rules", "").length() > 0;

		REGEXP = gconf("sql.regexp", REGEXP);
		RLIKE = gconf("sql.rlike", RLIKE);

		// 可以自定义SQL注入的关键字
		String cnf = gconf("sql.expr", "");
		if (cnf.length() > 0)
			SQL_EXPR = cnf.split(COMMA);
	}

	/**
	 * 初始化加载数据，从数据库中读取系统配置参数
	 */
	private static String gconf(String key, String def) {
		String val = GCONF.get(key);
		return val == null || "".equals(val) ? def : val;
	}

	/**
	 * 初始化加载数据，从数据库中读取系统配置参数
	 */
	private static int gconf(String key, int def) {
		String val = GCONF.get(key);
		return isInt(val) ? Integer.parseInt(val) : def;
	}

	/**
	 * 租户数据隔离（既非分库、也非分表），需配置为：BASE_DOT=“0”
	 */
	public static boolean dataIsolation() {
		return Const.S_0.equals(baseDot());
	}

	/**
	 * 调用：根据Bean名称，发起第三方服务接口调用<br>
	 */
	public static Object invoke(Object bean, String method, Object args) {
		try {
			// 获取bean
			if (bean == null)
				bean = SpringContext.getBean("gconfService");
			// 获取公开方法
			Method m = bean.getClass().getMethod(method, Object.class);
			// 调用方法，根据参数进行处理
			return m.invoke(bean, args);
		} catch (Exception e) {
			LOG.error("invoke....{}({})", method, args);
			return null;
		}
	}

	/**
	 * 获取配置参数的值
	 */
	public static String getConf(String key) {
		return getConf(key, "");
	}

	/**
	 * 获取配置参数的值
	 */
	public static String getConf(String key, String def) {
		return usingGconf ? gconf(key, def) : getProp(CONF, key, def);
	}

	/**
	 * 获取配置参数的值
	 */
	public static int getInt(String key, int def) {
		String val = get(key, "");
		return isInt(val) ? Integer.parseInt(val) : def;
	}

	/**
	 * 获取配置参数的值
	 */
	public static String get(String key, String def) {
		return usingGconf ? gconf(key, def) : getProp(CONF, key, def);
	}

	/**
	 * 获取配置参数的值
	 */
	public static String get(String key) {
		return get(key, "");
	}

	/** 以下为配置参数文件的处理 */

	/**
	 * 前台请求接口数据返给前台的响应参数名
	 */
	public static String getParam(String key) {
		return getProp(PARAM, key, "");
	}

	/**
	 * 前台请求接口的必需参数
	 */
	public static String getValid(String key) {
		return getProp(VALID, key, "");
	}

	/** 读取配置文件数据 */
	private static String getProp(ResourceBundle rb, String key, String def) {
		try {
			return rb.getString(key);
		} catch (Exception e) {
			LOG.debug("getProp...{}", e.getMessage());
			return def;
		}
	}

	/** 读取配置文件数据 */
	private static String conf(String key, String def) {
		return getProp(CONF, key, def);
	}

	/** 读取配置文件数据 */
	private static int conf(String key, int def) {
		String val = getProp(CONF, key, "");
		return isInt(val) ? Integer.parseInt(val) : def;
	}

	/** 对象转换为Map */
	@SuppressWarnings("unchecked")
	public static <T> Map<String, T> obj2Map(Object data) {
		return data instanceof Map ? (Map<String, T>) data : new HashMap<>();
	}

	/** 判断字符串是否为整数 */
	public static boolean isInt(String s) {
		return s != null && Pattern.matches("-?\\d+", s);
	}

}
