package cn.ps1.aolai.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.utils.Const;

/**
 * 全局通用的文件处理相关的公共方法类
 * 
 * @author Aolai
 * @since  $Date: 2022.9.10
 */

@Service
public class XfileService {

	@Autowired
	private UtilsService utils;

	/**
	 * 拼接文件路径，如：aolai/1036/20220925/
	 */
	public <T> String getFilePath(Map<String, T> map, String[] keys) {
		StringBuffer sb = new StringBuffer();
		for (String key : keys) {
			sb.append(map.get(key) + File.separator);
		}
		return sb.toString();
	}

	/**
	 * 根据文件的全路径截取文件名称
	 */
	public String getFileName(String file) {
		return file.substring(file.lastIndexOf(File.separator));
	}

	/**
	 * 这里返回拼接生成的文件名称
	 */
	public String makeFileName(Object name, Object ext) {
		// 这里为自动生成的文件名称
		return name + Const.DOT + ext;
	}

	/**
	 * 文件尺寸（默认千字节KB）超限额，如：limit=“100M”
	 */
	public boolean overSize(long kiloByte, String limit) {
		// 标示文件字节大小的单位
		String[] unit = { "K", "M", "G", "T", "P" };
		if (!utils.isEmpty(limit)) {
			limit = limit.toUpperCase();
			for (int i = 0; i < unit.length; i++) {
				if (limit.indexOf(unit[i]) < 1)
					continue;
				// 截取数值
				limit = limit.split(unit[i])[0];
				if (!utils.isInteger(limit))
					return false;
				// 字节单位转换
				kiloByte = (long) (kiloByte / Math.pow(1024, i));
				return kiloByte > Integer.parseInt(limit);
			}
			return utils.isInteger(limit) && kiloByte > Integer.parseInt(limit);
		}
		return false;
	}

	/**
	 * 输出文件流到浏览器，用于下载或预览文件
	 */
	public boolean write2Resp(String file, HttpServletResponse resp,
			String header, String contentType) {
		InputStream inp = null;
		OutputStream out = null;
		boolean isSuccess = true;
        try {
        	inp = new FileInputStream(file);
			byte[] bytes = new byte[inp.available()];
			inp.read(bytes); // 输出流
			// 设置response的Header
			String fileName = getFileName(file);
			// 清空response
			resp.reset();
			resp.addHeader("Content-Disposition", header + fileName);
			resp.addIntHeader("Content-Length", bytes.length);
			resp.setContentType(contentType);
			out = new BufferedOutputStream(resp.getOutputStream());
			out.write(bytes); // 输出流
			out.flush();
		} catch (IOException e) {
			isSuccess = false;
		} finally {
			utils.close(inp, out);
		}
        return isSuccess;
	}

}
