package cn.ps1.aolai.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;

/**
 * 维护全局系统配置表GCONF中的数据，与其相关的基础业务操作
 *
 * @author Aolai
 * @version 1.0
 * @since OpenJdk1.8 $Date: 2024.3.7
 */

@Service
public class GconfService {

	// 元数据表
	private static final String CERT = "CERT";
	private static final String CONF = "CONF";

	@Autowired
	private AolaiService aolai;
	@Autowired
	private UtilsService utils;

	/**
	 * 获取全部配置参数：默认表GCONF
	 */
	public Map<String, String> appGconf(Object params) {
		if (params == null)
			return null;
		// 这里默认为获取"app.gconf"的值：params=“,CONF,,0”
		String args = String.valueOf(params);
		// 默认confTag="gconf"
		return getGconf(args.split(ConfUtil.COMMA), "gconf");
	}

	/**
	 * 获取全部配置参数：默认表GCONF
	 */
	private Map<String, String> getGconf(String[] args, String tag) {
		// 默认值
		String[] arr = { null, CONF, "", Const.S_0 };
		for (int i = 0; i < args.length && i < arr.length; i++)
			arr[i] = args[i];
		String key = arr[1].toLowerCase();
		Map<String, Object> where = new HashMap<>();
		where.put(key + "Tag", tag);
		List<Map<String, String>> list = aolai.findAll(where, null, arr);
		return utils.list2Map(list, key + "Key", key + "Val");
	}

	/**
	 * 根据ticket获取各自的 certKey通行证
	 */
	public Map<String, String> appCert(Object ticket) {
		// 如：ticket="JLA9EKCL"
		Map<String, Object> where = new HashMap<>();
		// 参数值：certId
		where.put(ConfUtil.CERTID, ticket);
		where.put("certState", Const.S_1);
		// 从通行证表中获取通行证（API证书）
		return aolai.findOne(CERT, where, null);
	}

}
