package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.FailedException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import java.util.Map;

/**
 * 这里定义了全局统一的异常处理方式方法，在Controller捕获异常并统一处理
 * 
 * @author Aolai
 * @since 1.7 2023/3/26
 */
@RestControllerAdvice
public class AdviceService {

	private static Logger LOG = LoggerFactory.getLogger(AdviceService.class);

	@Autowired
	private UtilsService utils;

	/**
	 * 处理 FailedException 异常
	 */
	@ExceptionHandler(FailedException.class)
	public Map<String, String> handleFailedException(FailedException ex) {
		return utils.failed(ex.getMessage());
	}

	/**
	 * 处理 RuntimeException 异常
	 */
	@ExceptionHandler(RuntimeException.class)
	public Map<String, String> handleRuntimeException(RuntimeException ex) {
		LOG.error("RuntimeException...", ex);
//		ex.printStackTrace();
		return utils.failed("doFailed");
	}

	/**
	 * 处理 Exception 异常
	 */
	@ExceptionHandler(Exception.class)
	public Map<String, String> handleException(Exception ex) {
		LOG.error("Exception...", ex);
//		ex.printStackTrace();
		return utils.failed(ex.getMessage());
	}

}
