package cn.ps1.aolai.service;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;

/**
 * 在controller层返回结果之前，拦截处理接口返回的数据
 * <p>
 * 1.拦截器能获取controller方法返回的数据以方便记录日志，<br>
 * 2.对返回的数据进行加密处理
 *
 * @author Aolai
 * @since 1.8 2023/8/13
 */
@ControllerAdvice
public class AdviceResponse implements ResponseBodyAdvice<Object> {

	@Autowired
	private UtilsService utils;

	@Override
	public boolean supports(MethodParameter returnType,
			Class<? extends HttpMessageConverter<?>> converterType) {
		// 返回true时才会执行beforeBodyWrite方法
		return true;
	}

	@Override
	public Object beforeBodyWrite(Object body, MethodParameter returnType,
			MediaType selectedContentType,
			Class<? extends HttpMessageConverter<?>> selectedConverterType,
			ServerHttpRequest request, ServerHttpResponse response) {

		// 获取请求时携带的参数
		HttpServletRequest req = ((ServletServerHttpRequest) request)
				.getServletRequest();

		// 不加密，程序可能走不到这里，对应Interceptor中的PLAIN_BODY
		req.setAttribute("PLAIN_BODY", body);
		if (ConfUtil.isEncResp() && body != null) {
			// 先忽略应用间接口调用时的数据加密
			if (req.getParameter(ConfUtil.CERT_K) == null) {
				String certId = (String) req.getAttribute(ConfUtil.CERTID);
				// 加密处理
				Map<String, Object> json = new HashMap<>();
				String strBody = Digest.sm4Encrypt(utils.obj2Str(body), certId);
				json.put(ConfUtil.JSONSTR, strBody);
				return json;
			}
		}
		return body;
	}

}
