package cn.ps1.aolai.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * Aolai基础框架相关业务，对mybatis进行封装扩展
 * 
 * @author Aolai
 * @version 1.0 $Date: 2019.7.6
 * @since 1.7
 */

@Repository
public interface AolaiDao {

	/**
	 * 利用GMETA信息动态创建表（不推荐在 aolai之外的应用直接调用）
	 * @param map
	 */
	public void create(Map<String, String> map);

	/**
	 * 删除表（不推荐在 aolai之外的应用直接调用）
	 * @param table
	 */
	public void drop(@Param("table") String table);

	/**
	 * 修改表（不推荐）
	 * @param map
	 */
	public void alter(Map<String, String> map);

	/**
	 * 组合条件检索表中的数据（不推荐）
	 * 
	 * @deprecated 这个方法不安全已被弃用，且在未来版本中不再支持。
	 * @param sqlStr
	 * @return list 结果数据一览
	 */
	public List<Map<String, String>> query(@Param("sqlStr") String sqlStr);

	/**
	 * 往表中插入一条数据
	 * 
	 * @param map 表名table、更新标记dupl等
	 * @param data 插入数据
	 * @return int 成功行数
	 */
	public int addOne(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data);

	/**
	 * 批量往表中插入数据
	 * 
	 * @param map 表名table、更新标记dupl等
	 * @param data 字段映射信息
	 * @param list 插入数据列表
	 * @return int 成功行数
	 */
	public int batchAdd(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data,
			@Param("list") List<Map<String, Object>> list);

	/**
	 * 删除表中的数据
	 * 
	 * @param map 表名table等
	 * @param cond 删除条件
	 * @return int 成功行数
	 */
	public int delete(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 更新表中的数据
	 * 
	 * @param map 表名table、别名alias等
	 * @param values 更新数值
	 * @param cond 更新条件
	 * @return int 成功行数
	 */
	public int update(@Param("map") Map<String, String> map,
			@Param("values") Map<String, ?> values,
			@Param("cond") Map<String, Object> cond);
	
	/**
	 * 批量查出表中的数据
	 * 
	 * @param map 表名table、别名alias等
	 * @param cond 查询条件
	 * @return list 结果数据一览
	 */
	public <T> List<Map<String, T>> findList(
			@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 查出表中的一条记录，限定了只返回一条记录
	 * 
	 * @param map 表名table、别名alias等
	 * @param cond 查询条件
	 * @return list 结果数据一览
	 */
	public Map<String, String> findOne(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 判断表中是否有数据
	 * 
	 * @param map 表名table等
	 * @param cond 查询条件
	 * @return int 结果行数
	 */
	public int countRows(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 从元数据GMETA表中获取元数据的表名一览
	 * 
	 * @param gmeta 元数据表名
	 */
	public List<String> getMetaTable(@Param("gmeta") String gmeta);

	/**
	 * 从数据库中获取实体表名
	 * 
	 * @param table 表名
	 */
	public List<String> showTables(@Param("table") String table);

	/**
	 * 从数据库的实体表中获取字段列名
	 */
	public List<Map<String, String>> showColumns(Map<String, String> map);

	/**
	 * 从 Meta表中获取元数据信息一览
	 */
	public List<Map<String, String>> getMeta(
			@Param("map") Map<String, String> map, @Param("cond") String[] cond);

	/**
	 * 根据用户的应用、公司、岗位（dutyId）获取菜单控制权限一览
	 * <P>
	 * pageId;pageName;pageRoute;pageCmpt;pageType;pageGroup;pageAction;pageIcon
	 * ;roleId;(rolePage;)roleAction
	 * 
	 * @param map 查询条件
	 * @return list 结果数据一览
	 */
	public List<Map<String, String>> getMenuRole(Map<String, Object> map);

	/**
	 * 根据用户的应用、公司、岗位（dutyId）获取页面上的功能事件控制权限一览
	 * 
	 * @param map 查询条件
	 * @return list 结果数据一览
	 */
	public List<Map<String, String>> getActionRole(Map<String, Object> map);

	/**
	 * 获取当前某个表中某个字段最大值或最小值
	 */
	public String getMValue(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 获取当前某个表中某个字段最大编码
	 */
//	public int getMaxCode(@Param("map") Map<String, String> map,
//			@Param("cond") Map<String, Object> cond);

	/** 归集数据行数，用于统计和分组数据 */
	public List<Map<String, String>> groupCount(@Param("table") String table,
			@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

}
