package cn.ps1.aolai.annotation;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

/**
 * 自定义postProcessor，处理自定义注解顺序问题
 * 
 * @author yujf
 *
 */
public class AolaiBeanPostProcessor implements BeanPostProcessor {

	@Autowired
	AolaiBodyResolver aolaiBodyResolver;

	/**
	 * 此处也不能返回null，不然后注册不上
	 */
	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName) {
		if (beanName.contains("RequestMappingHandlerAdapter")) {
			// requestMappingHandlerAdapter进行修改
			RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter) bean;
			List<HandlerMethodArgumentResolver> argumentResolvers = adapter
					.getArgumentResolvers();

			// 添加自定义参数处理器
			argumentResolvers = addArgumentResolvers(argumentResolvers);

			adapter.setArgumentResolvers(argumentResolvers);
		}
		return bean;
	}

	private List<HandlerMethodArgumentResolver> addArgumentResolvers(
			List<HandlerMethodArgumentResolver> argumentResolvers) {
		List<HandlerMethodArgumentResolver> resolvers = new ArrayList<>();
		// 将自定义注解的顺序排到前面
		resolvers.add(aolaiBodyResolver);
		// 将原本的添加后面
		resolvers.addAll(argumentResolvers);
		return resolvers;
	}

	/**
	 * 此处不能返回null。不然会注册不上
	 */
	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName)
			throws BeansException {
		return bean;
	}
}