/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.Digest;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public class EncConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private Set<String> decodeKeys;

    protected void loadProperties(Properties props) throws IOException {
        super.loadProperties(props);
        if (this.decodeKeys == null || this.decodeKeys.size() == 0) {
            return;
        }
        for (String key : props.stringPropertyNames()) {
            if (!this.decodeKeys.contains(key)) continue;
            String val = this.decryptString(props.getProperty(key));
            props.setProperty(key, val);
        }
    }

    public Set<String> getDecodeKeys() {
        return this.decodeKeys;
    }

    public void setDecodeKeys(Set<String> decodeKeys) {
        this.decodeKeys = decodeKeys;
    }

    private String decryptString(String src) {
        return Digest.decrypt(src, Digest.seed());
    }
}

