/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class UtilsService {
    private static Logger LOG = LoggerFactory.getLogger(UtilsService.class);
    private static ObjectMapper jsonMapper = new ObjectMapper();
    @Autowired
    private ApplicationContext appCtx;

    @Deprecated
    public String getConf(String key) {
        return ConfUtil.getConf(key);
    }

    @Deprecated
    public String getArgs(String key) {
        return ConfUtil.getParam(key);
    }

    @Deprecated
    public String getValid(String key) {
        return ConfUtil.getValid(key);
    }

    boolean isPostgres() {
        return this.appCtx.containsBean("dsPostgres");
    }

    public Map<String, String> getParams(HttpServletRequest req) {
        return this.obj2Map(this.jsonParams(req));
    }

    public Map<String, Object> jsonParams(HttpServletRequest req) {
        return this.obj2Map(req.getAttribute("json"));
    }

    public Map<String, String> userSelf(HttpServletRequest req) {
        return this.obj2Map(req.getAttribute("user"));
    }

    public boolean availParams(Map<?, ?> map, String key) {
        return this.availParams(map, new String[]{key});
    }

    public boolean availParams(Map<?, ?> params, String[] keys) {
        if (this.isEmpty(params)) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (params.containsKey(keys[i])) continue;
            return false;
        }
        return true;
    }

    public int[] num2Arr(String numStr) {
        int[] num = this.str2num(numStr);
        for (int i = 1; i < num.length; ++i) {
            int n = i;
            num[n] = num[n] + num[i - 1];
        }
        return num;
    }

    public int[] str2num(String numStr) {
        if (!this.isInteger(numStr)) {
            return new int[0];
        }
        String[] arr = numStr.split("");
        int[] num = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            num[i] = Integer.parseInt(arr[i]);
        }
        return num;
    }

    public String arr2Str(String[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public <T> int getInt(Map<String, T> map, String key) {
        String str;
        if (!this.isEmpty(map) && !this.isEmpty(map.get(key)) && this.isInteger(str = String.valueOf(map.get(key)))) {
            return Integer.valueOf(str);
        }
        return 0;
    }

    public String initCap(Object str) {
        char[] cs = String.valueOf(str).toLowerCase().toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public <T> Map<String, T> obj2Map(Object data) {
        return data instanceof Map ? (Map)data : new HashMap();
    }

    public <T> List<Map<String, T>> obj2List(Object data) {
        return data instanceof Collection ? (List)data : new ArrayList();
    }

    public Map<String, String> obj2Map(Map<String, Object> obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (obj instanceof Map) {
            for (Map.Entry<String, Object> e : obj.entrySet()) {
                Object val = e.getValue();
                if (val == null) continue;
                map.put(e.getKey(), String.valueOf(val));
            }
        }
        return map;
    }

    public Map<String, Object> map2Obj(Map<String, String> obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj instanceof Map) {
            for (Map.Entry<String, String> e : obj.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
        }
        return map;
    }

    public String obj2Str(Object obj) {
        try {
            return jsonMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> node2Obj(String jsonStr, String path) {
        try {
            if (!this.isEmpty(jsonStr)) {
                JsonNode node = jsonMapper.readTree(jsonStr);
                return this.node2Obj(path == null ? node : node.path(path));
            }
        }
        catch (Exception e) {
            LOG.error("> node2Obj...");
            e.printStackTrace();
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> node2Obj(String jsonStr) {
        return this.node2Obj(jsonStr, null);
    }

    public Map<String, Object> node2Obj(JsonNode jsonNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jsonNode.isValueNode()) {
            map.put("", jsonNode.asText());
        } else if (jsonNode.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator it = jsonNode.iterator();
            while (it.hasNext()) {
                Map<String, Object> child = this.node2Obj((JsonNode)it.next());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    list.add(child.get(""));
                    continue;
                }
                list.add(child);
            }
            map.put("", list);
        } else {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entity = (Map.Entry)it.next();
                Map<String, Object> child = this.node2Obj((JsonNode)entity.getValue());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    map.put((String)entity.getKey(), child.get(""));
                    continue;
                }
                map.put((String)entity.getKey(), child);
            }
        }
        return map;
    }

    public <T> Map<String, T> json2Map(String str) {
        try {
            if (str != null) {
                return (Map)jsonMapper.readValue(str, new typeRef());
            }
        }
        catch (Exception e) {
            LOG.error("> json2Map..." + e.getMessage());
            this.toDebug("json2Map", str);
        }
        return new HashMap();
    }

    private void toDebug(String method, String str) {
        if (str.length() > 200) {
            str = str.substring(0, 200) + "...";
        }
        LOG.debug("> " + method + "..." + str);
    }

    public <T> List<Map<String, T>> json2List(Object obj) {
        return obj == null ? new ArrayList() : this.json2List(String.valueOf(obj));
    }

    public <T> List<Map<String, T>> json2List(String str) {
        try {
            if (str != null) {
                return (List)jsonMapper.readValue(str, new typeRef());
            }
        }
        catch (Exception e) {
            LOG.error("> json2List..." + e.getMessage());
            this.toDebug("json2List", str);
        }
        return new ArrayList<Map<String, T>>();
    }

    public Map<String, Map<String, String>> list2Map(List<Map<String, String>> list, String key) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (list != null && key != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> item = list.get(i);
                map.put(item.get(key), item);
            }
        }
        return map;
    }

    public Map<String, String> list2Map(List<Map<String, String>> list, String key, String val) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list != null && key != null && val != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> item = list.get(i);
                map.put(item.get(key), item.get(val));
            }
        }
        return map;
    }

    public Map<String, String> result(String status) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", status);
        return result;
    }

    public Map<String, String> result(boolean status) {
        return this.result(status ? "1" : "0");
    }

    public Map<String, String> result(String status, String info) {
        Map<String, String> result = this.result(status);
        if (info != null) {
            result.put("info", info);
        }
        return result;
    }

    public <T> Object result(Map<String, T> map) {
        if (map.containsKey("status")) {
            return map;
        }
        return this.success(map);
    }

    public Map<String, String> failed(String info) {
        return this.result("0", info);
    }

    public Map<String, String> success(String info) {
        return this.result("1", info);
    }

    public Map<String, String> success() {
        return this.result("1");
    }

    public Map<String, Object> success(Object obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "1");
        result.put("info", obj);
        return result;
    }

    public Map<String, String> success(Object obj, HttpServletRequest req) {
        Object cert = req.getAttribute("certId");
        return this.success(Digest.decrypt(this.obj2Str(obj), String.valueOf(cert)));
    }

    public Map<String, String> findIn(List<Map<String, String>> list, String key, String val) {
        if (list instanceof Collection && key != null && val != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!val.equals(list.get(i).get(key))) continue;
                return list.get(i);
            }
        }
        return null;
    }

    public boolean findIn(List<String> list, String str) {
        return list instanceof Collection && list.contains(str);
    }

    public boolean findIn(String[] arr, String str) {
        if (!this.isEmpty(arr) && str != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!arr[i].equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean findIn(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        return Pattern.compile(regex).matcher(str).find();
    }

    public boolean isMatch(String input, String regex) {
        if (input == null || regex == null) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public boolean isInteger(String str) {
        return this.isMatch(str, "^-?\\d+$");
    }

    public boolean isNumeric(String str) {
        return this.isMatch(str, "^(-?\\d+)(\\.\\d+)?$");
    }

    public boolean isIdcard(String str) {
        return !this.isEmpty(str) && this.isMatch(str, "^\\d{17}[\\dXx]$");
    }

    public boolean isMobile(String str) {
        return !this.isEmpty(str) && this.isMatch(str, "^1[3-9]\\d{9}");
    }

    public boolean isDatetime(String str, String pat) {
        try {
            new SimpleDateFormat(pat).parse(str);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String timeFormat(String strTime, String pat0, String pat1) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat(pat0).parse(strTime));
            strTime = new SimpleDateFormat(pat1).format(cal.getTime());
        }
        catch (ParseException e) {
            LOG.error("> timeFormat...");
            e.printStackTrace();
        }
        return strTime;
    }

    public long timeDiff(Date begin, Date end) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        long msec = cal.getTimeInMillis();
        cal.setTime(begin);
        return msec - cal.getTimeInMillis();
    }

    public long timeDiff(String begin, String end) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!this.isEmpty(begin)) {
                Date endDate = this.isEmpty(end) ? new Date() : sdf.parse(end);
                return this.timeDiff(sdf.parse(begin), endDate);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public String today(String pattern) {
        return this.today(pattern, Calendar.getInstance());
    }

    private String today(String pattern, Calendar cal) {
        pattern = this.isEmpty(pattern) ? "yyyy-MM-dd HH:mm:ss" : pattern;
        return new SimpleDateFormat(pattern).format(cal.getTime());
    }

    public String nextYear(String pattern, int n) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, n);
        return this.today(pattern, cal);
    }

    public String nextMonth(String month, int m) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(month));
        }
        catch (ParseException e) {
            LOG.error("> nextMonth...");
            e.printStackTrace();
        }
        cal.add(2, m);
        return sdf.format(cal.getTime());
    }

    public String nextMonth(String month) {
        return this.nextMonth(month, 1);
    }

    @Deprecated
    public String prevMonth(String month, int m) {
        return this.nextMonth(month, -m);
    }

    public String prevMonth(String month) {
        return this.nextMonth(month, -1);
    }

    public String[] getHost(String uri) {
        int idx = uri.indexOf("://");
        uri = idx > 0 ? uri.substring(idx + 3) : uri;
        idx = uri.indexOf(47);
        uri = idx > 0 ? uri.substring(0, idx) : uri;
        return uri.split(":");
    }

    public String getRequestURI(HttpServletRequest req) {
        String uri = req.getServletPath();
        return uri.substring(uri.lastIndexOf(47));
    }

    private String getDomain(HttpServletRequest req) {
        String ref = req.getHeader("Referer");
        if (this.isEmpty(ref)) {
            ref = req.getRequestURL().toString();
        }
        LOG.info("> getDomain..." + ref);
        String host = this.getHost(ref)[0];
        String[] arr = host.split("\\.");
        return arr.length == 3 ? arr[1] + "." + arr[2] : host;
    }

    public void setCookies(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> map) {
        if (this.isEmpty(map)) {
            return;
        }
        String domain = this.getDomain(req);
        for (Map.Entry<String, String> e : map.entrySet()) {
            String k = e.getKey();
            if (k.equals("certId")) continue;
            String v = Digest.encodeURIComponent(e.getValue());
            Cookie c = new Cookie(k, v);
            c.setDomain(domain);
            c.setPath("/");
            rsp.addCookie(c);
        }
    }

    public Map<String, String> getCookies(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Cookie[] cookies = req.getCookies();
        if (!this.isEmpty(cookies)) {
            for (Cookie c : cookies) {
                map.put(c.getName(), Digest.decodeURIComponent(c.getValue()));
            }
        }
        return map;
    }

    public String getCookie(HttpServletRequest req, String key) {
        Cookie[] cookies = req.getCookies();
        if (!this.isEmpty(cookies)) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                return Digest.decodeURIComponent(c.getValue());
            }
        }
        return null;
    }

    public void delCookie(HttpServletRequest req, HttpServletResponse rsp, String key) {
        Cookie[] cookies = req.getCookies();
        if (!this.isEmpty(cookies)) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                c.setDomain(this.getDomain(req));
                c.setPath("/");
                c.setMaxAge(0);
                rsp.addCookie(c);
                break;
            }
        }
    }

    public void clearCookies(HttpServletRequest req, HttpServletResponse rsp) {
        Cookie[] cookies = req.getCookies();
        if (!this.isEmpty(cookies)) {
            String domain = this.getDomain(req);
            for (Cookie c : cookies) {
                c.setDomain(domain);
                c.setPath("/");
                c.setMaxAge(0);
                rsp.addCookie(c);
            }
        }
    }

    public String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }

    public String getClientIp(HttpServletRequest req) {
        String ip = req.getHeader("X-Forwarded-For");
        LOG.info("> X-Forwarded-For..." + ip);
        if ((this.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) && this.isEmpty(ip = req.getRemoteAddr())) {
            return "";
        }
        int p = ip.indexOf(44);
        return p > 0 ? ip.substring(0, p) : ip;
    }

    public String getLocale(HttpServletRequest req) {
        return req.getLocale().getLanguage();
    }

    public final String[] getLocales() {
        return ConfUtil.I18N_LOCALES;
    }

    public <T> String getFilePath(Map<String, T> map, String[] keys) {
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(map.get(key) + File.separator);
        }
        return sb.toString();
    }

    public String buildUri(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                String key = e.getKey();
                String val = e.getValue();
                if (!this.notEmpty(key, val)) continue;
                sb.append(key).append("=").append(Digest.urlEncode(val));
            }
        }
        return sb.toString();
    }

    public boolean notEmpty(String ... values) {
        if (this.isEmpty(values)) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!this.isEmpty(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        return false;
    }

    public <T> boolean isEmpty(Map<String, T> map) {
        return map == null || map.isEmpty();
    }

    public int toStep(int min, int max, int step) {
        int num = min + step;
        return num > max ? max : num;
    }

    public void close(Closeable ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toYuan(String money) {
        return this.toYuan(money, null);
    }

    public String toYuan(String money, String blank) {
        try {
            long l;
            long l2 = l = this.isInteger(money) ? Long.parseLong(money) : 0L;
            if (blank != null && l == 0L) {
                return blank;
            }
            return new DecimalFormat("#,##0.00").format((double)l / 100.0);
        }
        catch (Exception e) {
            LOG.error("> toYuan..." + e.getMessage());
            return blank == null ? "0.00" : blank;
        }
    }

    public String toCent(String money) {
        return this.toCent(money, null);
    }

    public String toCent(String money, String blank) {
        String result = "0";
        try {
            money = this.isEmpty(money) ? "0" : money.replace(",", "");
            double d = this.isNumeric(money) ? Double.valueOf(money) * 100.0 : 0.0;
            result = new DecimalFormat("#0").format(d);
        }
        catch (Exception e) {
            LOG.error("> toCent..." + e.getMessage());
        }
        return blank != null && "0".equals(result) ? blank : result;
    }

    public String toRmb(String money) {
        return this.isInteger(money) ? this.toRmb(Long.parseLong(money)) : "";
    }

    public String toRmb(long n) {
        int i;
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] units = new String[][]{{"\u5206", "\u89d2", "\u5143", "\u4e07", "\u4ebf", "\u4e07"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String s = "";
        String head = n < 0L ? "\u8d1f" : "";
        n = Math.abs(n);
        for (i = 0; i < 2 && n > 0L; n /= 10L, ++i) {
            s = digit[(int)(n % 10L)] + units[0][i] + s;
        }
        for (i = 2; i < units[0].length && n > 0L; ++i) {
            String p = "";
            for (int j = 0; j < units[1].length && n > 0L; n /= 10L, ++j) {
                p = digit[(int)(n % 10L)] + units[1][j] + p;
            }
            p = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6");
            s = p + units[0][i] + s;
        }
        s = s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceAll("(\u96f6.)+", "\u96f6");
        return head + s.replaceAll("\u96f6$", "\u6574");
    }

    public boolean overSize(long kiloByte, String limit) {
        String[] unit = new String[]{"K", "M", "G", "T", "P"};
        if ((limit = String.valueOf(limit).toUpperCase()).length() > 0) {
            for (int i = 0; i < unit.length; ++i) {
                if (limit.indexOf(unit[i]) < 1) continue;
                if (!this.isInteger(limit = limit.split(unit[i])[0])) {
                    return false;
                }
                return (kiloByte = (long)((double)kiloByte / Math.pow(1024.0, i))) > (long)Integer.parseInt(limit);
            }
            return this.isInteger(limit) && kiloByte > (long)Integer.parseInt(limit);
        }
        return false;
    }

    private class typeRef<T>
    extends TypeReference<T> {
        private typeRef() {
        }
    }
}

