/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static final String TICKET = "ticket";
    private static final String COPMID = "compId";
    private static final String DUTYID = "dutyId";
    private static final String BINDID = "bindId";
    private static final String APPCODE = "appCode";
    private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;

    private boolean verifyAppKey(Object k) {
        return ConfUtil.APP_KEY.equals(k) || ConfUtil.ENC_KEY.equals(k);
    }

    public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) {
        if (!cookies.containsKey(BINDID) || cookies.containsKey("userId")) {
            // empty if block
        }
        return false;
    }

    public boolean isSecretKey(HttpServletRequest req) {
        String k = req.getParameter("k");
        if (k == null) {
            return false;
        }
        String jsonStr = req.getParameter("jsonstr");
        if (this.verifyAppKey(k)) {
            LOG.debug("-> verifyAppKey..." + jsonStr);
            if (jsonStr == null) {
                return true;
            }
            return this.setAttrib(req, this.utils.json2Map(jsonStr));
        }
        String priKey = this.redis.get("k." + k);
        if (priKey != null && jsonStr != null) {
            jsonStr = Digest.sm2Decrypt(jsonStr, priKey);
            Map<String, Object> params = this.utils.json2Map(jsonStr);
            return this.setAttrib(req, params);
        }
        return false;
    }

    private boolean setAttrib(HttpServletRequest req, Map<String, Object> params) {
        Object dbid;
        if (params.isEmpty()) {
            Enumeration map = req.getParameterNames();
            while (map.hasMoreElements()) {
                String key = (String)map.nextElement();
                params.put(key, req.getParameter(key));
            }
        } else if (params.containsKey("base")) {
            params.remove("base");
        }
        if ((dbid = params.get(ConfUtil.BASE_DBID)) != null) {
            params.put("base", ConfUtil.BASE_NAME + dbid + ConfUtil.BASE_DOT);
        }
        if (!params.containsKey("i18n")) {
            params.put("i18n", this.getUserLang(req));
        }
        req.setAttribute("json", params);
        LOG.info("> setAttrib(jsonParams)..." + params);
        return true;
    }

    private String getUserLang(HttpServletRequest req) {
        String lang = this.utils.userSelf(req).get("userLang");
        return this.utils.isEmpty(lang) ? this.utils.getLocale(req).toUpperCase() : lang;
    }

    public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> token) throws Exception {
        Map userBase;
        String dbid;
        Map<String, String> user = this.getSessionUser(token);
        if (user == null) {
            this.redis.clearToken(token);
            return this.invlidToken(rsp);
        }
        String spec = token.get("certId");
        Map<String, Object> params = this.decryptParams(req, user, spec);
        String app = ConfUtil.APP_CODE;
        String uri = this.utils.getRequestURI(req);
        LOG.debug("> request from " + app + uri + "=" + params);
        if (this.utils.isEmpty(params.get(APPCODE))) {
            params.put(APPCODE, app);
            if (app.length() > 0 && !this.trustedRole(params, user, uri)) {
                return this.denyAccess(rsp);
            }
        } else if (!this.havePermit(app, uri)) {
            return this.denyAccess(rsp);
        }
        if (!this.checkParams(params, uri.substring(1))) {
            return this.invlidParams(rsp);
        }
        String dbKey = ConfUtil.BASE_DBID;
        if (app.length() > 0 && params.containsKey(dbKey) && !this.utils.isEmpty(dbid = (String)(userBase = this.utils.json2Map(user.get("userBase"))).get(app)) && !"0".equals(dbid) && !dbid.equals(params.get(dbKey))) {
            return this.invlidParams(rsp);
        }
        return this.setAttrib(req, params);
    }

    private Map<String, String> getSessionUser(Map<String, String> token) {
        String certId = token.get("token");
        String userId = Digest.decrypt(token.get("userId"), certId);
        return this.redis.getUserInfo(userId);
    }

    private Map<String, Object> decryptParams(HttpServletRequest req, Map<String, String> user, String spec) {
        req.setAttribute("user", user);
        req.setAttribute("userId", (Object)user.get("userId"));
        req.setAttribute("certId", (Object)spec);
        String jsonStr = req.getParameter("jsonstr");
        if (!ConfUtil.IS_ENC_OMIT && !this.utils.isEmpty(jsonStr)) {
            jsonStr = Digest.sm4Decrypt(jsonStr, spec);
        }
        return this.utils.json2Map(jsonStr);
    }

    private boolean checkParams(Map<?, ?> params, String uri) {
        String keys = ConfUtil.VALID_MUST + ConfUtil.getValid(uri);
        String[] keyArr = keys.split(",|;");
        return keys.length() == 0 || this.utils.availParams(params, keyArr);
    }

    private boolean havePermit(String app, String uri) {
        if (app.length() == 0) {
            return true;
        }
        String rk = "a." + app;
        Map<String, String> permit = this.redis.hmget(rk);
        if (permit == null) {
            permit = this.getActionList(app);
            LOG.debug("> havePermit..." + permit);
            if (permit.isEmpty()) {
                return false;
            }
            this.redis.hmset(rk, permit, 7200);
        }
        return permit.containsKey(uri);
    }

    private Map<String, String> getActionList(String app) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("actApp", app);
        where.put("actMark", "0");
        where.put("actState", "1");
        List<Map<String, String>> list = this.aolai.findList("ACTION", where);
        return this.utils.list2Map(list, "actUri", "actState");
    }

    private boolean trustedRole(Map<String, Object> params, Map<String, String> user, String uri) {
        Map<String, Object> map = this.aolai.getRoleParams(params, user);
        String key = map.get(APPCODE) + "." + map.get(COPMID) + "." + map.get(DUTYID);
        return this.redis.getActionRole(key, uri) != null;
    }

    public boolean invlidToken(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "3");
    }

    private boolean invlidParams(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "2");
    }

    private boolean denyAccess(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "5");
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter out = rsp.getWriter();
        out.write(this.utils.obj2Str(this.utils.result(status)));
        out.flush();
        out.close();
        return false;
    }

    public Object getCertKey(HttpServletRequest req) {
        String ticket = req.getParameter(TICKET);
        if (!this.utils.isEmpty(ticket) && ConfUtil.IS_API_OPEN) {
            Map<Object, Object> result = new HashMap();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("certState", "1");
            where.put("certId", ticket);
            result = this.aolai.findOne("CERT", where, "getCertInfo");
            if (result.containsKey("status")) {
                int ms = this.getMsec(req.getParameter("msec"));
                String certKey = Digest.randStr((String)result.get("certKey"));
                this.redis.set("a." + ticket, certKey, ms);
                this.redis.set("k." + certKey, ticket, ms);
                result.put("certKey", certKey);
                return this.utils.success(result);
            }
        }
        return this.utils.result("2");
    }

    private int getMsec(String msec) {
        return this.utils.isInteger(msec) ? Integer.parseInt(msec) : 36000;
    }
}

