/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.ThirdService;
import cn.ps1.aolai.service.UtilsService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class Interceptor
implements HandlerInterceptor {
    @Autowired
    private RedisService redisSvc;
    @Autowired
    private ThirdService thirdSvc;
    @Autowired
    private UtilsService utilsSvc;

    public boolean preHandle(HttpServletRequest req, HttpServletResponse rsp, Object handler) throws Exception {
        Map<String, String> cookies = this.utilsSvc.getCookies(req);
        if (!this.redisSvc.checkToken(cookies)) {
            if (this.thirdSvc.isSecretKey(req)) {
                return true;
            }
            return this.thirdSvc.invlidToken(rsp);
        }
        return this.thirdSvc.authAccess(req, rsp, cookies);
    }

    public void postHandle(HttpServletRequest req, HttpServletResponse rsp, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest req, HttpServletResponse rsp, Object handler, Exception ex) throws Exception {
    }
}

