/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Service
public class RedisService {
    private static Logger LOG = LoggerFactory.getLogger(RedisService.class);
    private static final boolean oneUser = true;
    @Autowired
    private ShardedJedisPool jedisPool;

    public boolean clearToken(Map<String, String> params) {
        if (!this.checkToken(params)) {
            return false;
        }
        LOG.debug("-> clearToken..." + params);
        String key = params.get("userId");
        this.del("t." + key);
        this.del("u." + params.get("userId"));
        return true;
    }

    public void setToken(Map<String, String> user) {
        String key = user.get("userId");
        this.hmset("t." + key, user, 7200);
        user.remove("ipaddr");
    }

    public boolean checkToken(Map<String, String> cookie) {
        String token = cookie.get("token");
        String userid = cookie.get("userId");
        String certid = cookie.get("certId");
        if (token != null && userid != null && certid != null) {
            String uid = "t." + userid;
            String str = token;
            String key = "token";
            Map<String, String> map = this.hmget(uid);
            if (map != null && str.equals(map.get(key)) && certid.equals(map.get("certId"))) {
                return this.expire(uid);
            }
        }
        return false;
    }

    public void setUserInfo(Map<String, String> user) {
        String uid = "u." + user.get("userId");
        this.hmset(uid, user, 7200);
    }

    public Map<String, String> getUserInfo(Object userId) {
        String uid = "u." + userId;
        return this.expire(uid) ? this.hmget(uid) : null;
    }

    public String set(String key, String val) {
        return this.set(key, val, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String val, int sec) {
        LOG.debug("-> set..." + key + "=" + val);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedis.setex(key, sec, val);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    public String hmset(String key, Map<String, String> map) {
        return this.hmset(key, map, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map<String, String> map, int sec) {
        LOG.debug("-> hmset..." + key + "=" + map);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedis.hmset(key, map);
            if (sec > 0) {
                this.expire(key, sec);
            }
        }
        catch (Exception e) {
            LOG.error("->hmset..." + e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hmget(String key) {
        LOG.debug("-> hmget..." + key);
        Map result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedis.hgetAll(key);
            if (result != null && result.isEmpty()) {
                result = null;
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        LOG.debug("-> hget..." + key);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedis.hget(key, field);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    public boolean hset(String key, String field, String val) {
        return this.hset(key, field, val, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hset(String key, String field, String val, int sec) {
        LOG.debug("-> hset..." + key);
        boolean result = false;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            jedis.hset(key, field, val);
            if (sec > 0) {
                this.expire(key, sec);
            }
            result = true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        LOG.debug("-> get..." + key);
        String result = null;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return null;
        }
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean del(String key) {
        boolean result = false;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            jedis.del(key);
            result = true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hdel(String key, String ... fields) {
        boolean result = false;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            jedis.hdel(key, fields);
            result = true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Boolean result = false;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (jedis == null) {
            return result;
        }
        try {
            result = jedis.exists(key);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            jedis.close();
        }
        return result;
    }

    public boolean expire(String key) {
        return this.expire(key, 7200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expire(String key, int sec) {
        Long result = 0L;
        ShardedJedis jedis = this.jedisPool.getResource();
        if (sec == 0 || jedis == null) {
            return false;
        }
        try {
            result = jedis.expire(key, sec);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            jedis.close();
        }
        return result > 0L;
    }

    public boolean isBlocked(String ip) {
        int[] num = new int[]{60, 1800, 10, 50};
        return this.isBlocked(ip, num);
    }

    public boolean isBlocked(String ip, int[] num) {
        String rds_ip = "d." + ip;
        Map<String, String> addr = this.hmget(rds_ip);
        String time = String.valueOf(new Date().getTime());
        int loop = num.length / 2;
        if (addr == null) {
            addr = new HashMap<String, String>();
            addr.put("locked", "0");
        } else {
            int i;
            if ("1".equals(addr.get("locked"))) {
                return true;
            }
            String[] arr = addr.get("time").split(",");
            int len = arr.length;
            block0: for (i = 0; i < len; ++i) {
                long diff = new Date().getTime() - Long.parseLong(arr[i]);
                for (int n = 0; n < loop; ++n) {
                    if (diff >= (long)num[0]) continue;
                    if (len - i < num[n + loop]) continue block0;
                    addr.put("locked", "1");
                    this.hmset(rds_ip, addr, loop - 1);
                    return true;
                }
            }
            while (i < len) {
                time = arr[i] + "," + time;
                ++i;
            }
        }
        addr.put("time", time);
        this.hmset(rds_ip, addr, loop - 1);
        return false;
    }
}

