/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpService {
    private static Logger LOG = LoggerFactory.getLogger(HttpService.class);
    private static Map<String, String> headers = new HashMap<String, String>();
    private static RequestConfig CONF;
    private static String APP_KEY;
    @Autowired
    private UtilsService utils = new UtilsService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpGet(String url, Map<String, String> params) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        String result = null;
        try {
            HttpGet httpGet = new HttpGet(this.setUrl(url, params));
            httpGet.setConfig(CONF);
            this.setHeaders((HttpMessage)httpGet, url);
            resp = client.execute((HttpUriRequest)httpGet);
            result = this.getString(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                LOG.error("-> doHttpGet...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{client});
                throw throwable;
            }
            this.utils.close(new Closeable[]{client});
        }
        this.utils.close(new Closeable[]{client});
        return result;
    }

    public String httpPost(String url, String jsonStr) {
        return this.httpPost(url, this.setParams(jsonStr, null));
    }

    public String httpPost(String url, String jsonStr, String key) {
        return this.httpPost(url, this.setParams(jsonStr, key));
    }

    public String httpPost(String url, Map<String, String> params) {
        return this.httpPost(url, null, params);
    }

    public String httpPost(String url, String cookies, Map<String, String> params) {
        return this.httpPost(url, cookies, params, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpPost(String url, String cookies, Map<String, String> params, String encoding) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        String result = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(CONF);
            if (cookies != null) {
                headers.put("Cookie", cookies);
            }
            this.setHeaders((HttpMessage)httpPost, url);
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            httpPost.setEntity((HttpEntity)entity);
            resp = client.execute((HttpUriRequest)httpPost);
            result = this.getString(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                LOG.error("-> httpPost..." + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{client, resp});
                throw throwable;
            }
            this.utils.close(new Closeable[]{client, resp});
        }
        this.utils.close(new Closeable[]{client, resp});
        return result;
    }

    private HttpEntity doResponse(CloseableHttpResponse resp) {
        StatusLine sLine = resp.getStatusLine();
        if (sLine.getStatusCode() == 200) {
            return resp.getEntity();
        }
        LOG.error("-> doResponse..." + sLine);
        return null;
    }

    private String getString(HttpEntity entity) {
        String result = null;
        try {
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                if (result.length() > 200) {
                    LOG.debug(result.substring(0, 200));
                } else {
                    LOG.debug(result);
                }
            }
        }
        catch (Exception e) {
            LOG.error("-> getResult...");
            e.printStackTrace();
        }
        return result;
    }

    private String setUrl(String url, Map<String, String> params) {
        if (params != null && params.size() > 0) {
            String args = "";
            for (Map.Entry<String, String> e : params.entrySet()) {
                args = args + "&" + e.getKey() + "=" + Digest.urlEncode(e.getValue());
            }
            if (args.length() > 0) {
                url = url + args.substring(1);
            }
        }
        return url;
    }

    private void setHeaders(HttpMessage msg, String url) {
        String host = this.utils.getHost(url)[0];
        String referer = url.split(":")[0] + "://" + host;
        msg.addHeader("Referer", referer);
        msg.addHeader("Origin", referer);
        msg.addHeader("Host", host);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            msg.addHeader(e.getKey(), e.getValue());
        }
    }

    private List<NameValuePair> setParams(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                if (this.utils.isEmpty(val)) continue;
                nvpList.add((NameValuePair)new BasicNameValuePair(key, val));
            }
        }
        return nvpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String digestRequest(String userName, String password, HttpUriRequest uriRequest) {
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        String result = null;
        try {
            resp = client.execute(uriRequest);
            result = this.getString(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                LOG.error("-> digestRequest...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{client});
                throw throwable;
            }
            this.utils.close(new Closeable[]{client});
        }
        this.utils.close(new Closeable[]{client});
        return result;
    }

    public String digestJsonRequest(String userName, String password, String url, String json, String method) {
        LOG.info(json);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        entity.setContentEncoding("UTF-8");
        RequestBuilder builder = this.setBuilder((HttpEntity)entity, method);
        HttpUriRequest request = builder.setUri(url).build();
        json = this.digestRequest(userName, password, request);
        LOG.info("-> digestJsonRequest..." + json);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean digestDownload(String userName, String password, String url, String filePath) {
        boolean bl;
        CloseableHttpClient client = this.digestHttpClient(userName, password);
        CloseableHttpResponse resp = null;
        try {
            HttpGet request = new HttpGet(url);
            resp = client.execute((HttpUriRequest)request);
            HttpEntity entity = resp.getEntity();
            InputStream ins = entity.getContent();
            FileOutputStream fos = new FileOutputStream(filePath, false);
            int data = ins.read();
            while (data != -1) {
                fos.write(data);
                data = ins.read();
            }
            fos.close();
            EntityUtils.consume((HttpEntity)entity);
            bl = true;
        }
        catch (Exception e) {
            try {
                LOG.error("-> digestDownload...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{client, resp});
                throw throwable;
            }
            this.utils.close(new Closeable[]{client, resp});
            return false;
        }
        this.utils.close(new Closeable[]{client, resp});
        return bl;
    }

    private RequestBuilder setBuilder(HttpEntity entity, String method) {
        RequestBuilder request = null;
        if ("POST".equals(method)) {
            request = RequestBuilder.post();
        } else if ("GET".equals(method)) {
            request = RequestBuilder.get();
        } else if ("PUT".equals(method)) {
            request = RequestBuilder.put();
        } else if ("DELETE".equals(method)) {
            request = RequestBuilder.delete();
        }
        return request.setEntity(entity);
    }

    private CloseableHttpClient digestHttpClient(String user, String pass) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
        HttpClientBuilder http = HttpClientBuilder.create();
        http.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        return http.build();
    }

    public String urlConnect(String url, Map<String, String> params) {
        return this.urlConnect(this.setUrl(url, params), "".getBytes(), "GET");
    }

    public String urlConnect(String url, String str, String method) {
        String result = "";
        if (str != null) {
            result = this.urlConnect(url, str.getBytes(Const.CHARSET), method);
        }
        return result;
    }

    public String urlConnect(String url, byte[] bytes, String method) {
        String result = "";
        HttpURLConnection conn = null;
        try {
            LOG.debug("-> urlConnect..." + url);
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            this.setProperty(conn).setRequestMethod(method);
            conn.getOutputStream().write(bytes);
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 204) {
                result = this.respAsString(conn.getInputStream());
            } else {
                result = this.respAsString(conn.getErrorStream());
                LOG.error("-> urlConnect..." + result);
            }
        }
        catch (Exception e) {
            LOG.error("-> urlConnect...");
            e.printStackTrace();
        }
        return result;
    }

    private HttpURLConnection setProperty(HttpURLConnection conn) {
        conn.setConnectTimeout(120000);
        conn.setReadTimeout(120000);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            conn.setRequestProperty(e.getKey(), e.getValue());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String respAsString(InputStream inp) {
        StringBuilder strBuf = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inp, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
        }
        catch (IOException e) {
            try {
                LOG.error("-> respAsString..." + e.getMessage());
            }
            catch (Throwable throwable) {
                this.utils.close(reader);
                throw throwable;
            }
            this.utils.close(reader);
        }
        this.utils.close(reader);
        return strBuf.toString();
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params, String key) {
        return this.doPost(url, this.utils.obj2Str(params), key);
    }

    public <T> Map<String, T> doPost(String url, Map<?, ?> params) {
        return this.doPost(url, this.utils.obj2Str(params), null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr) {
        return this.doPost(url, jsonStr, null);
    }

    public <T> Map<String, T> doPost(String url, String jsonStr, String key) {
        LOG.info("-> doPost..." + url);
        Map<String, String> params = this.setParams(jsonStr, key);
        return this.utils.json2Map(this.httpPost(url, null, params));
    }

    private Map<String, String> setParams(String jsonStr, String key) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (jsonStr != null) {
            params.put("jsonstr", jsonStr);
        }
        if (key == null) {
            key = APP_KEY == null ? ConfUtil.getConf("app.key") : APP_KEY;
        }
        params.put("k", key);
        return params;
    }

    public byte[] sendPost(String url, String jsonStr) {
        return this.sendPost(url, this.setParams(jsonStr, null));
    }

    public byte[] sendPost(String url, String jsonStr, String key) {
        return this.sendPost(url, this.setParams(jsonStr, key));
    }

    public byte[] sendPost(String url, Map<String, String> params) {
        return this.sendPost(url, null, params);
    }

    public byte[] sendPost(String url, String cookies, Map<String, String> params) {
        return this.sendPost(url, cookies, params, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendPost(String url, String cookies, Map<String, String> params, String encoding) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        byte[] bytes = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(CONF);
            if (cookies != null) {
                headers.put("Cookie", cookies);
            }
            this.setHeaders((HttpMessage)httpPost, url);
            List<NameValuePair> nvpList = this.setParams(params);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvpList, encoding);
            httpPost.setEntity((HttpEntity)entity);
            resp = client.execute((HttpUriRequest)httpPost);
            bytes = this.getStream(this.doResponse(resp));
        }
        catch (Exception e) {
            try {
                LOG.error("-> httpPost..." + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utils.close(new Closeable[]{client, resp});
                throw throwable;
            }
            this.utils.close(new Closeable[]{client, resp});
        }
        this.utils.close(new Closeable[]{client, resp});
        return bytes;
    }

    private byte[] getStream(HttpEntity entity) {
        byte[] bytes = null;
        try {
            if (entity != null) {
                bytes = EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            LOG.error("-> getStream...");
            e.printStackTrace();
        }
        return bytes;
    }

    public <T> Map<String, T> ssoPost(String ws, Map<?, ?> params) {
        return this.ssoPost(ws, this.utils.obj2Str(params));
    }

    public <T> Map<String, T> ssoPost(String ws, String jsonStr) {
        String url = ConfUtil.getConf("sso.url");
        return this.doPost(url + ws, jsonStr);
    }

    public <T> Map<String, T> forward(HttpServletRequest req) {
        String ws = this.utils.getRequestURI(req);
        return this.ssoPost(ws, this.utils.jsonParams(req));
    }

    public String forward(HttpServletRequest req, String url) {
        String str = req.getParameter("jsonstr");
        Map<String, String> params = this.setParams(str, null);
        return this.httpPost(url, req.getHeader("Cookie"), params);
    }

    public <T> Map<String, T> forward(String url, HttpServletRequest req) {
        return this.utils.json2Map(this.forward(req, url));
    }

    public <T> Map<String, T> corePost(String ws, Map<?, ?> params) {
        String main = ConfUtil.getConf("app.core") + ConfUtil.getConf("app.main");
        return this.doPost(main + ws, params);
    }

    static {
        headers.put("Accept", "*/*");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        headers.put("Accept-Language", "zh-CN, zh, en-US");
        headers.put("Cache-Control", "no-cache");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Chrome/97.0.4692.71");
        CONF = RequestConfig.custom().setRedirectsEnabled(false).setConnectTimeout(120000).setSocketTimeout(120000).build();
        APP_KEY = null;
    }
}

