/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.dao.AolaiDao;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AolaiService {
    private static Logger LOG = LoggerFactory.getLogger(AolaiService.class);
    private static final String META = "GMETA";
    private static String DOT = null;
    @Autowired
    private AolaiDao aolaiDao;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;
    private static Map<String, String> gmeta = new HashMap<String, String>();

    private Map<String, String> addRecord(String table, Map<String, String> dto, Map<String, Object> data, boolean dupl) {
        if (this.utils.isEmpty(data = this.setFieldData(dto, data, true))) {
            this.utils.result("2");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        if (dupl) {
            map.put("dupl", "1");
        }
        LOG.info("-> addRecord..." + data);
        return this.utils.result(this.aolaiDao.addOne(map, data) > 0);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(table, this.getDto(table), data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data) {
        return this.addRecord(table, data, false);
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(this.getTable(base, table), this.getDto(table), data, dupl);
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data) {
        return this.addRecord(this.getTable(base, table), this.getDto(table), data, false);
    }

    private Map<String, String> batchAdd(String table, Map<String, String> dto, List<Map<String, Object>> items, Object lang, boolean dupl) {
        if (items.size() == 0) {
            return this.utils.result("2");
        }
        Map<String, Object> data = items.get(0);
        data.put("i18n", lang);
        data = this.setFieldData(dto, data, false);
        if (this.utils.isEmpty(data)) {
            this.utils.result("2");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        if (dupl) {
            map.put("dupl", "1");
        }
        LOG.info("->batchAdd..." + map);
        return this.utils.result(this.aolaiDao.batchAdd(map, data, items) > 0);
    }

    public Map<String, String> batchAdd(Object base, String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        Map<String, String> dto = this.getDto(table);
        return this.batchAdd(this.getTable(base, table), dto, items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map, boolean dupl) {
        return this.batchAdd(map.get("base"), table, items, map.get("i18n"), dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map) {
        return this.batchAdd(map.get("base"), table, items, map.get("i18n"), false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(table, this.getDto(table), items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang) {
        return this.batchAdd(table, items, lang, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items) {
        return this.batchAdd(table, items, new HashMap<String, Object>());
    }

    public Map<String, String> batchAdd(Map<String, String> map) {
        List<Map<String, Object>> list = this.utils.json2List(map.get("fields"));
        return this.batchAdd((Object)map.get("base"), map.get("table"), list, (Object)map.get("i18n"), map.containsKey("duplte"));
    }

    private Map<String, String> delete(String table, Map<String, String> dto, Map<String, Object> where, Object joint) {
        Map<String, Object> cond = this.setCondition(dto, where, joint);
        if (cond.isEmpty()) {
            return this.utils.result("2");
        }
        LOG.info("-> delete..." + cond);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        return this.utils.result(this.aolaiDao.delete(map, cond) > 0);
    }

    public Map<String, String> delete(String table, Map<String, Object> where, Object joint) {
        return this.delete(table, this.getDto(table), where, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> where) {
        return this.delete(table, this.getDto(table), where, null);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> where, Object joint) {
        return this.delete(this.getTable(base, table), this.getDto(table), where, joint);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> where) {
        return this.delete(base, table, where, null);
    }

    public Map<String, String> delete(Map<String, String> params) {
        Map<String, Object> where = this.utils.json2Map(params.get("where"));
        return this.delete((Object)params.get("base"), params.get("table"), where);
    }

    private Map<String, String> batchDelete(String table, Map<String, String> dto, List<Map<String, Object>> list) {
        int count = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        Map<Object, Object> cond = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            cond = this.setCondition(dto, list.get(i), null);
            if (cond.isEmpty()) continue;
            map.put("table", table);
            count += this.aolaiDao.delete(map, cond);
        }
        return this.utils.result(count > 0);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list) {
        return this.batchDelete(this.getTable(base, table), this.getDto(table), list);
    }

    public Map<String, String> batchDelete(Object base, String table, Object where) {
        String str = String.valueOf(where);
        return this.batchDelete(base, table, this.utils.json2List(str));
    }

    public Map<String, String> batchDelete(String table, List<Map<String, Object>> list) {
        return this.batchDelete(table, this.getDto(table), list);
    }

    public Map<String, String> batchDelete(String table, Object where) {
        String str = String.valueOf(where);
        return this.batchDelete(table, this.utils.json2List(str));
    }

    public Map<String, String> batchDelete(Map<String, Object> params) {
        String table = String.valueOf(params.get("table"));
        return this.batchDelete(table, params.get("where"));
    }

    private Map<String, String> update(String table, Map<String, String> dto, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        Map<String, Object> cond = this.setCondition(dto, where, joint);
        Map<String, Object> values = this.setCondition(dto, fields, null);
        if (cond.isEmpty() || values.isEmpty()) {
            return this.utils.result("2");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        return this.utils.result(this.aolaiDao.update(map, values, cond) > 0);
    }

    public Map<String, String> update(Object base, String table, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        Map<String, String> dto = this.getDto(table);
        return this.update(this.getTable(base, table), dto, fields, where, joint);
    }

    public Map<String, String> update(Object base, String table, Map<String, Object> fields, Map<String, Object> where) {
        return this.update(base, table, fields, where, null);
    }

    public Map<String, String> update(String table, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        return this.update(null, table, fields, where, joint);
    }

    public Map<String, String> update(String table, Map<String, Object> fields, Map<String, Object> where) {
        return this.update(null, table, fields, where, null);
    }

    public Map<String, String> update(Map<String, String> map, Object lang) {
        Map<String, Object> fields = this.utils.json2Map(map.get("fields"));
        Map<String, Object> where = this.utils.json2Map(map.get("where"));
        fields.put("i18n", lang);
        where.put("i18n", lang);
        return this.update((Object)map.get("base"), map.get("table"), fields, where);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String alias, Map<String, Object> where, Map<String, String> order, String limit) {
        return this.findList(base, tables, alias, where, order, "left", limit);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String alias, Map<String, Object> where, Map<String, String> order, String left, String limit) {
        Map<String, String> dto = this.getMetaDto(alias);
        String table = this.joinTable(base, dto, tables, left);
        if (this.utils.isEmpty(table)) {
            return new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Object lang = this.i18nLang(where);
        map.put("table", table);
        map.put("alias", this.setAlias(dto, alias, lang));
        map.put("order", this.getOrder(dto, order, lang));
        this.setLimitRows(map, limit);
        return this.aolaiDao.findList(map, this.setCondition(dto, where, null));
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> where, Map<String, String> order) {
        String table = args.get("table");
        Map<String, String> dto = this.getDto(table);
        Object lang = this.i18nLang(where);
        String base = args.get("base");
        String alias = args.get("alias");
        String joint = args.get("joint");
        String limit = args.get("limit");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("alias", this.setAlias(dto, alias, lang));
        map.put("order", this.getOrder(dto, order, lang));
        this.setLimitRows(map, limit);
        return this.aolaiDao.findList(map, this.setCondition(dto, where, joint));
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> where) {
        return this.findList(args, where, null);
    }

    public List<Map<String, String>> findList(Object base, String table, String alias, Map<String, Object> where) {
        HashMap<String, String> args = new HashMap<String, String>();
        if (!this.utils.isEmpty(base)) {
            args.put("base", String.valueOf(base));
        }
        args.put("table", table);
        args.put("alias", alias);
        return this.findList(args, where, null);
    }

    public List<Map<String, String>> findList(String table, String alias, Map<String, Object> where) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", table);
        args.put("alias", alias);
        return this.findList(args, where, null);
    }

    private Map<String, String> findOne(String table, Map<String, String> dto, Map<String, Object> where, String keys) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        map.put("alias", this.setAlias(dto, keys, this.i18nLang(where)));
        map = this.aolaiDao.findOne(map, this.setCondition(dto, where, null));
        return this.utils.isEmpty(map) ? this.utils.result(false) : map;
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> where, String keys) {
        return this.findOne(this.getTable(base, table), this.getDto(table), where, keys);
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> where) {
        return this.findOne(this.getTable(base, table), this.getDto(table), where, null);
    }

    public Map<String, String> findOne(String table, Map<String, Object> where, String keys) {
        return this.findOne(null, table, where, keys);
    }

    public Map<String, String> findOne(String table, Map<String, Object> where) {
        return this.findOne(null, table, where, null);
    }

    public Map<String, String> findOne(Map<String, String> map, String keys) {
        Map<String, Object> where = this.utils.json2Map(map.get("where"));
        return this.findOne((Object)map.get("base"), map.get("table"), where, keys);
    }

    public Map<String, String> findOne(Map<String, String> map) {
        return this.findOne(map, null);
    }

    private Map<String, String> queryOne(String table, Map<String, String> dto, String alias, Map<String, Object> where) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        map.put("alias", alias);
        return this.aolaiDao.findOne(map, this.setCondition(dto, where, null));
    }

    public Map<String, String> queryOne(Object base, String table, String alias, Map<String, Object> where) {
        return this.queryOne(this.getTable(base, table), this.getDto(table), alias, where);
    }

    public Map<String, String> queryOne(String table, String alias, Map<String, Object> where) {
        return this.queryOne(table, this.getDto(table), alias, where);
    }

    @Deprecated
    public List<Map<String, String>> query(String sql) {
        return this.aolaiDao.query(sql);
    }

    private boolean exists(String table, Map<String, String> dto, Map<String, Object> where, Object joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", table);
        return this.aolaiDao.countRows(map, this.setCondition(dto, where, joint)) > 0;
    }

    public boolean exists(Object base, String table, Map<String, Object> where, Object joint) {
        Map<String, String> dto = this.getDto(table);
        return this.exists(this.getTable(base, table), dto, where, joint);
    }

    public boolean exists(Object base, String table, Map<String, Object> where) {
        return this.exists(base, table, where, null);
    }

    public boolean exists(String table, Map<String, Object> where, Object joint) {
        return this.exists(table, this.getDto(table), where, joint);
    }

    public boolean exists(String table, Map<String, Object> where) {
        return this.exists(table, this.getDto(table), where, null);
    }

    public boolean exists(Map<String, String> map) {
        Map<String, Object> where = this.utils.json2Map(map.get("where"));
        return this.exists((Object)map.get("base"), map.get("table"), where);
    }

    public int count(String table, Map<String, Object> where) {
        return this.count(null, table, where, null);
    }

    public int count(Object base, String table, Map<String, Object> where) {
        return this.count(base, table, where, null);
    }

    public int count(Object base, String table, Map<String, Object> where, String joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        where = this.setCondition(this.getDto(table), where, joint);
        return this.aolaiDao.countRows(map, where);
    }

    @Deprecated
    private List<Map<String, String>> getMenuRole(Map<String, Object> map, String keys, String table) {
        Map<String, String> dto = this.getDto(table);
        map.put("alias", this.setAlias(dto, keys, this.i18nLang(map)));
        return this.aolaiDao.getMenuRole(map);
    }

    @Deprecated
    public List<Map<String, String>> getMenuRole(Map<String, Object> map) {
        return this.getMenuRole(map, "getMenuRole", "PAGE");
    }

    @Deprecated
    public List<Map<String, String>> getActionRole(Map<String, Object> map) {
        return this.getActionRole(map, "getActionRole", "ROLE");
    }

    @Deprecated
    private List<Map<String, String>> getActionRole(Map<String, Object> map, String keys, String table) {
        Map<String, String> dto = this.getDto(table);
        map.put("alias", this.setAlias(dto, keys, this.i18nLang(map)));
        return this.aolaiDao.getActionRole(map);
    }

    public String getParam(Object base, String paramKey) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        Map<Object, Object> result = new HashMap();
        where.put("paramKey", paramKey);
        result = this.findOne(base, "PARAM", where, "getParamVal");
        return (String)result.get("paramVal");
    }

    public String getParam(Map<String, Object> params, String paramKey) {
        return this.getParam(params.get("base"), paramKey);
    }

    private String i18n(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        if (dto.containsKey(key + "!i") && !this.utils.isEmpty(lang)) {
            field = field + "_" + lang;
        }
        return field;
    }

    private <T> Object i18nLang(Map<String, T> params) {
        return params == null ? null : params.get("i18n");
    }

    private void setLimitRows(Map<String, String> map, String limit) {
        if (this.utils.isEmpty(limit) || !this.utils.isInteger(limit)) {
            map.put("limit", ConfUtil.getConf("limit.rows"));
        } else if (!"0".equals(limit)) {
            map.put("limit", limit);
        }
    }

    private String getOrder(Map<String, String> dto, Map<String, String> order, Object lang) {
        String str = "";
        if (this.utils.isEmpty(order)) {
            for (Map.Entry<String, String> e : dto.entrySet()) {
                String key = e.getKey();
                if (key.indexOf("!p") <= 0 || !"1".equals(e.getValue())) continue;
                if (str.length() > 0) {
                    str = str + ",";
                }
                key = key.substring(0, key.indexOf("!p"));
                str = str + dto.get(key);
            }
            return str;
        }
        for (Map.Entry<String, String> e : order.entrySet()) {
            String key = e.getKey();
            if (!dto.containsKey(key)) continue;
            if (str.length() > 0) {
                str = str + ",";
            }
            String field = this.i18n(dto, key, lang);
            str = str + field + " " + e.getValue();
        }
        return str;
    }

    private <T> Map<String, T> setCondition(Map<String, String> dto, Map<String, T> where, Object joint) {
        HashMap<String, T> cond = new HashMap<String, T>();
        if (!this.utils.isEmpty(where)) {
            Object lang = this.i18nLang(where);
            for (Map.Entry<String, T> e : where.entrySet()) {
                String key = e.getKey();
                if (dto.containsKey(key)) {
                    joint = joint == null ? "=" : " " + joint;
                    key = this.i18n(dto, key, lang) + joint;
                    cond.put(key, e.getValue());
                    continue;
                }
                if (!Pattern.compile("\\{").matcher(key).find() || (key = this.getWhere(dto, key, lang)) == null) continue;
                cond.put(key, e.getValue());
            }
        }
        return cond;
    }

    public String getWhere(Map<String, String> dto, String expr) {
        return this.getWhere(dto, expr, null);
    }

    public String getWhere(Map<String, String> dto, String expr, Object lang) {
        String[] arr = expr.split("\\{");
        if (arr.length > 1 && this.isValidExpr(arr[0])) {
            for (int i = 1; i < arr.length; ++i) {
                String[] key = arr[i].split("\\}");
                if (!dto.containsKey(key[0]) || !this.isValidExpr(key[1])) {
                    return null;
                }
                key[0] = this.i18n(dto, key[0], lang);
                arr[i] = key[0] + key[1];
            }
            return this.utils.arr2Str(arr);
        }
        return null;
    }

    private boolean isValidExpr(String expr) {
        if ((expr = expr.trim()).length() > 0) {
            String[] arr;
            for (String str : arr = expr.toUpperCase().split(" ")) {
                if (str.length() <= 0 || this.utils.findIn(Const.SQL_EXPR, str)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> setFieldData(Map<String, String> dto, Map<String, Object> params, boolean isVal) {
        if (this.utils.isEmpty(params)) {
            return null;
        }
        Object lang = this.i18nLang(params);
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            if (!dto.containsKey(key)) continue;
            key = this.i18n(dto, key, lang);
            data.put(key, isVal ? e.getValue() : e.getKey());
        }
        return data;
    }

    public String setAlias(Object table, Object lang) {
        return this.setAlias(this.getDto(table), null, lang);
    }

    public String setAlias(Object table, String keys, Object lang) {
        return this.setAlias(this.getDto(table), keys, lang);
    }

    private String setAlias(Map<String, String> dto, String keys, Object lang) {
        if (this.utils.isEmpty(keys)) {
            return this.setAlias(dto, lang);
        }
        String val = ConfUtil.getParam(keys);
        if (val.length() == 0) {
            return this.setAlias(dto, lang);
        }
        String[] arr = val.split(";");
        String alias = "";
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                alias = alias + ",";
            }
            alias = alias + this.setAlias(arr[i], dto, lang);
        }
        return alias;
    }

    private String setAlias(Map<String, String> dto, Object lang) {
        String alias = "";
        for (String key : dto.keySet()) {
            if (key.contains("!")) continue;
            if (alias.length() > 0) {
                alias = alias + ",";
            }
            alias = alias + this.setAlias(key, dto, lang);
        }
        return alias;
    }

    private String setAlias(String key, Map<String, String> dto, Object lang) {
        String val = dto.get(key);
        String type = dto.get(key + "!t");
        if (type != null) {
            if (type.matches("[IDBS].+") || type.matches("TIN.+")) {
                val = "CAST(" + val + " AS CHAR)";
            } else if (type.matches("T.+")) {
                val = "DATE_FORMAT(" + val + ",'%Y-%m-%d %T')";
            } else if (dto.containsKey(key + "!i") && !this.utils.isEmpty(lang)) {
                val = val + "_" + lang;
            }
        }
        return val + " as '" + key + "'";
    }

    public String getFieldAlias(List<Map<String, String>> meta, Object lang) {
        return this.setAlias(this.getDto(meta), lang);
    }

    private Map<String, String> getDto(Object table) {
        String key = "m." + table;
        Map<String, String> dto = this.redis.hmget(key);
        if (dto == null && (dto = this.getDto(this.getMetaList(table))) != null) {
            this.redis.hmset(key, dto, 36000);
        }
        return dto;
    }

    private Map<String, String> getDto(List<Map<String, String>> metaList) {
        if (metaList.size() == 0) {
            return null;
        }
        HashMap<String, String> dto = new HashMap<String, String>();
        for (int i = 0; i < metaList.size(); ++i) {
            Map<String, String> meta = metaList.get(i);
            String alias = meta.get("alias");
            dto.put(alias, meta.get("field"));
            dto.put(alias + "!t", meta.get("type"));
            dto.put(alias + "!p", meta.get("pkey"));
            if (!"1".equals(meta.get("i18n"))) continue;
            dto.put(alias + "!i", meta.get("i18n"));
        }
        return dto;
    }

    public String[] getDtoKeys() {
        return this.getDtoKeys(gmeta);
    }

    public String[] getDtoKeys(Map<String, String> map) {
        String[] keys = new String[map.size() + 1];
        map.keySet().toArray(keys);
        keys[map.size()] = "table";
        return keys;
    }

    public String[] getDtoKeys(String table) {
        List<Map<String, String>> list = this.getMetaList(table);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map<String, String> meta : list) {
            if (!"1".equals(meta.get("pkey"))) continue;
            map.put(meta.get("alias"), meta.get("field"));
        }
        return this.getDtoKeys(map);
    }

    public List<Map<String, String>> getMetaList(Object table) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> cond = new HashMap<String, Object>();
        map.put("table", META);
        map.put("alias", this.setAlias(gmeta, null));
        map.put("order", "META_SORT");
        cond.put("META_TABLE=", table);
        return this.aolaiDao.findList(map, cond);
    }

    public List<Map<String, String>> getMeta(String alias) {
        String val = ConfUtil.getParam(alias);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alias", this.setAlias(gmeta, null));
        String[] cond = val.length() == 0 ? null : val.split(";");
        return this.aolaiDao.getMetaInfo(map, cond);
    }

    private Map<String, String> getMetaDto(String alias) {
        String key = "m." + alias;
        Map<String, String> dto = this.redis.hmget(key);
        if (dto == null && (dto = this.getDto(this.getMeta(alias))) != null) {
            this.redis.hmset(key, dto, 36000);
        }
        return dto;
    }

    private String joinTable(Object base, Map<String, String> dto, Map<String, Map<String, String>> tables, String left) {
        if (this.utils.isEmpty(tables)) {
            return null;
        }
        String s = "";
        String t = "";
        for (String tableName : tables.keySet()) {
            Map<String, String> map = tables.get(tableName);
            tableName = this.getTable(base, tableName);
            if (this.utils.isEmpty(map)) {
                if (s.length() != 0) continue;
                s = tableName;
                continue;
            }
            int n = 0;
            t = t + " " + left + " join " + tableName + " on ";
            for (Map.Entry<String, String> ent : map.entrySet()) {
                if (n > 0) {
                    t = t + " and ";
                }
                t = t + this.i18n(dto, ent.getKey(), null) + "=";
                t = t + this.i18n(dto, ent.getValue(), null);
                ++n;
            }
        }
        if (s.length() == 0) {
            return null;
        }
        return t.length() == 0 ? s : s + t;
    }

    public String getTable(Object base, String table) {
        if (this.utils.isEmpty(base)) {
            return table;
        }
        if (DOT == null) {
            String dot = ConfUtil.getConf("base.dot");
            DOT = this.utils.isEmpty(dot) ? "." : dot;
        }
        return base + DOT + table;
    }

    private Map<String, String> getMetaDto() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(gmeta);
        map.put("table", "META_TABLE");
        return map;
    }

    public Map<String, String> addMeta(Map<String, Object> data, boolean dupl) {
        return this.addRecord(META, this.getMetaDto(), data, dupl);
    }

    public Map<String, String> delMeta(List<Map<String, Object>> list) {
        return this.batchDelete(META, this.getMetaDto(), list);
    }

    public List<Map<String, String>> getMetaTable() {
        return this.aolaiDao.getMetaTable();
    }

    public boolean tableExists(Object base, String table) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("TABLE_SCHEMA", base);
        cond.put("TABLE_NAME", table);
        map.put("table", "information_schema.TABLES");
        return this.aolaiDao.countRows(map, cond) > 0;
    }

    public boolean columnExists(Object base, String table) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("TABLE_SCHEMA=", base);
        cond.put("COLUMN_NAME=", table);
        map.put("table", "information_schema.COLUMNS");
        return this.aolaiDao.countRows(map, cond) > 0;
    }

    public Map<String, String> dropTable(Object base, String table) {
        if (!this.utils.isMatch(table, "[_a-zA-Z0-9]+$")) {
            return this.utils.result("2");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        this.redis.del("m." + table);
        this.aolaiDao.drop(map);
        return this.utils.success();
    }

    public Map<String, String> createTable(Object base, String table) {
        if (!this.utils.isMatch(table, "[_a-zA-Z0-9]+$")) {
            return this.utils.result("2");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fields", this.getMetaSql(this.getMetaList(table)));
        map.put("table", this.getTable(base, table));
        LOG.debug("-> createTable..." + map);
        this.aolaiDao.create(map);
        return this.utils.success();
    }

    private String getMetaSql(List<Map<String, String>> meta) {
        String sql = "";
        String pkey = "";
        String[] lang = this.utils.getLocales();
        for (int i = 0; i < meta.size(); ++i) {
            String field;
            Map<String, String> map;
            if (i > 0) {
                sql = sql + ",";
            }
            if ("1".equals((map = meta.get(i)).get("i18n"))) {
                for (int j = 0; j < lang.length; ++j) {
                    if (j > 0) {
                        sql = sql + ",";
                    }
                    field = map.get("field") + "_" + lang[j];
                    sql = sql + field + " " + map.get("type");
                    if (map.get("null").equals("1")) {
                        sql = sql + " NOT NULL";
                    }
                    if (map.get("pkey").equals("1")) {
                        if (pkey.length() > 0) {
                            pkey = pkey + ",";
                        }
                        pkey = pkey + field;
                    }
                    if (map.get("default").length() <= 0) continue;
                    sql = sql + " DEFAULT " + map.get("default");
                }
                continue;
            }
            field = map.get("field");
            sql = sql + field + " " + map.get("type");
            if (map.get("null").equals("1")) {
                sql = sql + " NOT NULL";
            }
            if (map.get("pkey").equals("1")) {
                if (pkey.length() > 0) {
                    pkey = pkey + ",";
                }
                pkey = pkey + field;
            }
            if (map.get("default").length() <= 0) continue;
            sql = sql + " DEFAULT " + map.get("default");
        }
        if (pkey.length() > 0) {
            sql = sql + ",PRIMARY KEY (" + pkey + ")";
        }
        return sql;
    }

    public int getMaxCode(Object base, String table, String field) {
        return this.getMaxCode(base, table, field, null);
    }

    public int getMaxCode(Object base, String table, String field, Map<String, Object> where) {
        Map<String, String> dto = this.getDto(table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", dto.get(field));
        return this.aolaiDao.getMaxCode(map, this.setCondition(dto, where, null));
    }

    static {
        gmeta.put("field", "META_FIELD");
        gmeta.put("alias", "META_ALIAS");
        gmeta.put("name", "META_NAME");
        gmeta.put("type", "META_TYPE");
        gmeta.put("null", "META_NULL");
        gmeta.put("i18n", "META_I18N");
        gmeta.put("pkey", "META_PKEY");
        gmeta.put("width", "META_WIDTH");
        gmeta.put("default", "META_DEFAULT");
        gmeta.put("sort", "META_SORT");
    }
}

