package cn.ps1.aolai.utils;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;


//import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * 系统配置密码的解码
 * 
 * @author Aolai
 * @since 1.8 $Date: 2021.11.17
 *
 */
public class EncConfigurer extends PropertySourcesPlaceholderConfigurer {

//    String[] propKeys = { "jdbc.username", "jdbc.password", "redis.password" };

	// 注入需要解密的keys
	private Set<String> decodeKeys;

	/**
	 * 覆盖父类方法，重新加载参数
	 * 
	 * @param props
	 * @throws IOException
	 */
	@Override
	protected void loadProperties(Properties props) throws IOException {

		super.loadProperties(props);

		if (decodeKeys == null || decodeKeys.size() == 0) {
			return;
		}

		for (String key : props.stringPropertyNames()) {
			if (decodeKeys.contains(key)) {
				// getDecryptString 是解密的方法，根据需要自己编写。
				String val = this.decryptString(props.getProperty(key));
				props.setProperty(key, val);
			}
		}
	}

	public Set<String> getDecodeKeys() {
		return decodeKeys;
	}

	public void setDecodeKeys(Set<String> decodeKeys) {
		this.decodeKeys = decodeKeys;
	}

	/**
	 * 解密逻辑
	 * 
	 * @param decodeStr
	 * @return
	 */
	private String decryptString(String decodeStr) {
		if (decodeStr == null) {
			return "";
		}
		return Digest.decrypt(decodeStr, Digest.KEY);
	}
	
//	@Override
//	protected String convertProperty(String propKey, String propVal) {
//		return isEncrypt(propKey) ? Digest.encrypt(propVal, Digest.KEY) : propVal;
//	}
//
//	private boolean isEncrypt(String propKey) {
//		if (propKey.indexOf("password") > 0 || propKey.indexOf("username") > 0) {
//			return true;
//		}
//		return false;
//	}

	/**
	 * 测试
	 */
	public static void main(String[] args) {
		try {
			System.out.println(Digest.encrypt("root", Digest.KEY));
			System.out.println(Digest.encrypt("ykj1036!", Digest.KEY));
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}

	}
}
