package cn.ps1.aolai.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * Aolai基础框架相关业务
 * 
 * @author Aolai
 * @version 1.0 $Date: 2019.7.6
 * @since 1.7
 */

@Repository
public interface AolaiDao {

	/**
	 * 创建表（不推荐）
	 * @param map
	 */
	@Deprecated
	public void create(Map<String, String> map);

	/**
	 * 删除表（不推荐）
	 * @param map
	 */
	@Deprecated
	public void drop(Map<String, String> map);

	/**
	 * 修改表（不推荐）
	 * @param map
	 */
	@Deprecated
	public void alter(Map<String, String> map);

	/**
	 * 组合条件检索表中的数据（不推荐）
	 * 
	 * @param sql
	 * @return list 结果数据一览
	 */
	@Deprecated
	public List<Map<String, String>> query(@Param("sql") String sql);

	/**
	 * 往表中插入一条数据
	 * 
	 * @param map 表名table、更新标记dupl等
	 * @param data 插入数据
	 * @return int 成功行数
	 */
	public int addOne(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data);

	/**
	 * 批量往表中插入数据
	 * 
	 * @param map 表名table、更新标记dupl等
	 * @param data 字段信息
	 * @param list 插入数据列表
	 * @return int 成功行数
	 */
	public int batchAdd(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data,
			@Param("list") List<Map<String, Object>> list);

	/**
	 * 删除表中的数据
	 * 
	 * @param map 表名table等
	 * @param cond 删除条件
	 * @return int 成功行数
	 */
	public int delete(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 更新表中的数据
	 * 
	 * @param map 表名table、别名alias等
	 * @param values 更新数值
	 * @param cond 更新条件
	 * @return int 成功行数
	 */
	public int update(@Param("map") Map<String, String> map,
			@Param("values") Map<String, Object> values,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 批量查出表中的数据
	 * 
	 * @param map 表名table、别名alias等
	 * @param cond 查询条件
	 * @return list 结果数据一览
	 */
	public List<Map<String, String>> findList(
			@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 查出表中的一条记录，限定了只返回一条记录
	 * 
	 * @param map 表名table、别名alias等
	 * @param cond 查询条件
	 * @return list 结果数据一览
	 */
	public Map<String, String> findOne(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 判断表中是否有数据
	 * 
	 * @param map 表名table等
	 * @param cond 查询条件
	 * @return int 结果行数
	 */
	public int exists(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 从 Meta表中获取所有相关的表一览
	 */
	public List<Map<String, String>> getMetaTable();
	
	/**
	 * 从 Meta表中获取元数据信息一览
	 */
	public List<Map<String, String>> getMetaInfo(
			@Param("map") Map<String, String> map,
			@Param("cond") String[] cond);

	/**
	 * 根据用户的岗位（dutyId）获取某个应用（pageApp）的菜单控制权限
	 * @param map 查询条件
	 * @return list 结果数据一览
	 */
	@Deprecated
	public List<Map<String, String>> getMenuRole(Map<String, Object> map);

	/**
	 * 根据用户的岗位（dutyId）获取某个账套（baseId）页面（pageRoute）的按钮控制权限
	 * @param map 查询条件
	 * @return list 结果数据一览
	 */
	@Deprecated
	public List<Map<String, String>> getActionRole(Map<String, Object> map);

	/**
	 * 获取当前某个表中某个字段最大编码
	 */
	public int getMaxCode(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

}
