/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
    private static String AppKey = null;
    private static String Md5Key = null;
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;

    private boolean checkAppKey(Object k) {
        if (Md5Key == null) {
            AppKey = this.utils.getConf("app.key");
            Md5Key = DigestUtils.md5Hex((String)AppKey);
        }
        return AppKey.equals(k) || Md5Key.equals(k);
    }

    public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) {
        if (!cookies.containsKey("userId") || cookies.containsKey("bindId")) {
            // empty if block
        }
        return false;
    }

    public boolean isSecretKey(HttpServletRequest req) {
        String k = req.getParameter("k");
        if (k == null) {
            return false;
        }
        String jsonStr = req.getParameter("jsonstr");
        if (this.checkAppKey(k)) {
            if (jsonStr == null) {
                return true;
            }
            return this.setAttr(req, this.utils.json2Map(jsonStr));
        }
        String ticket = this.redis.get("k." + k);
        if (ticket == null) {
            return false;
        }
        Map map = this.utils.json2Map(jsonStr = Digest.decrypt(jsonStr, ticket + k));
        if (!ticket.equals(map.get("ticket"))) {
            return false;
        }
        String certId = this.redis.get("a." + ticket);
        if (certId != null && k.equals(certId)) {
            return this.setAttr(req, map);
        }
        return false;
    }

    private boolean setAttr(HttpServletRequest req, Object obj) {
        req.setAttribute("json", obj);
        return true;
    }

    public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) throws Exception {
        String dbid;
        String cert = cookies.get("certId");
        String userId = Digest.decrypt(cookies.get("userId"), cert);
        Map<String, String> user = this.redis.getUserInfo(userId);
        if (user == null) {
            this.redis.clearToken(cookies);
            return this.invlidToken(rsp);
        }
        String args = this.utils.getValid(this.utils.getRequestURI(req));
        Map<String, Object> params = this.decryptParams(req, user, cert);
        LOG.info("-> authAccess..." + params.toString());
        if (args.length() > 0 && !this.utils.availParams(params, args.split(";"))) {
            return this.invlidParams(rsp);
        }
        String appCode = this.utils.getConf("app.code");
        String string = dbid = this.utils.isEmpty(this.utils.getConf("base.dbid")) ? "baseId" : "dbid";
        if (params.containsKey(dbid)) {
            Map baseMap = this.utils.json2Map(user.get("userBase"));
            String dutyBase = (String)baseMap.get(appCode);
            String baseId = String.valueOf(params.get(dbid));
            if (!(this.utils.isEmpty(dutyBase) || "0".equals(dutyBase) || baseId.equals(dutyBase))) {
                return this.invlidParams(rsp);
            }
        }
        if (appCode.length() > 0) {
            String[] keys;
            Map dutyMap = this.utils.json2Map(user.get("userDuty"));
            boolean isValid = false;
            for (String key : keys = appCode.split(";")) {
                if (!dutyMap.containsKey(key)) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                return this.invlidParams(rsp);
            }
        }
        return true;
    }

    private Map<String, Object> decryptParams(HttpServletRequest req, Map<String, String> user, String cert) {
        req.setAttribute("user", user);
        req.setAttribute("userId", (Object)user.get("userId"));
        req.setAttribute("certId", (Object)cert);
        String jsonStr = req.getParameter("jsonstr");
        HashMap<String, Object> params = new HashMap();
        if (jsonStr != null) {
            jsonStr = Digest.decrypt(jsonStr, cert);
            params = this.utils.json2Map(jsonStr);
        }
        LOG.info("-> jsonStr..." + ((Object)params).toString());
        req.setAttribute("json", params);
        return params;
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter out = rsp.getWriter();
        out.write(this.utils.obj2Str(this.utils.result(status)));
        out.flush();
        out.close();
        return false;
    }

    public boolean invlidToken(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "3");
    }

    public boolean invlidParams(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "2");
    }

    public Object getCertKey(HttpServletRequest req) {
        String ticket = req.getParameter("ticket");
        if (!this.utils.isEmpty(ticket) && "true".equals(this.utils.getConf("api.open"))) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            Map<Object, Object> result = new HashMap();
            where.put("certState", "1");
            where.put("certId", ticket);
            result = this.aolai.findOne("CERT", where, "getCertInfo");
            if (result.containsKey("status")) {
                int ms = this.getMsec(req.getParameter("msec"));
                String certKey = Digest.randStr((String)result.get("certKey"));
                this.redis.set("a." + ticket, certKey, ms);
                this.redis.set("k." + certKey, ticket, ms);
                result.put("certKey", certKey);
                return this.utils.success(result);
            }
        }
        return this.utils.result("2");
    }

    private int getMsec(String msec) {
        try {
            if (this.utils.isInteger(msec)) {
                return Integer.parseInt(msec);
            }
        }
        catch (Exception e) {
            LOG.error("-> getMsec..." + e.getMessage());
        }
        return 36000;
    }
}

