/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.Digest;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public class EncConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private Set<String> decodeKeys;

    protected void loadProperties(Properties props) throws IOException {
        super.loadProperties(props);
        if (this.decodeKeys == null || this.decodeKeys.size() == 0) {
            return;
        }
        for (String key : props.stringPropertyNames()) {
            if (!this.decodeKeys.contains(key)) continue;
            String val = this.decryptString(props.getProperty(key));
            props.setProperty(key, val);
        }
    }

    public Set<String> getDecodeKeys() {
        return this.decodeKeys;
    }

    public void setDecodeKeys(Set<String> decodeKeys) {
        this.decodeKeys = decodeKeys;
    }

    private String decryptString(String decodeStr) {
        if (decodeStr == null) {
            return "";
        }
        return Digest.decrypt(decodeStr, Digest.KEY);
    }

    public static void main(String[] args) {
        try {
            System.out.println(Digest.encrypt("root", Digest.KEY));
            System.out.println(Digest.encrypt("ykj1036!", Digest.KEY));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

