/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.Const;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Digest {
    static final String CHARS64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    public static String KEY = "DFJKMQSVWXZ";
    static ScriptEngineManager sem = new ScriptEngineManager();
    static ScriptEngine se = sem.getEngineByExtension("js");
    public static Random rand = new Random();

    public static String randInt(int len) {
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = str + String.valueOf(rand.nextInt(10));
        }
        return str;
    }

    public static String randKey() {
        return Digest.randStr(KEY, 11);
    }

    public static String randStr() {
        return Digest.randStr(26);
    }

    public static String randStr(int len) {
        return Digest.randStr(CHARS64.substring(0, len), len);
    }

    public static String randStr(String str) {
        return Digest.randStr(str, str.length());
    }

    public static String randStr(String str, int len) {
        char[] charArr = str.toCharArray();
        for (int i = 0; i < len; ++i) {
            int idx = rand.nextInt(str.length());
            if (idx == i) continue;
            char c = charArr[idx];
            charArr[idx] = charArr[i];
            charArr[i] = c;
        }
        return new String(Arrays.copyOf(charArr, len));
    }

    public static String certStr(String str, String key) {
        String cert = str + key;
        return cert.toUpperCase() + cert.toLowerCase() + CHARS64.substring(52);
    }

    public static String certStr(String key) {
        if (key == null) {
            return CHARS64;
        }
        if (key.length() == 26) {
            return Digest.certStr(key, "");
        }
        if (key.length() > 64) {
            return key;
        }
        return Digest.certStr("uncopyrightable", key);
    }

    public static String encrypt(String str) {
        return Digest.encrypt(str, CHARS64);
    }

    public static String encrypt(byte[] bytes) {
        return Digest.encrypt(bytes, CHARS64);
    }

    public static String encrypt(String str, String cert) {
        if (str == null) {
            return str;
        }
        return Digest.encrypt(str.getBytes(Const.CHARSET), cert);
    }

    public static String encrypt(byte[] bytes, String cert) {
        cert = Digest.certStr(cert);
        byte[] keys = cert.getBytes(Const.CHARSET);
        byte[] out = new byte[(bytes.length + 2) / 3 * 4];
        int i = 0;
        int idx = 0;
        while (i < bytes.length) {
            int b;
            boolean[] trip = new boolean[]{true, false, false};
            int bit = 0xFF & bytes[i];
            for (b = 1; b < 3; ++b) {
                bit <<= 8;
                if (i >= bytes.length - b) continue;
                bit |= 0xFF & bytes[i + b];
                trip[b] = true;
            }
            for (b = 0; b < 3; ++b) {
                out[idx + 3 - b] = keys[trip[2 - b] ? bit & 0x3F : 64];
                bit >>= 6;
            }
            out[idx] = keys[bit & 0x3F];
            i += 3;
            idx += 4;
        }
        return new String(out);
    }

    public static String decrypt(String str) {
        return Digest.decrypt(str, CHARS64);
    }

    public static byte[] decrypt(char[] arr) {
        return Digest.decrypt(arr, CHARS64);
    }

    public static String decrypt(String str, String cert) {
        if (str == null) {
            return str;
        }
        byte[] bytes = Digest.decrypt(str.toCharArray(), cert);
        return new String(bytes, Const.CHARSET);
    }

    public static byte[] decrypt(char[] arr, String cert) {
        cert = Digest.certStr(cert);
        char end = cert.charAt(cert.length() - 1);
        int len = arr.length * 6 / 8;
        int i = arr.length - 1;
        while (arr[i] == end) {
            --len;
            --i;
        }
        byte[] raw = new byte[len];
        int[] quad = new int[4];
        int rawIdx = 0;
        for (int i2 = 0; i2 < arr.length; i2 += 4) {
            int block = 0;
            for (int idx = 0; idx < 4; ++idx) {
                char c = arr[i2 + idx];
                quad[idx] = c == end ? 0 : cert.indexOf(c);
                block += quad[idx] << 6 * (3 - idx);
            }
            for (int b = 0; b < 3 && rawIdx + b < raw.length; ++b) {
                raw[rawIdx + b] = (byte)(block >> 8 * (2 - b) & 0xFF);
            }
            rawIdx += 3;
        }
        return raw;
    }

    public static String escape(String src) {
        try {
            Object obj = se.eval("escape('" + src + "')");
            return String.valueOf(obj);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String unescape(String src) {
        try {
            Object obj = se.eval("unescape('" + src + "')");
            return String.valueOf(obj);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String encodeURIComponent(String src) {
        try {
            Object obj = se.eval("encodeURIComponent('" + src + "')");
            return String.valueOf(obj);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String decodeURIComponent(String src) {
        try {
            Object obj = se.eval("decodeURIComponent('" + src + "')");
            return String.valueOf(obj);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String imgEncode(String imgFile) {
        byte[] buf = null;
        try {
            FileInputStream in = new FileInputStream(imgFile);
            buf = new byte[((InputStream)in).available()];
            ((InputStream)in).read(buf);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return new BASE64Encoder().encode(buf);
    }

    public static boolean imgDecode(String imgStr, String imgFile) {
        try {
            byte[] buf = new BASE64Decoder().decodeBuffer(imgStr);
            FileOutputStream out = new FileOutputStream(imgFile);
            ((OutputStream)out).write(buf);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid8() {
        char c = CHARS64.charAt(rand.nextInt(62));
        return Digest.encode(System.currentTimeMillis(), 62) + c;
    }

    public static String enBase64(long num) {
        return Digest.encode(num, 64);
    }

    public static String enBase62(long num) {
        return Digest.encode(num, 62);
    }

    private static String encode(long num, int n) {
        StringBuffer buf = new StringBuffer();
        while (num > 0L) {
            char c = CHARS64.charAt(new Long(num % (long)n).intValue());
            buf.append(c);
            num /= (long)n;
        }
        return buf.reverse().toString();
    }

    public static long deBase64(String str) {
        return Digest.decode(str, 64);
    }

    public static long deBase62(String str) {
        return Digest.decode(str, 62);
    }

    private static long decode(String str, int n) {
        long result = 0L;
        long radix = 1L;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(str.length() - 1 - i);
            result += (long)CHARS64.indexOf(c) * radix;
            radix *= (long)n;
        }
        return result;
    }

    public static String enBase62(String str, int n) {
        try {
            long num = Long.valueOf(str.substring(0, str.length() - n));
            return Digest.enBase62(num) + str.substring(str.length() - n);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String deBase62(String str, int n) {
        String num = str.substring(0, str.length() - n);
        return Digest.deBase62(num) + str.substring(str.length() - n);
    }
}

