/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UtilsService {
    private static Logger LOG = LoggerFactory.getLogger(UtilsService.class);
    private static ObjectMapper jsonMapper = new ObjectMapper();

    public String getConf(String key) {
        return ConfUtil.getConf(key);
    }

    public String getArgs(String key) {
        return ConfUtil.getParam(key);
    }

    public String getValid(String key) {
        return ConfUtil.getValid(key);
    }

    @Deprecated
    public Map<String, Object> decryptParams(HttpServletRequest req, String userId, String certId) {
        String jsonStr = req.getParameter("jsonstr");
        Map<Object, Object> params = new HashMap();
        if (jsonStr != null) {
            params = this.json2Map(Digest.decrypt(jsonStr, certId));
        }
        LOG.info("-> jsonStr..." + params.toString());
        req.setAttribute("json", params);
        req.setAttribute("certId", (Object)certId);
        req.setAttribute("userId", (Object)userId);
        return params;
    }

    public Map<String, Object> jsonParams(HttpServletRequest req) {
        Map<String, Object> params = this.obj2Map(req.getAttribute("json"));
        if (params.isEmpty()) {
            Enumeration map = req.getParameterNames();
            while (map.hasMoreElements()) {
                String key = (String)map.nextElement();
                String val = req.getParameter(key);
                if (val.length() == 0) continue;
                params.put(key, val);
            }
        }
        if (!params.containsKey("i18n")) {
            Map<String, String> user = this.userSelf(req);
            String lang = user.get("userLang");
            if (lang == null || lang.isEmpty()) {
                lang = this.getLocale(req);
            }
            params.put("i18n", lang.toUpperCase());
        }
        if (params.containsKey("baseId")) {
            params.put("base", this.getConf("base.name") + params.get("baseId"));
        }
        return params;
    }

    public Map<String, String> userSelf(HttpServletRequest req) {
        return this.obj2Map(req.getAttribute("user"));
    }

    public Object getAttr(HttpServletRequest req, String key) {
        return req.getAttribute(key);
    }

    public <T> boolean availParams(Map<String, T> map, String key) {
        return this.availParams(map, new String[]{key});
    }

    public <T> boolean availParams(Map<String, T> map, String[] keys) {
        if (keys.length == 0) {
            return true;
        }
        if (this.isEmpty(map)) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (map.containsKey(keys[i])) continue;
            return false;
        }
        return true;
    }

    public int[] num2Arr(String numStr) {
        int[] num = this.str2num(numStr);
        for (int i = 1; i < num.length; ++i) {
            int n = i;
            num[n] = num[n] + num[i - 1];
        }
        return num;
    }

    public int[] str2num(String numStr) {
        if (!this.isInteger(numStr)) {
            return new int[0];
        }
        String[] arr = numStr.split("");
        int[] num = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            num[i] = Integer.parseInt(arr[i]);
        }
        return num;
    }

    public String arr2Str(String[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public int getInt(Map<String, Object> map, String key) {
        String str = String.valueOf(map.get(key));
        return Integer.valueOf(str);
    }

    public <T> Map<String, T> obj2Map(Object data) {
        if (data == null) {
            return new HashMap();
        }
        return (Map)data;
    }

    public <T> List<Map<String, T>> obj2List(Object data) {
        if (data == null) {
            return new ArrayList<Map<String, T>>();
        }
        return (List)data;
    }

    public Map<String, String> obj2Map(Map<String, Object> obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : obj.entrySet()) {
            map.put(e.getKey(), String.valueOf(e.getValue()));
        }
        return map;
    }

    public Map<String, Object> map2Obj(Map<String, String> obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, String> e : obj.entrySet()) {
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public String obj2Str(Object obj) {
        try {
            return jsonMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public Map<String, Object> node2Obj(String jsonStr, String path) {
        try {
            if (!this.isEmpty(jsonStr)) {
                JsonNode node = jsonMapper.readTree(jsonStr);
                return this.node2Obj(path == null ? node : node.path(path));
            }
        }
        catch (Exception e) {
            LOG.error("-> node2Obj...");
            e.printStackTrace();
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> node2Obj(String jsonStr) {
        return this.node2Obj(jsonStr, null);
    }

    public Map<String, Object> node2Obj(JsonNode jsonNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jsonNode.isValueNode()) {
            map.put("", jsonNode.asText());
        } else if (jsonNode.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator it = jsonNode.iterator();
            while (it.hasNext()) {
                Map<String, Object> child = this.node2Obj((JsonNode)it.next());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    list.add(child.get(""));
                    continue;
                }
                list.add(child);
            }
            map.put("", list);
        } else {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entity = (Map.Entry)it.next();
                Map<String, Object> child = this.node2Obj((JsonNode)entity.getValue());
                if (child.keySet().size() == 1 && child.keySet().contains("")) {
                    map.put((String)entity.getKey(), child.get(""));
                    continue;
                }
                map.put((String)entity.getKey(), child);
            }
        }
        return map;
    }

    public <T> Map<String, T> json2Map(String str) {
        Map map = new HashMap();
        if (this.isEmpty(str)) {
            return map;
        }
        try {
            map = (Map)jsonMapper.readValue(str, new typeRef());
        }
        catch (Exception e) {
            LOG.error("-> json2Map...");
            e.printStackTrace();
        }
        if (str.length() > 200) {
            LOG.debug("-> json2Map..." + str.substring(0, 200) + "...");
        } else {
            LOG.debug("-> json2Map..." + str);
        }
        return map;
    }

    public <T> List<Map<String, T>> json2List(String str) {
        List<Map<String, Object>> list = new ArrayList<Map<String, T>>();
        if (this.isEmpty(str)) {
            return list;
        }
        try {
            list = (List)jsonMapper.readValue(str, new typeRef());
        }
        catch (Exception e) {
            LOG.error("-> json2List..." + e.getMessage());
        }
        if (str.length() > 200) {
            LOG.debug("-> json2List..." + str.substring(0, 200) + "...");
        } else {
            LOG.debug("-> json2List..." + str);
        }
        return list;
    }

    public Map<String, Map<String, String>> list2Map(List<Map<String, String>> list, String key) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (list != null && key != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> item = list.get(i);
                map.put(item.get(key), item);
            }
        }
        return map;
    }

    public Map<String, String> list2Map(List<Map<String, String>> list, String key, String val) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list != null && key != null && val != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, String> item = list.get(i);
                map.put(item.get(key), item.get(val));
            }
        }
        return map;
    }

    public Map<String, String> result(String status) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", status);
        return result;
    }

    public Map<String, String> result(boolean status) {
        return this.result(status ? "1" : "0");
    }

    public Map<String, String> result(String status, String info) {
        Map<String, String> result = this.result(status);
        if (info != null) {
            result.put("info", info);
        }
        return result;
    }

    public Object result(Map<String, String> map) {
        if (map.containsKey("status")) {
            return map;
        }
        return this.success(map);
    }

    public Map<String, String> failed(String info) {
        Map<String, String> result = this.result("0");
        result.put("info", info);
        return result;
    }

    public Map<String, String> success() {
        return this.result("1");
    }

    public Map<String, String> success(String info) {
        return this.result("1", info);
    }

    public Map<String, Object> success(Object obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "1");
        result.put("info", obj);
        return result;
    }

    public Map<String, String> success(Object obj, HttpServletRequest req) {
        String cert = String.valueOf(req.getAttribute("certId"));
        String info = Digest.decrypt(this.obj2Str(obj), cert);
        return this.result("1", info);
    }

    public Map<String, String> newToken(HttpServletRequest req, HttpServletResponse rsp, String userId, String ip) {
        String certId = Digest.randKey();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", Digest.encrypt(userId, certId));
        map.put("token", Digest.uuid8());
        map.put("certId", certId);
        map.put("ipAddr", ip);
        map.put("uuid", (String)map.get("token"));
        LOG.info("-> newToken..." + map);
        this.setCookies(req, rsp, map);
        return map;
    }

    public Map<String, String> findIn(List<Map<String, String>> list, String key, String val) {
        if (list == null || key == null || val == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!val.equals(list.get(i).get(key))) continue;
            return list.get(i);
        }
        return null;
    }

    public boolean findIn(List<String> list, String str) {
        if (list == null || str == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(str)) continue;
            return true;
        }
        return false;
    }

    public boolean findIn(String[] arr, String str) {
        if (arr == null || str == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public boolean findIn(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        return Pattern.compile(regex).matcher(str).find();
    }

    public boolean isMatch(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        Pattern p = Pattern.compile(regex);
        return p.matcher(str).matches();
    }

    public boolean isInteger(String str) {
        return this.isMatch(str, "^-?\\d+$");
    }

    public boolean isNumeric(String str) {
        return this.isMatch(str, "^(-?\\d+)(\\.\\d+)?$");
    }

    public boolean isIdcard(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        return this.isMatch(str, "^\\d{17}[\\dXx]$");
    }

    public boolean isMobile(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        return this.isMatch(str, "^1[3-9]\\d{9}");
    }

    public boolean isDatetime(String str) {
        try {
            new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String timeFormat(String strTime, String pat0, String par1) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(pat0);
        try {
            cal.setTime(sdf.parse(strTime));
        }
        catch (ParseException e) {
            LOG.error("-> timeFormat...");
            e.printStackTrace();
        }
        sdf = new SimpleDateFormat(par1);
        return sdf.format(cal.getTime());
    }

    public long timeDiff(Date begin, Date end) {
        long sec = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        sec = cal.getTimeInMillis();
        cal.setTime(begin);
        return sec -= cal.getTimeInMillis();
    }

    public long timeDiff(String begin, String end) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (end == null) {
                end = this.today("yyyy-MM-dd HH:mm:ss");
            }
            if (begin != null) {
                return this.timeDiff(sdf.parse(begin), sdf.parse(end));
            }
        }
        catch (ParseException e) {
            LOG.error("-> timeDiff...");
            e.printStackTrace();
        }
        return 0L;
    }

    public String today(String pattern) {
        return this.today(pattern, Calendar.getInstance());
    }

    private String today(String pattern, Calendar cal) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(cal.getTime());
    }

    public String nextYear(String pattern, int y) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, y);
        return this.today(pattern, cal);
    }

    public String nextMonth(String month, int m) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(month));
        }
        catch (ParseException e) {
            LOG.error("-> nextMonth...");
            e.printStackTrace();
        }
        cal.add(2, m);
        return sdf.format(cal.getTime());
    }

    public String nextMonth(String month) {
        return this.nextMonth(month, 1);
    }

    public String prevMonth(String month, int m) {
        return this.nextMonth(month, -m);
    }

    public String prevMonth(String month) {
        return this.prevMonth(month, 1);
    }

    public String[] getHost(String uri) {
        int idx = uri.indexOf("://");
        uri = idx > 0 ? uri.substring(idx + 3) : uri;
        idx = uri.indexOf(47);
        uri = idx > 0 ? uri.substring(0, idx) : uri;
        return uri.split(":");
    }

    public String getRequestURI(HttpServletRequest req) {
        LOG.info("-> HttpRequest..." + req.getHeader("Referer"));
        String uri = req.getRequestURI();
        LOG.info("-> HttpRequest..." + uri);
        return uri.substring(uri.lastIndexOf(47) + 1);
    }

    private String getDomain(HttpServletRequest req) {
        String ref = req.getHeader("Referer");
        LOG.info("-> host..." + ref);
        String host = this.getHost(ref)[0];
        LOG.debug("-> getDomain..." + host);
        String[] arr = host.split("\\.");
        return arr.length == 3 ? arr[1] + "." + arr[2] : host;
    }

    public void setCookies(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> map) {
        if (map == null) {
            return;
        }
        String domain = this.getDomain(req);
        for (Map.Entry<String, String> e : map.entrySet()) {
            String val = Digest.encodeURIComponent(e.getValue());
            Cookie c = new Cookie(e.getKey(), val);
            c.setDomain(domain);
            c.setPath("/");
            rsp.addCookie(c);
        }
    }

    public Map<String, String> getCookies(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return map;
        }
        for (Cookie c : cookies) {
            String val = Digest.decodeURIComponent(c.getValue());
            map.put(c.getName(), val);
        }
        return map;
    }

    public String getCookie(HttpServletRequest req, String key) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                return Digest.decodeURIComponent(c.getValue());
            }
        }
        return null;
    }

    public void delCookie(HttpServletRequest req, HttpServletResponse rsp, String key) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                c.setDomain(this.getDomain(req));
                c.setPath("/");
                c.setMaxAge(0);
                rsp.addCookie(c);
                break;
            }
        }
    }

    public void clearCookies(HttpServletRequest req, HttpServletResponse rsp) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            String domain = this.getDomain(req);
            for (Cookie c : cookies) {
                c.setDomain(domain);
                c.setPath("/");
                c.setMaxAge(0);
                rsp.addCookie(c);
            }
        }
    }

    public String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }

    public String getClientIp(HttpServletRequest req) {
        String ip = req.getHeader("X-Forwarded-For");
        LOG.info("-> X-Forwarded-For..." + ip);
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(44) > 0) {
            ip = ip.substring(0, ip.indexOf(44));
        }
        return ip;
    }

    public String getLocale(HttpServletRequest req) {
        return req.getLocale().getLanguage();
    }

    public final String[] getLocales() {
        return this.getConf("i18n.locales").split(",");
    }

    public String buildQuery(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isJoint = false;
        for (Map.Entry<String, String> e : params.entrySet()) {
            String val;
            String key;
            if (isJoint) {
                sb.append("&");
            } else {
                isJoint = true;
            }
            if (!this.notEmpty(key = e.getKey(), val = e.getValue())) continue;
            sb.append(key).append("=").append(Digest.urlEncode(val));
        }
        return sb.toString();
    }

    public boolean notEmpty(String ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!this.isEmpty(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        return false;
    }

    public <T> boolean isEmpty(Map<String, T> map) {
        return map == null || map.isEmpty();
    }

    public int toStep(int min, int max, int step) {
        int num = min + step;
        if (num > max) {
            num = max;
        }
        return num;
    }

    public void close(Closeable ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toYuan(String money) {
        return this.toYuan(money, null);
    }

    public String toYuan(String money, String blank) {
        try {
            double d = (double)Long.parseLong(money) / 100.0;
            return new DecimalFormat("#,##0.00").format(d);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return blank == null ? "0.00" : blank;
        }
    }

    public String toCent(String money) {
        return this.toCent(money, null);
    }

    public String toCent(String money, String blank) {
        try {
            double d = Double.valueOf(money.replace(",", ""));
            return new DecimalFormat("#0").format(d * 100.0);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return blank == null ? "0" : blank;
        }
    }

    public String toRmb(String money) {
        String head = "";
        String s = "";
        if (money.startsWith("-")) {
            money = money.substring(1);
            head = "\u8d1f";
        }
        money = money.replaceAll("^0+", "");
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] units = new String[][]{{"\u5206", "\u89d2", "\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        int[] arr = this.str2num(new StringBuffer(money).reverse().toString());
        for (int i = 0; i < arr.length; ++i) {
            if (i < 2) {
                s = digit[arr[i]] + units[0][i] + s;
                continue;
            }
            for (int n = 2; n < units[0].length && i < arr.length; ++n) {
                String p = "";
                for (int j = 0; j < units[1].length && i < arr.length; ++i, ++j) {
                    p = digit[arr[i]] + units[1][j] + p;
                }
                p = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6");
                s = p + units[0][n] + s;
            }
        }
        s = s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceAll("(\u96f6.)+", "\u96f6");
        return head + s.replaceAll("\u96f6$", "\u6574");
    }

    public String toRmb(long n) {
        return this.toRmb(String.valueOf(n));
    }

    public String encodeIdcard(String str) {
        if (!this.isIdcard(str)) {
            return null;
        }
        return Digest.enBase62(str, 1);
    }

    public String decodeIdcard(String str) {
        return Digest.deBase62(str, 1);
    }

    public String encodeMobile(String str) {
        if (!this.isIdcard(str)) {
            return null;
        }
        return Digest.enBase62(str, 0);
    }

    public String decodeMobile(String str) {
        return Digest.deBase62(str, 0);
    }

    class typeRef<T>
    extends TypeReference<T> {
        typeRef() {
        }
    }
}

