/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.HttpService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
    private static String AppKey = null;
    private static String Md5Key = null;
    @Autowired
    private AolaiService aolaiSvc;
    @Autowired
    private HttpService httpSvc;
    @Autowired
    private RedisService redisSvc;
    @Autowired
    private UtilsService utilsSvc;

    private boolean checkAppKey(Object k) {
        if (Md5Key == null) {
            AppKey = this.utilsSvc.getConf("app.key");
            Md5Key = DigestUtils.md5Hex((String)AppKey);
        }
        return AppKey.equals(k) || Md5Key.equals(k);
    }

    public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) {
        if (!cookies.containsKey("userId") || cookies.containsKey("bindId")) {
            // empty if block
        }
        return false;
    }

    public boolean isSecretKey(HttpServletRequest req) {
        String jsonStr = req.getParameter("jsonstr");
        String k = req.getParameter("k");
        if (k == null) {
            return false;
        }
        if (this.checkAppKey(k)) {
            if (jsonStr == null) {
                return true;
            }
            return this.setAttr(req, this.utilsSvc.json2Map(jsonStr), k);
        }
        String ticket = this.redisSvc.get("k." + k);
        if (ticket == null) {
            return false;
        }
        Map map = this.utilsSvc.json2Map(jsonStr = Digest.decrypt(jsonStr, ticket + k));
        if (!ticket.equals(map.get("ticket"))) {
            return false;
        }
        String certKey = this.redisSvc.get("a." + ticket);
        if (certKey != null && k.equals(certKey)) {
            return this.setAttr(req, map, certKey);
        }
        return false;
    }

    private boolean setAttr(HttpServletRequest req, Object obj, Object certStr) {
        req.setAttribute("json", obj);
        req.setAttribute("certId", certStr);
        return true;
    }

    public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) throws Exception {
        String appKey;
        String cert = cookies.get("certId");
        String userId = Digest.decrypt(cookies.get("userId"), cert);
        Map<String, String> user = this.redisSvc.getUserInfo(userId);
        if (user == null) {
            this.redisSvc.clearToken(cookies);
            return this.invlidToken(rsp);
        }
        Map<String, Object> tmp = this.utilsSvc.json2Map(user.get("userDuty"));
        if (!tmp.containsKey(appKey = this.utilsSvc.getConf("app.code"))) {
            return this.invlidParams(rsp);
        }
        String uri = this.utilsSvc.getRequestURI(req);
        String args = this.utilsSvc.getValid(uri);
        LOG.info("-> authAccess..." + uri + tmp.toString());
        tmp = this.decryptParams(req, user, cert);
        if (args.length() > 0 && !this.utilsSvc.availParams(tmp, args.split(";"))) {
            return this.invlidParams(rsp);
        }
        return true;
    }

    private Map<String, Object> decryptParams(HttpServletRequest req, Map<String, String> user, String certId) {
        req.setAttribute("user", user);
        req.setAttribute("userId", (Object)user.get("userId"));
        req.setAttribute("certId", (Object)certId);
        String jsonStr = req.getParameter("jsonstr");
        HashMap<String, Object> params = new HashMap();
        if (jsonStr != null) {
            jsonStr = Digest.decrypt(jsonStr, certId);
            params = this.utilsSvc.json2Map(jsonStr);
        }
        LOG.info("-> jsonStr..." + ((Object)params).toString());
        req.setAttribute("json", params);
        return params;
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter out = rsp.getWriter();
        out.write(this.utilsSvc.obj2Str(this.utilsSvc.result(status)));
        out.flush();
        out.close();
        return false;
    }

    public boolean invlidToken(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "3");
    }

    public boolean invlidParams(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "2");
    }
}

