/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpService {
    private static Logger LOG = LoggerFactory.getLogger(HttpService.class);
    private static Map<String, String> headers = new HashMap<String, String>();
    private static RequestConfig CONF;
    private static String APP_KEY;
    @Autowired
    private UtilsService utilsSvc = new UtilsService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doRequest(HttpUriRequest httpUri) {
        CloseableHttpClient http = HttpClientBuilder.create().build();
        CloseableHttpResponse rsp = null;
        String result = null;
        try {
            rsp = http.execute(httpUri);
            result = this.getResponse((HttpResponse)rsp);
        }
        catch (Exception e) {
            try {
                LOG.error("-> doRequest...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utilsSvc.close(new Closeable[]{http, rsp});
                throw throwable;
            }
            this.utilsSvc.close(new Closeable[]{http, rsp});
        }
        this.utilsSvc.close(new Closeable[]{http, rsp});
        return result;
    }

    public String httpGet(String url, Map<String, String> params) {
        HttpGet httpGet = new HttpGet(this.setUrl(url, params));
        httpGet.setConfig(CONF);
        this.setHeaders((HttpMessage)httpGet, url);
        return this.doRequest((HttpUriRequest)httpGet);
    }

    public String httpPost(String url, Map<String, String> params) {
        UrlEncodedFormEntity entity = null;
        try {
            entity = new UrlEncodedFormEntity(this.setParams(params), "UTF-8");
        }
        catch (Exception e) {
            LOG.error("-> doPost...");
            e.printStackTrace();
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(CONF);
        httpPost.setEntity((HttpEntity)entity);
        this.setHeaders((HttpMessage)httpPost, url);
        return this.doRequest((HttpUriRequest)httpPost);
    }

    public String httpPost(String url, String cookieHeader, Map<String, String> params) {
        if (cookieHeader != null) {
            headers.put("Cookie", cookieHeader);
        }
        return this.httpPost(url, params);
    }

    private String setUrl(String url, Map<String, String> params) {
        if (params != null && params.size() > 0) {
            String args = "";
            for (Map.Entry<String, String> e : params.entrySet()) {
                args = args + "&" + e.getKey() + "=" + Digest.urlEncode(e.getValue());
            }
            if (args.length() > 0) {
                url = url + args.substring(1);
            }
        }
        return url;
    }

    private void setHeaders(HttpMessage msg, String url) {
        msg.addHeader("Referer", this.utilsSvc.getConf("app.core"));
        msg.addHeader("Host", this.utilsSvc.getHost(url)[0]);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            msg.addHeader(e.getKey(), e.getValue());
        }
    }

    private List<NameValuePair> setParams(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                if (this.utilsSvc.isEmpty(val)) continue;
                nvpList.add((NameValuePair)new BasicNameValuePair(key, val));
            }
        }
        return nvpList;
    }

    private CloseableHttpClient digestHttpClient(String user, String pass) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
        HttpClientBuilder http = HttpClientBuilder.create();
        http.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        return http.build();
    }

    private RequestBuilder setBuilder(HttpEntity entity, String method) {
        RequestBuilder request = null;
        if ("POST".equals(method)) {
            request = RequestBuilder.post();
        } else if ("GET".equals(method)) {
            request = RequestBuilder.get();
        } else if ("PUT".equals(method)) {
            request = RequestBuilder.put();
        } else if ("DELETE".equals(method)) {
            request = RequestBuilder.delete();
        }
        return request.setEntity(entity);
    }

    private String getResponse(HttpResponse rsp) throws Exception {
        String result = null;
        HttpEntity entity = rsp.getEntity();
        int statusCode = rsp.getStatusLine().getStatusCode();
        if (statusCode == 200 && entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            int len = result.length();
            LOG.debug(len > 200 ? result.substring(0, 200) : result);
        } else {
            LOG.error("-> getResponse..." + rsp.getStatusLine());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String digestRequest(String userName, String password, HttpUriRequest uriRequest) {
        CloseableHttpClient http = this.digestHttpClient(userName, password);
        CloseableHttpResponse rsp = null;
        String result = null;
        try {
            rsp = http.execute(uriRequest);
            result = this.getResponse((HttpResponse)rsp);
        }
        catch (Exception e) {
            try {
                LOG.error("-> digestRequest...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utilsSvc.close(new Closeable[]{http, rsp});
                throw throwable;
            }
            this.utilsSvc.close(new Closeable[]{http, rsp});
        }
        this.utilsSvc.close(new Closeable[]{http, rsp});
        return result;
    }

    public String digestJsonRequest(String userName, String password, String url, String json, String method) {
        LOG.info(json);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        entity.setContentEncoding("UTF-8");
        RequestBuilder builder = this.setBuilder((HttpEntity)entity, method);
        HttpUriRequest request = builder.setUri(url).build();
        json = this.digestRequest(userName, password, request);
        LOG.info(json);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean digestDownload(String userName, String password, String url, String filePath) {
        boolean bl;
        CloseableHttpClient http = this.digestHttpClient(userName, password);
        CloseableHttpResponse rsp = null;
        boolean result = false;
        try {
            HttpGet request = new HttpGet(url);
            rsp = http.execute((HttpUriRequest)request);
            HttpEntity entity = rsp.getEntity();
            InputStream ins = entity.getContent();
            FileOutputStream fos = new FileOutputStream(filePath, false);
            int data = ins.read();
            while (data != -1) {
                fos.write(data);
                data = ins.read();
            }
            fos.close();
            EntityUtils.consume((HttpEntity)entity);
            bl = true;
        }
        catch (Exception e) {
            try {
                LOG.error("-> digestDownload...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utilsSvc.close(new Closeable[]{http, rsp});
                throw throwable;
            }
            this.utilsSvc.close(new Closeable[]{http, rsp});
            return result;
        }
        this.utilsSvc.close(new Closeable[]{http, rsp});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String rspAsString(InputStream in) {
        StringBuilder strBuf = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
        }
        catch (IOException e) {
            try {
                LOG.error("-> rspAsString...");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.utilsSvc.close(reader);
                throw throwable;
            }
            this.utilsSvc.close(reader);
        }
        this.utilsSvc.close(reader);
        return strBuf.toString();
    }

    private HttpURLConnection setProperty(HttpURLConnection conn) {
        conn.setConnectTimeout(120000);
        conn.setReadTimeout(120000);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            conn.setRequestProperty(e.getKey(), e.getValue());
        }
        return conn;
    }

    public String urlConnect(String url, byte[] bytes, String method) {
        String result = "";
        HttpURLConnection conn = null;
        try {
            LOG.debug("-> urlConnect..." + url);
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            this.setProperty(conn).setRequestMethod(method);
            conn.getOutputStream().write(bytes);
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 204) {
                result = this.rspAsString(conn.getInputStream());
            } else {
                result = this.rspAsString(conn.getErrorStream());
                LOG.error("-> urlConnect..." + result);
            }
        }
        catch (Exception e) {
            LOG.error("-> urlConnect...");
            e.printStackTrace();
        }
        return result;
    }

    public String urlConnect(String url, Map<String, String> params) {
        return this.urlConnect(this.setUrl(url, params), "".getBytes(), "GET");
    }

    public String urlConnect(String url, String str, String method) {
        String result = "";
        if (str != null) {
            result = this.urlConnect(url, str.getBytes(Const.CHARSET), method);
        }
        return result;
    }

    public String doPost(String url, String jsonStr, String key) {
        LOG.info("-> doPost..." + url);
        if (key == null) {
            key = APP_KEY == null ? this.utilsSvc.getConf("app.key") : APP_KEY;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k", key);
        map.put("jsonstr", jsonStr);
        return this.httpPost(url, map);
    }

    public String doPost(String url, String jsonStr) {
        return this.doPost(url, jsonStr, null);
    }

    public <T> Map<String, T> doPost(String url, Map<String, T> params) {
        String jsonStr = this.doPost(url, this.utilsSvc.obj2Str(params));
        return this.utilsSvc.json2Map(jsonStr);
    }

    public String ssoPost(String ws, String jsonStr) {
        String ssoUrl = this.utilsSvc.getConf("sso.url");
        return this.doPost(ssoUrl + ws, jsonStr);
    }

    public <T> Map<String, T> ssoPost(String ws, Map<String, T> params) {
        String ssoUrl = this.utilsSvc.getConf("sso.url");
        return this.doPost(ssoUrl + ws, params);
    }

    public Map<String, Object> forward(HttpServletRequest req) {
        String ws = this.utilsSvc.getRequestURI(req);
        return this.ssoPost(ws, this.utilsSvc.jsonParams(req));
    }

    public <T> Map<String, T> corePost(String ws, Map<String, T> params) {
        String mstUri = this.utilsSvc.getConf("app.core") + this.utilsSvc.getConf("app.main");
        return this.doPost(mstUri + ws, params);
    }

    static {
        headers.put("Accept", "*/*");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        headers.put("Accept-Language", "zh-CN, zh, en-US");
        headers.put("Cache-Control", "no-cache");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Chrome/97.0.4692.71");
        CONF = RequestConfig.custom().setRedirectsEnabled(false).setConnectTimeout(120000).setSocketTimeout(120000).build();
        APP_KEY = null;
    }
}

