package cn.ps1.aolai.utils;

//import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * 系统配置密码的解码
 * 
 * @author Aolai
 * @since 1.8
 *
 */
public class EncConfigurer extends PropertySourcesPlaceholderConfigurer {
	String[] propKeys = { "jdbc.username", "jdbc.password", "redis.password" };
	
	@Override
	protected String convertProperty(String propKey, String propVal) {
		return isEncrypt(propKey) ? Digest.encrypt(propVal, Digest.KEY) : propVal;
	}

	private boolean isEncrypt(String propKey) {
		if (propKey.indexOf("password") > 0 || propKey.indexOf("username") > 0) {
			return true;
		}
		return false;
	}

	/**
	 * 测试
	 */
	public static void main(String[] args) {
		try {
			System.out.println(Digest.encrypt("root", Digest.KEY));
			System.out.println(Digest.encrypt("ykj1036!", Digest.KEY));
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}

	}
}
